/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.proxy.core.draft;

import com.easy.query.core.basic.jdbc.executor.internal.enumerable.Draft;
import com.easy.query.core.exception.EasyQueryInvalidOperationException;
import com.easy.query.core.expression.builder.AsSelector;
import com.easy.query.core.expression.builder.GroupSelector;
import com.easy.query.core.expression.builder.Selector;
import com.easy.query.core.proxy.ProxyEntity;
import com.easy.query.core.proxy.ProxyEntityAvailable;
import com.easy.query.core.proxy.SQLSelectAsExpression;
import com.easy.query.core.proxy.SQLSelectExpression;
import com.easy.query.core.proxy.ValueObjectProxyEntity;
import com.easy.query.core.proxy.core.draft.DraftFetcher;
import com.easy.query.core.proxy.impl.SQLSelectAsImpl;
import com.easy.query.core.util.EasyArrayUtil;

public class DraftFetcherImpl<T extends ProxyEntityAvailable<T, TProxy> & Draft, TProxy extends ProxyEntity<TProxy, T>>
implements DraftFetcher<T, TProxy> {
    private final T draft;
    private final TProxy draftProxy;
    private SQLSelectAsExpression sqlSelectExpression = SQLSelectAsExpression.empty;
    private final Class<?>[] propTypes;

    public DraftFetcherImpl(T draft, TProxy draftProxy) {
        this.draft = draft;
        this.draftProxy = draftProxy;
        this.propTypes = new Class[((Draft)draft).capacity()];
    }

    @Override
    public void fetch(SQLSelectAsExpression ... selectAsExpressions) {
        if (EasyArrayUtil.isNotEmpty((Object[])selectAsExpressions)) {
            for (SQLSelectAsExpression selectAsExpression : selectAsExpressions) {
                if (selectAsExpression instanceof ValueObjectProxyEntity) {
                    throw new EasyQueryInvalidOperationException("draft result not support value object columns");
                }
                this.sqlSelectExpression = this.sqlSelectExpression._concat(selectAsExpression);
            }
        }
    }

    @Override
    public void fetch(SQLSelectExpression ... selectExpressions) {
        if (EasyArrayUtil.isNotEmpty((Object[])selectExpressions)) {
            for (SQLSelectExpression selectExpression : selectExpressions) {
                if (selectExpression instanceof ValueObjectProxyEntity) {
                    throw new EasyQueryInvalidOperationException("draft result not support value object columns");
                }
                this.sqlSelectExpression = new SQLSelectAsImpl(x -> {
                    this.accept((Selector)x);
                    selectExpression.accept((Selector)x);
                }, x -> {
                    this.accept((AsSelector)x);
                    selectExpression.accept((AsSelector)x);
                }, x -> {
                    throw new UnsupportedOperationException();
                });
            }
        }
    }

    @Override
    public void accept(GroupSelector s) {
        this.sqlSelectExpression.accept(s);
    }

    @Override
    public void accept(AsSelector s) {
        this.sqlSelectExpression.accept(s);
    }

    @Override
    public void accept(Selector s) {
        this.sqlSelectExpression.accept(s);
    }

    @Override
    public T getDraft() {
        return this.draft;
    }

    @Override
    public TProxy getDraftProxy() {
        return this.draftProxy;
    }

    @Override
    public Class<?>[] getDraftPropTypes() {
        return this.propTypes;
    }
}

