/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.proxy;

import com.easy.query.core.basic.api.select.Query;
import com.easy.query.core.expression.lambda.SQLActionExpression;
import com.easy.query.core.expression.lambda.SQLExpression1;
import com.easy.query.core.expression.lambda.SQLFuncExpression;
import com.easy.query.core.expression.parser.core.available.TableAvailable;
import com.easy.query.core.expression.segment.scec.context.SQLNativeExpressionContext;
import com.easy.query.core.proxy.AbstractBaseProxyEntity;
import com.easy.query.core.proxy.PropTypeColumn;
import com.easy.query.core.proxy.ProxyEntity;
import com.easy.query.core.proxy.SQLColumn;
import com.easy.query.core.proxy.core.EntitySQLContext;
import com.easy.query.core.proxy.impl.SQLDraftAsSelectImpl;
import com.easy.query.core.proxy.impl.SQLNativeDraftImpl;
import com.easy.query.core.proxy.sql.scec.SQLNativeProxyExpressionContext;
import com.easy.query.core.proxy.sql.scec.SQLNativeProxyExpressionContextImpl;
import com.easy.query.core.util.EasyObjectUtil;
import java.util.Objects;

public abstract class AbstractProxyEntity<TProxy extends ProxyEntity<TProxy, TEntity>, TEntity>
extends AbstractBaseProxyEntity<TProxy, TEntity> {
    protected <TPropertyProxy extends SQLColumn<TProxy, TProperty>, TProperty> TPropertyProxy getValueObject(TPropertyProxy propertyProxy) {
        return propertyProxy;
    }

    protected String getValueProperty(String property) {
        return property;
    }

    public TableAvailable getTable() {
        Objects.requireNonNull(this.table, "cant found table in sql context");
        return this.table;
    }

    @Override
    public EntitySQLContext getEntitySQLContext() {
        Objects.requireNonNull(this.entitySQLContext, "cant found entitySQLContext in sql context");
        return this.entitySQLContext;
    }

    @Override
    public TProxy create(TableAvailable table, EntitySQLContext entitySQLContext) {
        this.table = table;
        this.entitySQLContext = entitySQLContext;
        return (TProxy)((ProxyEntity)EasyObjectUtil.typeCastNullable((Object)this));
    }

    public void or(SQLActionExpression sqlActionExpression) {
        this.or(true, sqlActionExpression);
    }

    public void or(boolean condition, SQLActionExpression sqlActionExpression) {
        if (condition) {
            this.getEntitySQLContext()._whereOr(sqlActionExpression);
        }
    }

    public void executeSQL(String sqlSegment) {
        this.executeSQL(sqlSegment, (SQLExpression1<SQLNativeProxyExpressionContext>)((SQLExpression1)c -> {}));
    }

    public void executeSQL(String sqlSegment, SQLExpression1<SQLNativeProxyExpressionContext> contextConsume) {
        this.executeSQL(true, sqlSegment, contextConsume);
    }

    public void executeSQL(boolean condition, String sqlSegment, SQLExpression1<SQLNativeProxyExpressionContext> contextConsume) {
        if (condition) {
            this.getEntitySQLContext()._executeNativeSql(sqlSegment, contextConsume);
        }
    }

    public PropTypeColumn<Object> sql(String sqlSegment) {
        return this.sql(sqlSegment, (SQLExpression1<SQLNativeProxyExpressionContext>)((SQLExpression1)c -> {}));
    }

    public PropTypeColumn<Object> sql(String sqlSegment, SQLExpression1<SQLNativeProxyExpressionContext> contextConsume) {
        return new SQLNativeDraftImpl((alias, f) -> f.sqlNativeSegment(sqlSegment, c -> {
            if (alias != null) {
                c.setPropertyAlias(alias);
            }
            contextConsume.apply((Object)new SQLNativeProxyExpressionContextImpl((SQLNativeExpressionContext)c));
        }));
    }

    public <TSubQuery> PropTypeColumn<TSubQuery> subQuery(SQLFuncExpression<Query<TSubQuery>> subQueryableFunc) {
        Query subQueryQuery = (Query)subQueryableFunc.apply();
        return new SQLDraftAsSelectImpl((alias, f) -> f.columnSubQueryAs(() -> subQueryQuery, alias), subQueryQuery.queryClass());
    }
}

