/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.api.proxy.entity;

import com.easy.query.core.common.bean.FastBean;
import com.easy.query.core.common.cache.Cache;
import com.easy.query.core.common.cache.DefaultMemoryCache;
import com.easy.query.core.exception.EasyQueryInvalidOperationException;
import com.easy.query.core.proxy.ProxyEntity;
import com.easy.query.core.proxy.ProxyEntityAvailable;
import com.easy.query.core.util.EasyClassUtil;
import com.easy.query.core.util.EasyObjectUtil;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.function.Supplier;

public class EntityQueryProxyManager {
    private static final Cache<Class<?>, Supplier<Object>> proxyConstructorCache = new DefaultMemoryCache();

    public static <TEntityProxy extends ProxyEntity<TEntityProxy, TEntity>, TEntity extends ProxyEntityAvailable<TEntity, TEntityProxy>> TEntityProxy create(Class<TEntity> entityClass) {
        if (entityClass == null) {
            throw new IllegalArgumentException("entityClass is null");
        }
        Supplier creator = (Supplier)proxyConstructorCache.get(entityClass);
        if (creator != null) {
            Object proxy = creator.get();
            return (TEntityProxy)((ProxyEntity)EasyObjectUtil.typeCast(proxy));
        }
        Class proxyTableClass = Arrays.stream(entityClass.getGenericInterfaces()).map(t -> {
            Type actualTypeArgument;
            Type[] actualTypeArguments;
            ParameterizedType parameterizedType;
            Type rawType;
            if (t instanceof ParameterizedType && (rawType = (parameterizedType = (ParameterizedType)t).getRawType()) instanceof Class && ProxyEntityAvailable.class.isAssignableFrom((Class)rawType) && (actualTypeArguments = parameterizedType.getActualTypeArguments()).length == 2 && (actualTypeArgument = actualTypeArguments[1]) instanceof Class) {
                return (Class)actualTypeArgument;
            }
            return null;
        }).filter(t -> t != null).findFirst().orElse(null);
        if (proxyTableClass == null) {
            throw new EasyQueryInvalidOperationException(String.format("%s is not implements ProxyEntityAvailable", EasyClassUtil.getSimpleName(entityClass)));
        }
        FastBean fastBean = new FastBean(proxyTableClass);
        Supplier beanConstructorCreator = fastBean.getBeanConstructorCreator();
        Supplier objectSupplier = (Supplier)proxyConstructorCache.computeIfAbsent(entityClass, arg_0 -> EntityQueryProxyManager.lambda$create$2((Supplier)beanConstructorCreator, arg_0));
        Object proxy = objectSupplier.get();
        return (TEntityProxy)((ProxyEntity)EasyObjectUtil.typeCast(proxy));
    }

    private static /* synthetic */ Supplier lambda$create$2(Supplier beanConstructorCreator, Class key) {
        return beanConstructorCreator;
    }
}

