package com.easy.query.api.proxy.entity.select.include.impl;

import com.easy.query.api.proxy.entity.EntityQueryProxyManager;
import com.easy.query.api.proxy.entity.select.EntityQueryable;
import com.easy.query.api.proxy.entity.select.impl.EasyEntityQueryable;
import com.easy.query.api.proxy.entity.select.include.IncludeEntityQueryable;
import com.easy.query.core.basic.api.select.ClientQueryable;
import com.easy.query.core.common.ValueHolder;
import com.easy.query.core.expression.lambda.SQLExpression1;
import com.easy.query.core.expression.lambda.SQLFuncExpression1;
import com.easy.query.core.proxy.ProxyEntity;
import com.easy.query.core.proxy.ProxyEntityAvailable;
import com.easy.query.core.proxy.columns.SQLQueryable;

import java.util.Objects;

/**
 * create time 2024/3/11 08:23
 * 文件说明
 *
 * @author xuejiaming
 */
public class EasyIncludeEntityQueryable<T1Proxy extends ProxyEntity<T1Proxy, T1>, T1,T2Proxy extends ProxyEntity<T2Proxy, T2>, T2> extends EasyEntityQueryable<T1Proxy,T1> implements IncludeEntityQueryable<T1Proxy, T1, T2Proxy, T2> {
    protected final T2Proxy t2Proxy;

    public EasyIncludeEntityQueryable(T1Proxy t1Proxy, T2Proxy t2Proxy, ClientQueryable<T1> entityQueryable) {
        super(t1Proxy, entityQueryable);
        this.t2Proxy = t2Proxy;
    }

    @Override
    public IncludeEntityQueryable<T1Proxy, T1,T2Proxy,T2> cloneQueryable() {
        return new EasyIncludeEntityQueryable<>(t1Proxy,t2Proxy, clientQueryable.cloneQueryable());
    }

    @Override
    public <TPropertyProxy extends ProxyEntity<TPropertyProxy, TProperty>, TProperty extends ProxyEntityAvailable<TProperty, TPropertyProxy>> IncludeEntityQueryable<T1Proxy, T1, T2Proxy, T2> thenInclude(boolean condition, SQLFuncExpression1<T2Proxy, TPropertyProxy> navigateIncludeSQLExpression, SQLExpression1<EntityQueryable<TPropertyProxy, TProperty>> includeAdapterExpression, Integer groupSize) {
        if (condition) {

            ValueHolder<TPropertyProxy> valueHolder = new ValueHolder<>();
            t1Proxy.getEntitySQLContext()._include(() -> {
                TPropertyProxy navigateColumn = navigateIncludeSQLExpression.apply(t2Proxy);
                valueHolder.setValue(navigateColumn);
            });
            return include0(valueHolder.getValue(), includeAdapterExpression, groupSize);
        }
        return this;
    }
    private <TPropertyProxy extends ProxyEntity<TPropertyProxy, TProperty>, TProperty extends ProxyEntityAvailable<TProperty, TPropertyProxy>> IncludeEntityQueryable<T1Proxy, T1, T2Proxy, T2> include0(TPropertyProxy navigateColumn, SQLExpression1<EntityQueryable<TPropertyProxy, TProperty>> includeAdapterExpression, Integer groupSize) {

        Objects.requireNonNull(navigateColumn.getNavValue(), "include [navValue] is null");
        getClientQueryable().<TProperty>include(navigateInclude -> {
            ClientQueryable<TProperty> clientQueryable = navigateInclude.with(navigateColumn.getNavValue(), groupSize);
            TPropertyProxy tPropertyProxy = EntityQueryProxyManager.create(clientQueryable.queryClass());
            EasyEntityQueryable<TPropertyProxy, TProperty> entityQueryable = new EasyEntityQueryable<>(tPropertyProxy, clientQueryable);
            includeAdapterExpression.apply(entityQueryable);
            return entityQueryable.getClientQueryable();
        });

        return this;
    }

    @Override
    public <TPropertyProxy extends ProxyEntity<TPropertyProxy, TProperty>, TProperty extends ProxyEntityAvailable<TProperty, TPropertyProxy>> IncludeEntityQueryable<T1Proxy, T1, T2Proxy, T2> thenIncludes(boolean condition, SQLFuncExpression1<T2Proxy, SQLQueryable<TPropertyProxy, TProperty>> navigateIncludeSQLExpression, SQLExpression1<EntityQueryable<TPropertyProxy, TProperty>> includeAdapterExpression, Integer groupSize) {
        if (condition) {

            ValueHolder<TPropertyProxy> valueHolder = new ValueHolder<>();
            t1Proxy.getEntitySQLContext()._include(() -> {
                SQLQueryable<TPropertyProxy, TProperty> navigateColumnQueryable = navigateIncludeSQLExpression.apply(t2Proxy);
                TPropertyProxy navigateColumn = navigateColumnQueryable.getProxy();
                valueHolder.setValue(navigateColumn);
            });

            return include0(valueHolder.getValue(), includeAdapterExpression, groupSize);
        }
        return this;
    }
}
