/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.api.proxy.entity.select.impl;

import com.easy.query.api.proxy.entity.EntityQueryProxyManager;
import com.easy.query.core.basic.api.select.ClientQueryable;
import com.easy.query.core.context.QueryRuntimeContext;
import com.easy.query.core.exception.EasyQueryInvalidOperationException;
import com.easy.query.core.expression.lambda.Property;
import com.easy.query.core.expression.sql.builder.EntityExpressionBuilder;
import com.easy.query.core.metadata.ColumnMetadata;
import com.easy.query.core.metadata.EntityMetadata;
import com.easy.query.core.metadata.EntityMetadataManager;
import com.easy.query.core.metadata.NavigateMetadata;
import com.easy.query.core.proxy.ProxyEntity;
import com.easy.query.core.proxy.SQLSelectAsExpression;
import com.easy.query.core.proxy.core.FlatEntitySQLContext;
import com.easy.query.core.util.EasyObjectUtil;
import com.easy.query.core.util.EasyStringUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

public class EasySelectFlatQueryable<TProxy extends ProxyEntity<TProxy, TEntity>, TEntity> {
    private final ClientQueryable<?> queryable;
    private final QueryRuntimeContext runtimeContext;
    private final Property<Object, Collection<?>> navigateGetter;
    private final boolean resultBasicType;
    private final ColumnMetadata columnMetadata;

    public EasySelectFlatQueryable(ClientQueryable<?> queryable, String navValue, TProxy tProxy) {
        NavigateMetadata firstNavigateMetadata;
        if (!(tProxy.getEntitySQLContext() instanceof FlatEntitySQLContext)) {
            throw new EasyQueryInvalidOperationException("flatElement result only allowed use in toList");
        }
        this.runtimeContext = queryable.getSQLEntityExpressionBuilder().getRuntimeContext();
        this.resultBasicType = tProxy.getNavValue() == null && tProxy.getValue() != null;
        EntityMetadata entityMetadata = queryable.getSQLEntityExpressionBuilder().getTable(0).getEntityMetadata();
        EntityMetadataManager entityMetadataManager = this.runtimeContext.getEntityMetadataManager();
        EntityMetadata queryEntityMetadata = this.runtimeContext.getEntityMetadataManager().getEntityMetadata(queryable.queryClass());
        String[] navValueSplit = navValue.split("\\.");
        String firstNavValue = navValueSplit[0];
        NavigateMetadata currentNavigateMetadata = firstNavigateMetadata = queryEntityMetadata.getNavigateNotNull(firstNavValue);
        EntityMetadata currentEntityMetadata = entityMetadataManager.getEntityMetadata(currentNavigateMetadata.getNavigatePropertyType());
        ArrayList<Property> replyExpressions = new ArrayList<Property>();
        replyExpressions.add(currentNavigateMetadata.getGetter());
        for (int i = 1; i < navValueSplit.length; ++i) {
            String currentNavValue = navValueSplit[i];
            currentNavigateMetadata = currentEntityMetadata.getNavigateNotNull(currentNavValue);
            currentEntityMetadata = entityMetadataManager.getEntityMetadata(currentNavigateMetadata.getNavigatePropertyType());
            replyExpressions.add(currentNavigateMetadata.getGetter());
        }
        this.columnMetadata = this.resultBasicType ? currentEntityMetadata.getColumnNotNull(tProxy.getValue()) : null;
        this.navigateGetter = (Property & Serializable)obj -> {
            if (obj == null) {
                return null;
            }
            Iterator iterator = replyExpressions.iterator();
            Property first = (Property)iterator.next();
            Collection collectionValues = this.getCollectionValue(obj, first);
            while (iterator.hasNext()) {
                Property getter = (Property)iterator.next();
                boolean hasNext = iterator.hasNext();
                collectionValues = collectionValues.stream().map(o -> this.getCollectionValue(o, getter)).flatMap(o -> o.stream()).filter(o -> o != null).map(o -> this.getEndValue(o, hasNext)).distinct().collect(Collectors.toList());
            }
            return collectionValues;
        };
        ClientQueryable select = queryable.select(o -> o.column(firstNavigateMetadata.getSelfPropertyOrPrimary()));
        this.selectAutoInclude0(this.runtimeContext.getEntityMetadataManager(), select, entityMetadata, navValue, tProxy);
        this.queryable = select;
    }

    private Object getEndValue(Object entity, boolean hasNext) {
        if (!hasNext && this.resultBasicType) {
            return this.columnMetadata.getGetterCaller().apply(entity);
        }
        return entity;
    }

    private Collection<Object> getCollectionValue(Object obj, Property<Object, ?> getter) {
        Object value = getter.apply(obj);
        if (value == null) {
            return Collections.emptyList();
        }
        if (value instanceof Collection) {
            return (Collection)value;
        }
        return Collections.singletonList(value);
    }

    private void selectAutoInclude0(EntityMetadataManager entityMetadataManager, ClientQueryable<?> clientQueryable, EntityMetadata entityMetadata, String navigateProperties, TProxy tProxy) {
        if (EasyStringUtil.isBlank((String)navigateProperties)) {
            return;
        }
        int i = navigateProperties.indexOf(".");
        String navigateProperty = i >= 0 ? navigateProperties.substring(0, i) : navigateProperties;
        String nextNavigateProperty = i >= 0 ? navigateProperties.substring(i + 1) : null;
        clientQueryable.include(t -> {
            ClientQueryable with = t.with(navigateProperty);
            NavigateMetadata navigateMetadata = entityMetadata.getNavigateNotNull(navigateProperty);
            EntityMetadata entityEntityMetadata = entityMetadataManager.getEntityMetadata(navigateMetadata.getNavigatePropertyType());
            this.selectAutoInclude0(entityMetadataManager, with, entityEntityMetadata, nextNavigateProperty, tProxy);
            if (nextNavigateProperty == null) {
                FlatEntitySQLContext flatEntitySQLContext;
                if (this.resultBasicType) {
                    return with.select(x -> x.column(tProxy.getValue()));
                }
                if (tProxy.getEntitySQLContext() instanceof FlatEntitySQLContext && (flatEntitySQLContext = (FlatEntitySQLContext)tProxy.getEntitySQLContext()).getSelectAsExpressionFunction() != null) {
                    Class queryClass = with.queryClass();
                    return with.select(x -> {
                        SQLSelectAsExpression sqlSelectAsExpression = (SQLSelectAsExpression)flatEntitySQLContext.getSelectAsExpressionFunction().apply(EasyObjectUtil.typeCastNullable(EntityQueryProxyManager.create((Class)EasyObjectUtil.typeCastNullable((Object)queryClass)).create(x.getTable(), (EntityExpressionBuilder)with.getSQLEntityExpressionBuilder(), x.getRuntimeContext())));
                        sqlSelectAsExpression.accept(x.getSelector());
                    });
                }
                return with;
            }
            return with.select(c -> {
                Collection keyProperties = entityMetadata.getKeyProperties();
                for (String keyProperty : keyProperties) {
                    c.column(keyProperty);
                }
            });
        });
    }

    public <TR> List<TR> toList() {
        List entities = this.queryable.toList(this.queryable.queryClass());
        return entities.stream().map(o -> (Collection)this.getNavigates(o)).flatMap(o -> o.stream()).filter(o -> o != null).distinct().collect(Collectors.toList());
    }

    protected <TResult> TResult getNavigates(Object entity) {
        if (entity != null) {
            Collection values = (Collection)this.navigateGetter.apply(entity);
            if (values == null) {
                return null;
            }
            return (TResult)EasyObjectUtil.typeCastNullable((Object)values);
        }
        return null;
    }
}

