/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.proxy.impl.duration;

import com.easy.query.core.exception.EasyQueryInvalidOperationException;
import com.easy.query.core.func.SQLFunc;
import com.easy.query.core.func.SQLFunction;
import com.easy.query.core.func.def.enums.DateTimeDurationEnum;
import com.easy.query.core.proxy.extension.functions.ColumnDateTimeFunctionAvailable;
import com.easy.query.core.proxy.extension.functions.executor.ColumnFunctionCompareComparableNumberChainExpression;
import com.easy.query.core.proxy.extension.functions.executor.impl.ColumnFunctionCompareComparableNumberChainExpressionImpl;
import com.easy.query.core.proxy.predicate.aggregate.DSLSQLFunctionAvailable;
import java.time.LocalDateTime;

public class DurationExpression {
    private final ColumnDateTimeFunctionAvailable<?> before;
    private LocalDateTime afterConstant;
    private ColumnDateTimeFunctionAvailable<?> afterColumn;

    public DurationExpression(ColumnDateTimeFunctionAvailable<?> before, LocalDateTime afterConstant) {
        this.before = before;
        this.afterConstant = afterConstant;
    }

    public DurationExpression(ColumnDateTimeFunctionAvailable<?> before, ColumnDateTimeFunctionAvailable<?> afterColumn) {
        this.before = before;
        this.afterColumn = afterColumn;
    }

    private ColumnFunctionCompareComparableNumberChainExpression<Long> duration(DateTimeDurationEnum durationEnum) {
        if (this.afterConstant != null) {
            return new ColumnFunctionCompareComparableNumberChainExpressionImpl<Long>(this.before.getEntitySQLContext(), this.before.getTable(), this.before.getValue(), fx -> {
                if (this.before instanceof DSLSQLFunctionAvailable) {
                    SQLFunction sqlFunction = ((DSLSQLFunctionAvailable)((Object)this.before)).func().apply((SQLFunc)fx);
                    return fx.duration2(s -> s.sqlFunc(sqlFunction).value((Object)this.afterConstant), durationEnum);
                }
                return fx.duration2(s -> s.column(this.before, this.before.getValue()).value((Object)this.afterConstant), durationEnum);
            }, Long.class);
        }
        if (this.afterColumn != null) {
            return new ColumnFunctionCompareComparableNumberChainExpressionImpl<Long>(this.before.getEntitySQLContext(), this.before.getTable(), this.before.getValue(), fx -> {
                if (this.before instanceof DSLSQLFunctionAvailable) {
                    SQLFunction sqlFunction = ((DSLSQLFunctionAvailable)((Object)this.before)).func().apply((SQLFunc)fx);
                    if (this.afterColumn instanceof DSLSQLFunctionAvailable) {
                        DSLSQLFunctionAvailable otherFunction = (DSLSQLFunctionAvailable)((Object)this.afterColumn);
                        SQLFunction otherDateTimeFunction = otherFunction.func().apply((SQLFunc)fx);
                        return fx.duration2(s -> s.sqlFunc(sqlFunction).sqlFunc(otherDateTimeFunction), durationEnum);
                    }
                    return fx.duration2(s -> s.sqlFunc(sqlFunction).column(this.afterColumn, this.afterColumn.getValue()), durationEnum);
                }
                if (this.afterColumn instanceof DSLSQLFunctionAvailable) {
                    DSLSQLFunctionAvailable otherFunction = (DSLSQLFunctionAvailable)((Object)this.afterColumn);
                    SQLFunction otherDateTimeFunction = otherFunction.func().apply((SQLFunc)fx);
                    return fx.duration2(s -> s.column(this.before, this.before.getValue()).sqlFunc(otherDateTimeFunction), durationEnum);
                }
                return fx.duration2(s -> s.column(this.before, this.before.getValue()).column(this.afterColumn, this.afterColumn.getValue()), durationEnum);
            }, Long.class);
        }
        throw new EasyQueryInvalidOperationException("duration error,after constant and after column all null");
    }

    public ColumnFunctionCompareComparableNumberChainExpression<Long> toDays() {
        return this.duration(DateTimeDurationEnum.Days);
    }

    public ColumnFunctionCompareComparableNumberChainExpression<Long> toHours() {
        return this.duration(DateTimeDurationEnum.Hours);
    }

    public ColumnFunctionCompareComparableNumberChainExpression<Long> toMinutes() {
        return this.duration(DateTimeDurationEnum.Minutes);
    }

    public ColumnFunctionCompareComparableNumberChainExpression<Long> toSeconds() {
        return this.duration(DateTimeDurationEnum.Seconds);
    }

    public ColumnFunctionCompareComparableNumberChainExpression<Long> toValues(DateTimeDurationEnum durationEnum) {
        return this.duration(durationEnum);
    }
}

