/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.proxy.impl;

import com.easy.query.core.basic.extension.conversion.ColumnFunctionReaderImpl;
import com.easy.query.core.basic.extension.conversion.ColumnReaderImpl;
import com.easy.query.core.basic.jdbc.types.handler.JdbcTypeHandler;
import com.easy.query.core.expression.parser.core.available.TableAvailable;
import com.easy.query.core.expression.sql.builder.ExpressionContext;
import com.easy.query.core.metadata.ColumnMetadata;
import com.easy.query.core.proxy.PropTypeColumn;
import com.easy.query.core.proxy.PropValueConvertColumn;
import com.easy.query.core.proxy.SQLColumn;
import com.easy.query.core.proxy.SQLSelectAsExpression;
import com.easy.query.core.proxy.core.EntitySQLContext;
import java.util.Map;
import java.util.function.Function;

public class PropValueConvertColumnImpl<TRProperty, TDBProperty>
implements PropValueConvertColumn<TRProperty, TDBProperty> {
    private final PropTypeColumn<TDBProperty> propTypeColumn;
    private final Function<TDBProperty, TRProperty> valueConverter;

    public PropValueConvertColumnImpl(PropTypeColumn<TDBProperty> propTypeColumn, Function<TDBProperty, TRProperty> converter) {
        this.propTypeColumn = propTypeColumn;
        this.valueConverter = converter;
    }

    @Override
    public Function<TDBProperty, TRProperty> getValueConverter() {
        return this.valueConverter;
    }

    @Override
    public <TR> void _setPropertyType(Class<TR> clazz) {
        this.propTypeColumn._setPropertyType(clazz);
    }

    @Override
    public <TR> PropTypeColumn<TR> asAnyType(Class<TR> clazz) {
        return this.propTypeColumn.asAnyType((Class)clazz);
    }

    @Override
    public Class<?> getPropertyType() {
        return this.propTypeColumn.getPropertyType();
    }

    public String getValue() {
        return this.propTypeColumn.getValue();
    }

    public TableAvailable getTable() {
        return this.propTypeColumn.getTable();
    }

    @Override
    public EntitySQLContext getEntitySQLContext() {
        return this.propTypeColumn.getEntitySQLContext();
    }

    @Override
    public SQLSelectAsExpression as(String propertyAlias) {
        ExpressionContext expressionContext = this.getEntitySQLContext().getExpressionContext();
        Map resultValueConverterMap = this.getEntitySQLContext().getExpressionContext().getResultValueConverterMap(true);
        if (this.propTypeColumn instanceof SQLColumn) {
            TableAvailable table = this.propTypeColumn.getTable();
            ColumnMetadata columnMetadata = this.propTypeColumn.getTable().getEntityMetadata().getColumnNotNull(this.propTypeColumn.getValue());
            ColumnReaderImpl columnReader = new ColumnReaderImpl(table.getEntityMetadata(), columnMetadata, this.valueConverter);
            String key = this.getPropertyAlias(propertyAlias, columnMetadata.getPropertyName());
            expressionContext.getResultValueConverterMap(true).put(key, columnReader);
            return PropValueConvertColumn.super.as(propertyAlias);
        }
        JdbcTypeHandler jdbcTypeHandler = this.getEntitySQLContext().getRuntimeContext().getJdbcTypeHandlerManager().getHandler(this.getPropertyType());
        ColumnFunctionReaderImpl columnReader = new ColumnFunctionReaderImpl(this.getPropertyType(), jdbcTypeHandler, this.valueConverter);
        String key = this.getPropertyAlias(propertyAlias, this.propTypeColumn.getValue());
        resultValueConverterMap.put(key, columnReader);
        return this.propTypeColumn.as(propertyAlias);
    }

    private String getPropertyAlias(String propertyAlias, String def) {
        if (propertyAlias == null && def != null) {
            return def;
        }
        return propertyAlias;
    }
}

