/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.proxy;

import com.easy.query.core.exception.EasyQueryInvalidOperationException;
import com.easy.query.core.expression.RelationEntityTableAvailable;
import com.easy.query.core.expression.RelationTableKey;
import com.easy.query.core.expression.builder.Filter;
import com.easy.query.core.expression.builder.impl.FilterImpl;
import com.easy.query.core.expression.lambda.SQLActionExpression;
import com.easy.query.core.expression.lambda.SQLActionExpression1;
import com.easy.query.core.expression.lambda.SQLActionExpression2;
import com.easy.query.core.expression.parser.core.SQLTableOwner;
import com.easy.query.core.expression.parser.core.available.TableAvailable;
import com.easy.query.core.expression.segment.condition.PredicateSegment;
import com.easy.query.core.expression.sql.builder.EntityTableExpressionBuilder;
import com.easy.query.core.metadata.ColumnMetadata;
import com.easy.query.core.proxy.AbstractBaseProxyEntity;
import com.easy.query.core.proxy.ProxyEntity;
import com.easy.query.core.proxy.SQLColumn;
import com.easy.query.core.proxy.SQLSelectAsExpression;
import com.easy.query.core.proxy.TablePropColumn;
import com.easy.query.core.proxy.TableProxy;
import com.easy.query.core.proxy.columns.impl.DefaultSubquerySQLQueryableFactory;
import com.easy.query.core.proxy.core.Expression;
import com.easy.query.core.proxy.extra.EntityExtraAutoIncludeConfigure;
import com.easy.query.core.proxy.extra.EntityExtraAutoIncludeConfigureImpl;
import com.easy.query.core.proxy.impl.SQLColumnIncludeColumn2Impl;
import com.easy.query.core.proxy.impl.SQLPredicateImpl;
import com.easy.query.core.proxy.impl.SQLSelectAllImpl;
import com.easy.query.core.proxy.impl.SQLSelectAsEntryImpl;
import com.easy.query.core.proxy.impl.SQLSelectIgnoreImpl;
import com.easy.query.core.proxy.impl.SQLSelectKeysImpl;
import com.easy.query.core.util.EasyClassUtil;
import com.easy.query.core.util.EasyCollectionUtil;
import com.easy.query.core.util.EasyObjectUtil;
import java.util.Collection;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;

public abstract class AbstractProxyEntity<TProxy extends ProxyEntity<TProxy, TEntity>, TEntity>
extends AbstractBaseProxyEntity<TProxy, TEntity> {
    protected <TPropertyProxy extends SQLColumn<TProxy, TProperty>, TProperty> TPropertyProxy getValueObject(TPropertyProxy propertyProxy) {
        propertyProxy._setProxy(this.castChain());
        return propertyProxy;
    }

    protected String getValueProperty(String property) {
        return property;
    }

    public void or(SQLActionExpression sqlActionExpression) {
        this.or(true, sqlActionExpression);
    }

    public void or(boolean condition, SQLActionExpression sqlActionExpression) {
        if (condition) {
            this.getEntitySQLContext()._whereOr(sqlActionExpression);
        }
    }

    public void and(SQLActionExpression sqlActionExpression) {
        this.and(true, sqlActionExpression);
    }

    public void and(boolean condition, SQLActionExpression sqlActionExpression) {
        if (condition) {
            this.getEntitySQLContext()._whereAnd(sqlActionExpression);
        }
    }

    public void appendOn(SQLActionExpression1<TProxy> filter) {
        TableAvailable thisTable = this.getTable();
        if (!(thisTable instanceof RelationEntityTableAvailable)) {
            throw new EasyQueryInvalidOperationException("can not use extraFilter for " + EasyClassUtil.getSimpleName((Class)this.getTable().getEntityClass()));
        }
        RelationTableKey relationTableKey = ((RelationEntityTableAvailable)thisTable).getRelationTableKey();
        EntityTableExpressionBuilder entityTableExpressionBuilder = (EntityTableExpressionBuilder)this.entitySQLContext.getEntityExpressionBuilder().getRelationTables().get(relationTableKey);
        if (entityTableExpressionBuilder == null) {
            throw new EasyQueryInvalidOperationException("can not find relation table for " + EasyClassUtil.getSimpleName((Class)this.getTable().getEntityClass()) + ", field:" + this.getValue());
        }
        PredicateSegment on = entityTableExpressionBuilder.getOn();
        FilterImpl onFilter = new FilterImpl(this.entitySQLContext.getRuntimeContext(), this.entitySQLContext.getExpressionContext(), on, false, this.entitySQLContext.getExpressionContext().getValueFilter());
        this.getEntitySQLContext()._where((Filter)onFilter, () -> filter.apply(EasyObjectUtil.typeCastNullable((Object)this)));
    }

    protected <T, N> N __cast(T original) {
        return (N)EasyObjectUtil.typeCastNullable(original);
    }

    public SQLSelectAsExpression columnKeys() {
        return new SQLSelectKeysImpl(this.getEntitySQLContext(), this.getTable());
    }

    public void relationLogicDelete(Supplier<Boolean> tableLogic) {
        Map relationTables = this.entitySQLContext.getEntityExpressionBuilder().getRelationTables();
        TableAvailable tableAvailable = this.getTable();
        for (EntityTableExpressionBuilder value : relationTables.values()) {
            if (!value.getEntityTable().equals(tableAvailable)) continue;
            value.setTableLogicDelete(tableLogic);
            break;
        }
    }

    public <TRProxy extends ProxyEntity<TRProxy, TREntity>, TREntity> TProxy selectAll(TRProxy proxy) {
        this.entitySQLContext.accept(new SQLSelectAllImpl(proxy.getEntitySQLContext(), proxy.getTable(), new TablePropColumn[0]));
        return this.castChain();
    }

    public TProxy selectIgnores(TablePropColumn ... ignoreTableProps) {
        this.entitySQLContext.accept(new SQLSelectIgnoreImpl(this.getTable(), ignoreTableProps));
        return this.castChain();
    }

    public TProxy selectExpression(SQLSelectAsExpression ... sqlSelectAsExpression) {
        this.entitySQLContext.accept(sqlSelectAsExpression);
        return this.castChain();
    }

    public TProxy selectColumn(SQLTableOwner sqlTableOwner, String property) {
        this.entitySQLContext.accept(new SQLSelectAsEntryImpl(this.getEntitySQLContext(), sqlTableOwner.getTable(), property));
        return this.castChain();
    }

    public TProxy selectColumnAs(SQLTableOwner sqlTableOwner, String property, String propertyAlias) {
        this.entitySQLContext.accept(new SQLSelectAsEntryImpl(this.getEntitySQLContext(), sqlTableOwner.getTable(), property, propertyAlias));
        return this.castChain();
    }

    public TProxy adapter(Consumer<TProxy> selectExpression) {
        selectExpression.accept(this.castChain());
        return this.castChain();
    }

    public Expression expression() {
        return Expression.of(this.entitySQLContext);
    }

    public <TPropertyProxy extends ProxyEntity<TPropertyProxy, TProperty>, TProperty> void set(TPropertyProxy columnProxy) {
        this.set(columnProxy, null);
    }

    public <TPropertyProxy extends ProxyEntity<TPropertyProxy, TProperty>, TProperty> void set(TPropertyProxy columnProxy, SQLActionExpression2<TProxy, TPropertyProxy> navigateSelectExpression) {
        DefaultSubquerySQLQueryableFactory.dslNavigateSet(columnProxy);
        TableProxy tProxy = this.create(null, this.getEntitySQLContext());
        this.getCurrentEntitySQLContext().accept(new SQLColumnIncludeColumn2Impl(((RelationEntityTableAvailable)columnProxy.getTable()).getOriginalTable(), columnProxy.getNavValue(), this.getNavValue(), columnProxy, tProxy, navigateSelectExpression));
    }

    public void isNull() {
        this.isNull(true);
    }

    public void isNull(boolean condition) {
        boolean ok;
        if (condition && !(ok = this.isNullOrNotNull(true))) {
            throw new EasyQueryInvalidOperationException(EasyClassUtil.getSimpleName((Class)this.getTable().getEntityMetadata().getEntityClass()) + " not found any key,proxy.isNull() not support");
        }
    }

    public void isNotNull() {
        this.isNotNull(true);
    }

    public void isNotNull(boolean condition) {
        boolean ok;
        if (condition && !(ok = this.isNullOrNotNull(false))) {
            throw new EasyQueryInvalidOperationException(EasyClassUtil.getSimpleName((Class)this.getTable().getEntityMetadata().getEntityClass()) + " not found any key,proxy.isNotNull() not support");
        }
    }

    private boolean isNullOrNotNull(boolean isNull) {
        TableAvailable tableAvailable = this.getTable();
        Collection keyProperties = tableAvailable.getEntityMetadata().getKeyProperties();
        if (EasyCollectionUtil.isEmpty((Collection)keyProperties)) {
            Collection columns = tableAvailable.getEntityMetadata().getColumns();
            ColumnMetadata columnMetadata = (ColumnMetadata)EasyCollectionUtil.firstOrDefault((Collection)columns, c -> !c.isNullable(), null);
            if (columnMetadata != null) {
                this.getCurrentEntitySQLContext().accept(new SQLPredicateImpl(f -> {
                    if (isNull) {
                        f.isNull(tableAvailable, columnMetadata.getPropertyName());
                    } else {
                        f.isNotNull(tableAvailable, columnMetadata.getPropertyName());
                    }
                }));
                return true;
            }
        } else {
            String key = (String)EasyCollectionUtil.first((Collection)keyProperties);
            this.getCurrentEntitySQLContext().accept(new SQLPredicateImpl(f -> {
                if (isNull) {
                    f.isNull(tableAvailable, key);
                } else {
                    f.isNotNull(tableAvailable, key);
                }
            }));
            return true;
        }
        return false;
    }

    public EntityExtraAutoIncludeConfigure<TProxy, TEntity> EXTRA_AUTO_INCLUDE_CONFIGURE() {
        return new EntityExtraAutoIncludeConfigureImpl();
    }
}

