/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.api.proxy.entity.save;

import com.easy.query.core.context.QueryRuntimeContext;
import com.easy.query.core.exception.EasyQueryInvalidOperationException;
import com.easy.query.core.expression.sql.include.RelationValue;
import com.easy.query.core.expression.sql.include.relation.RelationValueFactory;
import com.easy.query.core.metadata.ColumnMetadata;
import com.easy.query.core.metadata.EntityMetadata;
import com.easy.query.core.metadata.NavigateMetadata;
import com.easy.query.core.util.EasyClassUtil;
import com.easy.query.core.util.EasyTrackUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class DatabaseEntityValues {
    private final NavigateMetadata navigateMetadata;
    private final EntityMetadata entityMetadata;
    private final QueryRuntimeContext runtimeContext;
    private final RelationValueFactory relationValueFactory;
    private final Map<String, Object> dbEntityMap;
    private final Map<RelationValue, String> saveKeyIndexMap;
    private final Map<RelationValue, Object> saveKeyCheckMap;

    public DatabaseEntityValues(NavigateMetadata navigateMetadata, EntityMetadata entityMetadata, QueryRuntimeContext runtimeContext) {
        this.navigateMetadata = navigateMetadata;
        this.entityMetadata = entityMetadata;
        this.runtimeContext = runtimeContext;
        this.relationValueFactory = runtimeContext.getRelationValueFactory();
        this.dbEntityMap = new LinkedHashMap<String, Object>();
        this.saveKeyIndexMap = new HashMap<RelationValue, String>();
        this.saveKeyCheckMap = new HashMap<RelationValue, Object>();
    }

    private boolean hasSaveKey() {
        return !this.entityMetadata.getSaveKeyProperties().isEmpty();
    }

    public void put(String trackKey, Object entity) {
        RelationValue relationValue;
        String oldTrackKey;
        Objects.requireNonNull(trackKey, "trackKey cant be null");
        this.dbEntityMap.put(trackKey, entity);
        if (this.hasSaveKey() && (oldTrackKey = this.saveKeyIndexMap.put(relationValue = this.getRelationValue(entity), trackKey)) != null) {
            throw new EasyQueryInvalidOperationException("In [" + EasyClassUtil.getSimpleName((Class)this.navigateMetadata.getEntityMetadata().getEntityClass()) + "." + this.navigateMetadata.getPropertyName() + "] , there are objects with the same @SaveKey, but their TrackKey values are [" + oldTrackKey + "," + trackKey + "]. Please verify the data accuracy.");
        }
    }

    private RelationValue getRelationValue(Object entity) {
        int size = this.entityMetadata.getSaveKeyProperties().size();
        ArrayList<Object> saveKeyValues = new ArrayList<Object>(size);
        for (String saveKeyProperty : this.entityMetadata.getSaveKeyProperties()) {
            ColumnMetadata columnMetadata = this.entityMetadata.getColumnNotNull(saveKeyProperty);
            Object saveKey = columnMetadata.getGetterCaller().apply(entity);
            if (saveKey == null) {
                throw new EasyQueryInvalidOperationException("entity:[" + EasyClassUtil.getInstanceSimpleName((Object)entity) + "] save key property:[" + saveKeyProperty + "] can not be null");
            }
            saveKeyValues.add(saveKey);
        }
        RelationValue relationValue = this.relationValueFactory.createCollectionRelationValue(saveKeyValues);
        if (relationValue.isNull()) {
            throw new EasyQueryInvalidOperationException("entity:[" + EasyClassUtil.getInstanceSimpleName((Object)entity) + "] save key property:[" + String.join((CharSequence)",", this.entityMetadata.getSaveKeyProperties()) + "] can not be null");
        }
        return relationValue;
    }

    public String getTrackKey(Object entity) {
        String newNavigateEntityKey = EasyTrackUtil.getTrackKey((EntityMetadata)this.entityMetadata, (Object)entity);
        if (newNavigateEntityKey == null && this.hasSaveKey()) {
            RelationValue relationValue = this.getRelationValue(entity);
            return this.saveKeyIndexMap.get(relationValue);
        }
        return newNavigateEntityKey;
    }

    public void checkSaveKeyRepeat(Object entity) {
        RelationValue relationValue;
        Object old;
        if (this.hasSaveKey() && (old = this.saveKeyCheckMap.put(relationValue = this.getRelationValue(entity), entity)) != null && old != entity) {
            throw new EasyQueryInvalidOperationException("In [" + EasyClassUtil.getSimpleName((Class)this.navigateMetadata.getEntityMetadata().getEntityClass()) + "." + this.navigateMetadata.getPropertyName() + "] , there are objects with the same @SaveKey, but their entity values are [" + entity + "," + old + "]. Please verify the data accuracy.");
        }
    }

    public void remove(String tracKey) {
        this.dbEntityMap.remove(tracKey);
    }

    public boolean containsKey(String tracKey) {
        return this.dbEntityMap.containsKey(tracKey);
    }

    public Collection<Object> values() {
        return this.dbEntityMap.values();
    }
}

