/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.api.proxy.entity.save.provider;

import com.easy.query.api.proxy.entity.save.DatabaseEntityValues;
import com.easy.query.api.proxy.entity.save.MemoryAddressCompareValue;
import com.easy.query.api.proxy.entity.save.SavableContext;
import com.easy.query.api.proxy.entity.save.SaveBehavior;
import com.easy.query.api.proxy.entity.save.SaveBehaviorEnum;
import com.easy.query.api.proxy.entity.save.SaveNode;
import com.easy.query.api.proxy.entity.save.SaveNodeDbTypeEnum;
import com.easy.query.api.proxy.entity.save.SaveNodeTypeEnum;
import com.easy.query.api.proxy.entity.save.TargetValueTypeEnum;
import com.easy.query.api.proxy.entity.save.command.BasicSaveCommand;
import com.easy.query.api.proxy.entity.save.command.EmptySaveCommand;
import com.easy.query.api.proxy.entity.save.command.SaveCommand;
import com.easy.query.api.proxy.entity.save.provider.AbstractSaveProvider;
import com.easy.query.api.proxy.entity.save.provider.DeleteValueObject;
import com.easy.query.core.api.client.EasyQueryClient;
import com.easy.query.core.basic.extension.track.EntityState;
import com.easy.query.core.basic.extension.track.EntityValueState;
import com.easy.query.core.basic.extension.track.TrackContext;
import com.easy.query.core.enums.CascadeTypeEnum;
import com.easy.query.core.enums.RelationTypeEnum;
import com.easy.query.core.exception.EasyQueryInvalidOperationException;
import com.easy.query.core.expression.lambda.Property;
import com.easy.query.core.metadata.ColumnMetadata;
import com.easy.query.core.metadata.EntityMetadata;
import com.easy.query.core.metadata.NavigateMetadata;
import com.easy.query.core.util.EasyArrayUtil;
import com.easy.query.core.util.EasyClassUtil;
import com.easy.query.core.util.EasyCollectionUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class AutoTrackSaveProvider
extends AbstractSaveProvider {
    public AutoTrackSaveProvider(TrackContext currentTrackContext, Class<?> entityClass, List<Object> entities, EasyQueryClient easyQueryClient, List<Set<String>> savePathLimit, SaveBehavior saveBehavior, boolean removeRoot) {
        super(currentTrackContext, entityClass, entities, easyQueryClient, savePathLimit, saveBehavior, removeRoot);
    }

    @Override
    public SaveCommand createCommand() {
        if (EasyCollectionUtil.isNotEmpty((Collection)this.entities)) {
            EntityMetadata entityMetadata = this.entityMetadataManager.getEntityMetadata(this.entityClass);
            ArrayList<Object> inserts = new ArrayList<Object>();
            ArrayList<Object> updates = new ArrayList<Object>();
            for (Object e : this.entities) {
                if (this.saveCommandContext.isProcessEntity(e)) {
                    throw new EasyQueryInvalidOperationException("entity:" + e + " has been added to the save command");
                }
                this.saveCommandContext.addProcessEntity(e);
                EntityState trackEntityState = this.currentTrackContext.getTrackEntityState(e);
                if (trackEntityState == null) {
                    inserts.add(e);
                } else {
                    updates.add(e);
                }
                this.cleanNavigates(e, entityMetadata);
                EntityState entityState = this.currentTrackContext.getTrackEntityState(e);
                this.saveSelf(e, entityState, entityMetadata, 0);
            }
            for (Map.Entry entry : this.deleteValueObjectMap.entrySet()) {
                MemoryAddressCompareValue key = (MemoryAddressCompareValue)entry.getKey();
                DeleteValueObject value = (DeleteValueObject)entry.getValue();
                SaveNode.EntitySaveSate entitySaveSate = value.saveNode.getEntityItems().get(key);
                if (entitySaveSate.getType() != SaveNodeTypeEnum.DELETE) continue;
                this.deleteSelf(value.target, value.targetEntityMetadata, value.saveNode.getIndex() + 1);
            }
            return new BasicSaveCommand(entityMetadata, inserts, updates, this.easyQueryClient, this.saveCommandContext, this.saveBehavior, this.removeRoot);
        }
        return EmptySaveCommand.INSTANCE;
    }

    private void cleanNavigates(Object entity, EntityMetadata entityMetadata) {
        if (this.removeRoot) {
            Collection navigateMetadatas = entityMetadata.getNavigateMetadatas();
            for (NavigateMetadata navigateMetadata : navigateMetadatas) {
                navigateMetadata.getSetter().call(entity, null);
            }
        }
    }

    private void saveSelf(Object entity, EntityState entityState, EntityMetadata entityMetadata, int deep) {
        SavableContext savableContext = this.saveCommandContext.getCreateSavableContext(deep);
        Collection navigateMetadataList = entityState == null ? entityMetadata.getNavigateMetadatas() : entityState.getIncludes();
        List<NavigateMetadata> valueObjects = this.getNavigateSavableValueObjects(entityState, savableContext, entity, entityMetadata, navigateMetadataList, deep);
        for (NavigateMetadata navigateMetadata : valueObjects) {
            if (entityState == null) {
                this.valueObjectInsert(entity, entityMetadata, navigateMetadata, savableContext);
                continue;
            }
            Set trackKeys = entityState.getTrackKeys(navigateMetadata);
            this.valueObjectUpdate(entity, entityMetadata, navigateMetadata, savableContext, trackKeys == null ? new HashSet() : trackKeys);
        }
    }

    private void deleteSelf(Object entity, EntityMetadata entityMetadata, int deep) {
        EntityState entityState = this.currentTrackContext.getTrackEntityState(entity);
        if (entityState != null) {
            SavableContext savableContext = this.saveCommandContext.getCreateSavableContext(deep);
            List navigateMetadataList = entityState.getIncludes();
            List<NavigateMetadata> valueObjects = this.getNavigateSavableValueObjects(entityState, savableContext, entity, entityMetadata, navigateMetadataList, deep);
            Iterator<NavigateMetadata> iterator = valueObjects.iterator();
            while (iterator.hasNext()) {
                NavigateMetadata navigateMetadata;
                Set trackKeys = entityState.getTrackKeys(navigateMetadata = iterator.next());
                this.valueObjectDelete(entity, entityMetadata, navigateMetadata, savableContext, trackKeys == null ? new HashSet() : trackKeys);
            }
        }
    }

    private void valueObjectDelete(Object entity, EntityMetadata selfEntityMetadata, NavigateMetadata navigateMetadata, SavableContext savableContext, Set<String> trackKeys) {
        if (trackKeys != null) {
            if (EasyArrayUtil.isNotEmpty((Object[])navigateMetadata.getDirectMapping())) {
                return;
            }
            EntityMetadata targetEntityMetadata = this.entityMetadataManager.getEntityMetadata(navigateMetadata.getNavigatePropertyType());
            SaveNode saveNode = savableContext.getSaveNode(navigateMetadata);
            if (saveNode == null) {
                throw new EasyQueryInvalidOperationException("entity:[" + EasyClassUtil.getSimpleName((Class)navigateMetadata.getEntityMetadata().getEntityClass()) + "." + EasyClassUtil.getSimpleName((Class)navigateMetadata.getNavigatePropertyType()) + "] save node is null");
            }
            for (String trackKey : trackKeys) {
                EntityState trackEntityState = this.currentTrackContext.getTrackEntityState(navigateMetadata.getNavigatePropertyType(), trackKey);
                Objects.requireNonNull(trackEntityState, "trackEntityState cant be null,trackKey:" + trackKey);
                this.saveNodeDelete(entity, trackEntityState.getCurrentValue(), selfEntityMetadata, targetEntityMetadata, navigateMetadata, saveNode, false);
                this.deleteSelf(trackEntityState.getCurrentValue(), targetEntityMetadata, saveNode.getIndex() + 1);
            }
        }
    }

    private void valueObjectInsert(Object entity, EntityMetadata selfEntityMetadata, NavigateMetadata navigateMetadata, SavableContext savableContext) {
        if (EasyArrayUtil.isNotEmpty((Object[])navigateMetadata.getDirectMapping())) {
            throw new EasyQueryInvalidOperationException("save not support direct mapping");
        }
        EntityMetadata targetEntityMetadata = this.entityMetadataManager.getEntityMetadata(navigateMetadata.getNavigatePropertyType());
        SaveNode saveNode = savableContext.getSaveNode(navigateMetadata);
        DatabaseEntityValues databaseEntityValues = new DatabaseEntityValues(navigateMetadata, targetEntityMetadata, this.runtimeContext);
        Property getter = navigateMetadata.getGetter();
        Object navigates = getter.apply(entity);
        if (navigates instanceof Collection) {
            Collection collection = (Collection)navigates;
            if (collection.isEmpty() && this.saveBehavior.hasBehavior(SaveBehaviorEnum.IGNORE_EMPTY)) {
                return;
            }
            for (Object targetEntity : collection) {
                databaseEntityValues.checkSaveKeyRepeat(targetEntity);
                this.valueObjectEntityInsert(entity, targetEntity, selfEntityMetadata, targetEntityMetadata, navigateMetadata, saveNode);
            }
        } else if (navigates != null) {
            databaseEntityValues.checkSaveKeyRepeat(navigates);
            this.valueObjectEntityInsert(entity, navigates, selfEntityMetadata, targetEntityMetadata, navigateMetadata, saveNode);
        }
    }

    private void valueObjectEntityInsert(Object selfEntity, Object targetEntity, EntityMetadata selfEntityMetadata, EntityMetadata targetEntityMetadata, NavigateMetadata navigateMetadata, SaveNode saveNode) {
        this.saveNodeInsert(selfEntity, targetEntity, selfEntityMetadata, targetEntityMetadata, navigateMetadata, saveNode);
        if (navigateMetadata.getRelationType() != RelationTypeEnum.ManyToMany && navigateMetadata.getCascade() == CascadeTypeEnum.DELETE) {
            EntityState entityState = this.currentTrackContext.getTrackEntityState(targetEntity);
            this.saveSelf(targetEntity, entityState, targetEntityMetadata, saveNode.getIndex() + 1);
        }
    }

    private void valueObjectUpdate(Object entity, EntityMetadata selfEntityMetadata, NavigateMetadata navigateMetadata, SavableContext savableContext, Set<String> trackKeys) {
        if (trackKeys != null) {
            if (EasyArrayUtil.isNotEmpty((Object[])navigateMetadata.getDirectMapping())) {
                throw new EasyQueryInvalidOperationException("save not support direct mapping");
            }
            EntityMetadata targetEntityMetadata = this.entityMetadataManager.getEntityMetadata(navigateMetadata.getNavigatePropertyType());
            SaveNode saveNode = savableContext.getSaveNode(navigateMetadata);
            if (saveNode == null) {
                throw new EasyQueryInvalidOperationException("entity:[" + EasyClassUtil.getSimpleName((Class)navigateMetadata.getEntityMetadata().getEntityClass()) + "." + EasyClassUtil.getSimpleName((Class)navigateMetadata.getNavigatePropertyType()) + "] save node is null");
            }
            DatabaseEntityValues databaseEntityValues = new DatabaseEntityValues(navigateMetadata, targetEntityMetadata, this.runtimeContext);
            for (String trackKey : trackKeys) {
                EntityState trackEntityState = this.currentTrackContext.getTrackEntityState(navigateMetadata.getNavigatePropertyType(), trackKey);
                Objects.requireNonNull(trackEntityState, "trackEntityState cant be null,trackKey:" + trackKey);
                databaseEntityValues.put(trackKey, trackEntityState.getCurrentValue());
            }
            Property getter = navigateMetadata.getGetter();
            Object navigates = getter.apply(entity);
            if (navigates instanceof Collection) {
                Collection collection = (Collection)navigates;
                if (collection.isEmpty() && this.saveBehavior.hasBehavior(SaveBehaviorEnum.IGNORE_EMPTY)) {
                    return;
                }
                for (Object targetEntity : collection) {
                    databaseEntityValues.checkSaveKeyRepeat(targetEntity);
                    this.valueObjectEntityInsertUpdate(databaseEntityValues, entity, targetEntity, selfEntityMetadata, targetEntityMetadata, navigateMetadata, saveNode);
                }
            } else if (navigates != null) {
                databaseEntityValues.checkSaveKeyRepeat(navigates);
                this.valueObjectEntityInsertUpdate(databaseEntityValues, entity, navigates, selfEntityMetadata, targetEntityMetadata, navigateMetadata, saveNode);
            } else if (this.saveBehavior.hasBehavior(SaveBehaviorEnum.IGNORE_NULL)) {
                return;
            }
            for (Object value : databaseEntityValues.values()) {
                this.saveNodeDelete(entity, value, selfEntityMetadata, targetEntityMetadata, navigateMetadata, saveNode, true);
            }
        }
    }

    private void valueObjectEntityInsertUpdate(DatabaseEntityValues databaseEntityValues, Object selfEntity, Object targetEntity, EntityMetadata selfEntityMetadata, EntityMetadata targetEntityMetadata, NavigateMetadata navigateMetadata, SaveNode saveNode) {
        EntityState entityState = null;
        String newNavigateEntityKey = databaseEntityValues.getTrackKey(targetEntity);
        if (newNavigateEntityKey == null || !databaseEntityValues.containsKey(newNavigateEntityKey)) {
            this.saveNodeInsert(selfEntity, targetEntity, selfEntityMetadata, targetEntityMetadata, navigateMetadata, saveNode);
            entityState = this.currentTrackContext.getTrackEntityState(targetEntity);
        } else {
            databaseEntityValues.remove(newNavigateEntityKey);
            EntityState trackEntityState = this.currentTrackContext.getTrackEntityState(navigateMetadata.getNavigatePropertyType(), newNavigateEntityKey);
            Objects.requireNonNull(trackEntityState, "trackEntityState cant be null,trackKey:" + newNavigateEntityKey);
            if (targetEntity != trackEntityState.getCurrentValue()) {
                this.mergeEntityWithTrackEntity(targetEntity, trackEntityState.getCurrentValue(), targetEntityMetadata);
            }
            this.saveNodeUpdate(trackEntityState, selfEntity, trackEntityState.getCurrentValue(), selfEntityMetadata, targetEntityMetadata, navigateMetadata, saveNode);
            entityState = this.currentTrackContext.getTrackEntityState(trackEntityState.getCurrentValue());
        }
        if (navigateMetadata.getRelationType() != RelationTypeEnum.ManyToMany && navigateMetadata.getCascade() == CascadeTypeEnum.DELETE) {
            this.saveSelf(targetEntity, entityState, targetEntityMetadata, saveNode.getIndex() + 1);
        }
    }

    private void mergeEntityWithTrackEntity(Object source, Object currentEntity, EntityMetadata entityMetadata) {
        for (Map.Entry propColumn : entityMetadata.getProperty2ColumnMap().entrySet()) {
            String key = (String)propColumn.getKey();
            ColumnMetadata columnMetadata = (ColumnMetadata)propColumn.getValue();
            Object sourceValue = columnMetadata.getGetterCaller().apply(source);
            boolean keyProperty = entityMetadata.isKeyProperty(key);
            if (keyProperty) {
                if (sourceValue != null) continue;
                Object value = columnMetadata.getGetterCaller().apply(currentEntity);
                columnMetadata.getSetterCaller().call(source, value);
                continue;
            }
            columnMetadata.getSetterCaller().call(currentEntity, sourceValue);
        }
    }

    private void saveNodeDelete(Object selfEntity, Object targetEntity, EntityMetadata selfEntityMetadata, EntityMetadata targetEntityMetadata, NavigateMetadata navigateMetadata, SaveNode saveNode, boolean first) {
        if (navigateMetadata.getCascade() == CascadeTypeEnum.NO_ACTION) {
            return;
        }
        if (navigateMetadata.getRelationType() == RelationTypeEnum.ManyToMany) {
            if (navigateMetadata.getMappingClass() == null) {
                throw new EasyQueryInvalidOperationException("entity:[" + EasyClassUtil.getSimpleName((Class)navigateMetadata.getEntityMetadata().getEntityClass()) + "." + navigateMetadata.getPropertyName() + "] many to many relation must have mapping class");
            }
            EntityMetadata mappingClassEntityMetadata = this.entityMetadataManager.getEntityMetadata(navigateMetadata.getMappingClass());
            Object mappingEntity = mappingClassEntityMetadata.getBeanConstructorCreator().get();
            this.setMappingEntity(selfEntity, targetEntity, mappingEntity, selfEntityMetadata, navigateMetadata, targetEntityMetadata, mappingClassEntityMetadata);
            saveNode.getDeleteBys().add(mappingEntity);
        } else {
            if (navigateMetadata.getCascade() == CascadeTypeEnum.AUTO || navigateMetadata.getCascade() == CascadeTypeEnum.SET_NULL) {
                boolean prosHasKey = this.targetAnyPropsIsKey(selfEntityMetadata, navigateMetadata);
                if (prosHasKey) {
                    throw new EasyQueryInvalidOperationException("entity:[" + EasyClassUtil.getSimpleName((Class)selfEntityMetadata.getEntityClass()) + "." + navigateMetadata.getPropertyName() + "] targetProperty has key props,cascade cant use set null");
                }
                saveNode.putDeleteItem(new MemoryAddressCompareValue(targetEntity), selfEntity, t -> this.setTargetNullValue(TargetValueTypeEnum.VALUE_OBJECT, selfEntity, targetEntity, selfEntityMetadata, navigateMetadata, targetEntityMetadata), SaveNodeDbTypeEnum.UPDATE);
            }
            if (navigateMetadata.getCascade() == CascadeTypeEnum.DELETE) {
                MemoryAddressCompareValue deleteEntity = new MemoryAddressCompareValue(targetEntity);
                saveNode.putDeleteItem(deleteEntity, null, null, SaveNodeDbTypeEnum.DELETE);
                if (first) {
                    DeleteValueObject deleteValueObject = new DeleteValueObject(targetEntity, targetEntityMetadata, saveNode);
                    this.deleteValueObjectMap.computeIfAbsent(deleteEntity, k -> deleteValueObject);
                }
            }
        }
    }

    private void saveNodeUpdate(EntityState trackEntityState, Object selfEntity, Object targetEntity, EntityMetadata selfEntityMetadata, EntityMetadata targetEntityMetadata, NavigateMetadata navigateMetadata, SaveNode saveNode) {
        if (navigateMetadata.getCascade() == CascadeTypeEnum.NO_ACTION) {
            return;
        }
        if (navigateMetadata.getRelationType() == RelationTypeEnum.ManyToMany) {
            if (navigateMetadata.getMappingClass() == null) {
                throw new EasyQueryInvalidOperationException("entity:[" + EasyClassUtil.getSimpleName((Class)navigateMetadata.getEntityMetadata().getEntityClass()) + "." + navigateMetadata.getPropertyName() + "] many to many relation must have mapping class");
            }
            return;
        }
        boolean hasChanged = false;
        for (Map.Entry propColumn : targetEntityMetadata.getProperty2ColumnMap().entrySet()) {
            EntityValueState entityValueState = trackEntityState.getEntityValueState((ColumnMetadata)propColumn.getValue());
            if (!entityValueState.isChanged()) continue;
            hasChanged = true;
            break;
        }
        if (hasChanged) {
            saveNode.putUpdateItem(new MemoryAddressCompareValue(targetEntity), selfEntity, t -> this.setTargetValue(TargetValueTypeEnum.VALUE_OBJECT, selfEntity, t, selfEntityMetadata, navigateMetadata, targetEntityMetadata));
        } else {
            saveNode.putIgnoreUpdateItem(new MemoryAddressCompareValue(targetEntity), selfEntity, null);
        }
    }

    private void saveNodeInsert(Object selfEntity, Object targetEntity, EntityMetadata selfEntityMetadata, EntityMetadata targetEntityMetadata, NavigateMetadata navigateMetadata, SaveNode saveNode) {
        if (navigateMetadata.getCascade() == CascadeTypeEnum.NO_ACTION) {
            return;
        }
        if (navigateMetadata.getRelationType() == RelationTypeEnum.ManyToMany) {
            if (navigateMetadata.getMappingClass() == null) {
                throw new EasyQueryInvalidOperationException("entity:[" + EasyClassUtil.getSimpleName((Class)navigateMetadata.getEntityMetadata().getEntityClass()) + "." + navigateMetadata.getPropertyName() + "] many to many relation must have mapping class");
            }
            EntityMetadata mappingClassEntityMetadata = this.entityMetadataManager.getEntityMetadata(navigateMetadata.getMappingClass());
            Object mappingEntity = mappingClassEntityMetadata.getBeanConstructorCreator().get();
            saveNode.putInsertItem(new MemoryAddressCompareValue(mappingEntity), selfEntity, t -> this.setMappingEntity(selfEntity, targetEntity, t, selfEntityMetadata, navigateMetadata, targetEntityMetadata, mappingClassEntityMetadata));
        } else if (navigateMetadata.getCascade() == CascadeTypeEnum.AUTO || navigateMetadata.getCascade() == CascadeTypeEnum.SET_NULL) {
            saveNode.putUpdateItem(new MemoryAddressCompareValue(targetEntity), selfEntity, t -> {
                this.checkPrimaryKeyNotNull(targetEntityMetadata, t, "entity:[" + selfEntityMetadata.getEntityClass() + "." + navigateMetadata.getPropertyName() + "] primary key is null");
                this.setTargetValue(TargetValueTypeEnum.VALUE_OBJECT, selfEntity, t, selfEntityMetadata, navigateMetadata, targetEntityMetadata);
            });
        } else if (navigateMetadata.getCascade() == CascadeTypeEnum.DELETE) {
            saveNode.putInsertItem(new MemoryAddressCompareValue(targetEntity), selfEntity, t -> this.setTargetValue(TargetValueTypeEnum.VALUE_OBJECT, selfEntity, t, selfEntityMetadata, navigateMetadata, targetEntityMetadata));
        } else {
            throw new EasyQueryInvalidOperationException("value object un support operate cascade:" + navigateMetadata.getCascade());
        }
    }
}

