/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.api.proxy.client;

import com.easy.query.api.proxy.client.EasyEntityQuery;
import com.easy.query.api.proxy.entity.EntityQueryProxyManager;
import com.easy.query.api.proxy.entity.delete.EntityDeletable;
import com.easy.query.api.proxy.entity.delete.ExpressionDeletable;
import com.easy.query.api.proxy.entity.delete.impl.EasyEmptyEntityDeletable;
import com.easy.query.api.proxy.entity.delete.impl.EasyEntityDeletable;
import com.easy.query.api.proxy.entity.delete.impl.EasyExpressionDeletable;
import com.easy.query.api.proxy.entity.insert.EasyEmptyEntityInsertable;
import com.easy.query.api.proxy.entity.insert.EasyEntityInsertable;
import com.easy.query.api.proxy.entity.insert.EntityInsertable;
import com.easy.query.api.proxy.entity.save.EasyEmptySavable;
import com.easy.query.api.proxy.entity.save.EntitySavable;
import com.easy.query.api.proxy.entity.save.impl.EasyEntitySavable;
import com.easy.query.api.proxy.entity.select.EntityQueryable;
import com.easy.query.api.proxy.entity.select.impl.EasyEntityQueryable;
import com.easy.query.api.proxy.entity.update.EntityUpdatable;
import com.easy.query.api.proxy.entity.update.ExpressionUpdatable;
import com.easy.query.api.proxy.entity.update.impl.EasyEmptyEntityUpdatable;
import com.easy.query.api.proxy.entity.update.impl.EasyEntityUpdatable;
import com.easy.query.api.proxy.entity.update.impl.EasyExpressionUpdatable;
import com.easy.query.core.api.client.EasyQueryClient;
import com.easy.query.core.proxy.DbSet;
import com.easy.query.core.proxy.EasyDbSet;
import com.easy.query.core.proxy.ProxyEntity;
import com.easy.query.core.proxy.ProxyEntityAvailable;
import com.easy.query.core.util.EasyCollectionUtil;
import com.easy.query.core.util.EasyObjectUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;

public class DefaultEasyEntityQuery
implements EasyEntityQuery {
    private final EasyQueryClient easyQueryClient;

    public DefaultEasyEntityQuery(EasyQueryClient easyQueryClient) {
        this.easyQueryClient = easyQueryClient;
    }

    @Override
    public EasyQueryClient getEasyQueryClient() {
        return this.easyQueryClient;
    }

    @Override
    public <TProxy extends ProxyEntity<TProxy, T>, T extends ProxyEntityAvailable<T, TProxy>> EntityQueryable<TProxy, T> queryable(Class<T> entityClass) {
        Object tProxy = EntityQueryProxyManager.create(entityClass);
        return this.queryable((TProxy)tProxy);
    }

    @Override
    public <TProxy extends ProxyEntity<TProxy, T>, T> EntityQueryable<TProxy, T> queryable(TProxy tProxy) {
        return new EasyEntityQueryable(tProxy, this.easyQueryClient.queryable(tProxy.getEntityClass()));
    }

    @Override
    public <TProxy extends ProxyEntity<TProxy, T>, T extends ProxyEntityAvailable<T, TProxy>> EntityQueryable<TProxy, T> queryable(String sql, Class<T> entityClass) {
        Object tProxy = EntityQueryProxyManager.create(entityClass);
        return new EasyEntityQueryable(tProxy, this.easyQueryClient.queryable(sql, entityClass));
    }

    @Override
    public <TProxy extends ProxyEntity<TProxy, T>, T extends ProxyEntityAvailable<T, TProxy>> EntityQueryable<TProxy, T> queryable(String sql, Class<T> entityClass, Collection<Object> params) {
        Object tProxy = EntityQueryProxyManager.create(entityClass);
        return new EasyEntityQueryable(tProxy, this.easyQueryClient.queryable(sql, entityClass, params));
    }

    @Override
    public <TProxy extends ProxyEntity<TProxy, T>, T extends ProxyEntityAvailable<T, TProxy>> EntityInsertable<TProxy, T> insertable(T entity) {
        Objects.requireNonNull(entity, "entities is null");
        Class aClass = (Class)EasyObjectUtil.typeCast(entity.getClass());
        Object tProxy = EntityQueryProxyManager.create(aClass);
        return new EasyEntityInsertable(tProxy, this.easyQueryClient.insertable(entity));
    }

    @Override
    public <TProxy extends ProxyEntity<TProxy, T>, T> EntityInsertable<TProxy, T> insertable(TProxy tProxy) {
        return new EasyEntityInsertable(tProxy, this.easyQueryClient.insertable(tProxy.getEntityClass()));
    }

    @Override
    public <TProxy extends ProxyEntity<TProxy, T>, T extends ProxyEntityAvailable<T, TProxy>> EntityInsertable<TProxy, T> insertable(Collection<T> entities) {
        Objects.requireNonNull(entities, "entities is null");
        if (EasyCollectionUtil.isEmpty(entities)) {
            return new EasyEmptyEntityInsertable();
        }
        ProxyEntityAvailable first = (ProxyEntityAvailable)EasyCollectionUtil.first(entities);
        Class aClass = (Class)EasyObjectUtil.typeCast(first.getClass());
        Object tProxy = EntityQueryProxyManager.create(aClass);
        return new EasyEntityInsertable(tProxy, this.easyQueryClient.insertable(entities));
    }

    @Override
    public <TProxy extends ProxyEntity<TProxy, T>, T extends ProxyEntityAvailable<T, TProxy>> ExpressionUpdatable<TProxy, T> updatable(Class<T> entityClass) {
        Object tProxy = EntityQueryProxyManager.create(entityClass);
        return new EasyExpressionUpdatable(tProxy, this.easyQueryClient.updatable(entityClass));
    }

    @Override
    public <TProxy extends ProxyEntity<TProxy, T>, T> ExpressionUpdatable<TProxy, T> expressionUpdatable(TProxy tProxy) {
        return new EasyExpressionUpdatable(tProxy, this.easyQueryClient.updatable(tProxy.getEntityClass()));
    }

    @Override
    public <TProxy extends ProxyEntity<TProxy, T>, T extends ProxyEntityAvailable<T, TProxy>> EntityUpdatable<TProxy, T> updatable(T entity) {
        Objects.requireNonNull(entity, "entity is null");
        Class aClass = (Class)EasyObjectUtil.typeCast(entity.getClass());
        Object tProxy = EntityQueryProxyManager.create(aClass);
        EntityUpdatable entityUpdatable = this.entityUpdatable((TProxy)tProxy);
        entityUpdatable.getEntities().add(entity);
        return entityUpdatable;
    }

    @Override
    public <TProxy extends ProxyEntity<TProxy, T>, T> EntityUpdatable<TProxy, T> entityUpdatable(TProxy tProxy) {
        return new EasyEntityUpdatable(tProxy, this.easyQueryClient.entityUpdatable(tProxy.getEntityClass()));
    }

    @Override
    public <TProxy extends ProxyEntity<TProxy, T>, T extends ProxyEntityAvailable<T, TProxy>> EntityUpdatable<TProxy, T> updatable(Collection<T> entities) {
        Objects.requireNonNull(entities, "entities is null");
        if (EasyCollectionUtil.isEmpty(entities)) {
            return new EasyEmptyEntityUpdatable();
        }
        ProxyEntityAvailable first = (ProxyEntityAvailable)EasyCollectionUtil.first(entities);
        Class aClass = (Class)EasyObjectUtil.typeCast(first.getClass());
        Object tProxy = EntityQueryProxyManager.create(aClass);
        return new EasyEntityUpdatable(tProxy, this.easyQueryClient.updatable(entities));
    }

    @Override
    public <TProxy extends ProxyEntity<TProxy, T>, T extends ProxyEntityAvailable<T, TProxy>> EntityDeletable<TProxy, T> deletable(T entity) {
        Objects.requireNonNull(entity, "entities is null");
        Class aClass = (Class)EasyObjectUtil.typeCast(entity.getClass());
        Object tProxy = EntityQueryProxyManager.create(aClass);
        return new EasyEntityDeletable(tProxy, this.easyQueryClient.deletable(entity));
    }

    @Override
    public <TProxy extends ProxyEntity<TProxy, T>, T> EntityDeletable<TProxy, T> entityDeletable(TProxy tProxy) {
        return new EasyEntityDeletable(tProxy, this.easyQueryClient.entityDeletable(tProxy.getEntityClass()));
    }

    @Override
    public <TProxy extends ProxyEntity<TProxy, T>, T extends ProxyEntityAvailable<T, TProxy>> EntityDeletable<TProxy, T> deletable(Collection<T> entities) {
        Objects.requireNonNull(entities, "entities is null");
        if (EasyCollectionUtil.isEmpty(entities)) {
            return new EasyEmptyEntityDeletable();
        }
        ProxyEntityAvailable first = (ProxyEntityAvailable)EasyCollectionUtil.first(entities);
        Class aClass = (Class)EasyObjectUtil.typeCast(first.getClass());
        Object tProxy = EntityQueryProxyManager.create(aClass);
        return new EasyEntityDeletable(tProxy, this.easyQueryClient.deletable(entities));
    }

    @Override
    public <TProxy extends ProxyEntity<TProxy, T>, T extends ProxyEntityAvailable<T, TProxy>> ExpressionDeletable<TProxy, T> deletable(Class<T> entityClass) {
        Object tProxy = EntityQueryProxyManager.create(entityClass);
        return this.expressionDeletable((TProxy)tProxy);
    }

    @Override
    public <TProxy extends ProxyEntity<TProxy, T>, T> ExpressionDeletable<TProxy, T> expressionDeletable(TProxy tProxy) {
        return new EasyExpressionDeletable(tProxy, this.easyQueryClient.deletable(tProxy.getEntityClass()));
    }

    @Override
    public <TProxy extends ProxyEntity<TProxy, T>, T extends ProxyEntityAvailable<T, TProxy>> EntitySavable<TProxy, T> savable(T entity) {
        Objects.requireNonNull(entity, "entity is null");
        Class entityClass = (Class)EasyObjectUtil.typeCast(entity.getClass());
        Object tProxy = EntityQueryProxyManager.create(entityClass);
        EntitySavable savable = this.savable((TProxy)tProxy);
        savable.getEntities().add(entity);
        return savable;
    }

    @Override
    public <TProxy extends ProxyEntity<TProxy, T>, T> EntitySavable<TProxy, T> savable(TProxy tProxy) {
        return new EasyEntitySavable(tProxy, tProxy.getEntityClass(), new ArrayList(), this.easyQueryClient);
    }

    @Override
    public <TProxy extends ProxyEntity<TProxy, T>, T extends ProxyEntityAvailable<T, TProxy>> EntitySavable<TProxy, T> savable(Collection<T> entities) {
        Objects.requireNonNull(entities, "entities is null");
        if (EasyCollectionUtil.isEmpty(entities)) {
            return new EasyEmptySavable();
        }
        ProxyEntityAvailable first = (ProxyEntityAvailable)EasyCollectionUtil.first(entities);
        Class entityClass = (Class)EasyObjectUtil.typeCast(first.getClass());
        Object tProxy = EntityQueryProxyManager.create(entityClass);
        EntitySavable savable = this.savable((TProxy)tProxy);
        savable.getEntities().addAll(entities);
        return savable;
    }

    @Override
    public <TProxy extends ProxyEntity<TProxy, T>, T> DbSet<TProxy, T> createDbSet(TProxy tProxy) {
        return new EasyDbSet(tProxy, this);
    }
}

