/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.api.proxy.extension.window;

import com.easy.query.api.proxy.extension.window.Offset;
import com.easy.query.core.exception.EasyQueryInvalidOperationException;
import com.easy.query.core.expression.lambda.SQLFuncExpression1;
import com.easy.query.core.proxy.PropTypeColumn;

public class NextSelector<TProperty, TChain> {
    private final SQLFuncExpression1<Offset<TProperty>, TChain> createNextColumn;

    public NextSelector(SQLFuncExpression1<Offset<TProperty>, TChain> createNextColumn) {
        this.createNextColumn = createNextColumn;
    }

    public TChain next(int offset) {
        this.checkOffset(offset);
        Offset of = Offset.of(offset);
        return (TChain)this.createNextColumn.apply(of);
    }

    public TChain next(int offset, PropTypeColumn<TProperty> defaultColumn) {
        this.checkOffset(offset);
        Offset<PropTypeColumn<TProperty>> of = Offset.of(offset, defaultColumn);
        return (TChain)this.createNextColumn.apply(of);
    }

    public TChain next(int offset, TProperty defaultValue) {
        this.checkOffset(offset);
        Offset<TProperty> of = Offset.of(offset, defaultValue);
        return (TChain)this.createNextColumn.apply(of);
    }

    public TChain prev(int offset) {
        this.checkOffset(offset);
        Offset of = Offset.of(offset * -1);
        return (TChain)this.createNextColumn.apply(of);
    }

    public TChain prev(int offset, PropTypeColumn<TProperty> defaultColumn) {
        this.checkOffset(offset);
        Offset<PropTypeColumn<TProperty>> of = Offset.of(offset * -1, defaultColumn);
        return (TChain)this.createNextColumn.apply(of);
    }

    public TChain prev(int offset, TProperty defaultValue) {
        this.checkOffset(offset);
        Offset<TProperty> of = Offset.of(offset * -1, defaultValue);
        return (TChain)this.createNextColumn.apply(of);
    }

    private void checkOffset(int offset) {
        if (offset < 0) {
            throw new EasyQueryInvalidOperationException("offset must be greater than or equal to 0 (offset >= 0)");
        }
    }
}

