/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.api.proxy.extension.window;

import com.easy.query.core.func.SQLFunc;
import com.easy.query.core.func.SQLFunction;
import com.easy.query.core.proxy.PropTypeColumn;
import java.util.Arrays;
import java.util.List;

public class OverExpression {
    private final SQLFunc sqlFunc;
    private final List<SQLFunction> orderFunctions;
    private final List<PropTypeColumn<?>> columns;

    public OverExpression(SQLFunc sqlFunc, List<SQLFunction> orderCollectors, List<PropTypeColumn<?>> columns) {
        this.sqlFunc = sqlFunc;
        this.orderFunctions = orderCollectors;
        this.columns = columns;
    }

    public OverExpression partitionBy(PropTypeColumn<?> ... columns) {
        this.columns.addAll(Arrays.asList(columns));
        return this;
    }

    public <TProperty> OverExpression orderBy(PropTypeColumn<TProperty> propTypeColumn) {
        return this.orderBy(true, propTypeColumn);
    }

    public <TProperty> OverExpression orderBy(boolean condition, PropTypeColumn<TProperty> propTypeColumn) {
        if (condition) {
            SQLFunction orderFunction = this.sqlFunc.anySQLFunction("{0} ASC", c -> PropTypeColumn.columnFuncSelector(c, propTypeColumn));
            this.orderFunctions.add(orderFunction);
        }
        return this;
    }

    public <TProperty> OverExpression orderByDescending(PropTypeColumn<TProperty> propTypeColumn) {
        return this.orderByDescending(true, propTypeColumn);
    }

    public <TProperty> OverExpression orderByDescending(boolean condition, PropTypeColumn<TProperty> propTypeColumn) {
        if (condition) {
            SQLFunction orderFunction = this.sqlFunc.anySQLFunction("{0} DESC", c -> PropTypeColumn.columnFuncSelector(c, propTypeColumn));
            this.orderFunctions.add(orderFunction);
        }
        return this;
    }
}

