/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.proxy.extension.functions.type.impl;

import com.easy.query.core.expression.builder.AsSelector;
import com.easy.query.core.expression.builder.GroupSelector;
import com.easy.query.core.expression.builder.OrderSelector;
import com.easy.query.core.expression.builder.Selector;
import com.easy.query.core.expression.parser.core.available.TableAvailable;
import com.easy.query.core.func.SQLFunc;
import com.easy.query.core.func.SQLFunction;
import com.easy.query.core.func.def.enums.OrderByModeEnum;
import com.easy.query.core.proxy.SQLFunctionExpressionUtil;
import com.easy.query.core.proxy.core.EntitySQLContext;
import com.easy.query.core.proxy.extension.functions.type.StringTypeExpression;
import com.easy.query.core.proxy.impl.SQLOrderSelectImpl;
import java.util.function.Function;

public class StringTypeExpressionImpl<TProperty>
implements StringTypeExpression<TProperty> {
    private final EntitySQLContext entitySQLContext;
    private final TableAvailable table;
    private final String property;
    private final Function<SQLFunc, SQLFunction> func;
    private Class<?> propType;

    public StringTypeExpressionImpl(EntitySQLContext entitySQLContext, TableAvailable table, String property, Function<SQLFunc, SQLFunction> func) {
        this(entitySQLContext, table, property, func, String.class);
    }

    public StringTypeExpressionImpl(EntitySQLContext entitySQLContext, TableAvailable table, String property, Function<SQLFunc, SQLFunction> func, Class<?> propType) {
        this.entitySQLContext = entitySQLContext;
        this.table = table;
        this.property = property;
        this.func = func;
        this.propType = propType;
    }

    public String getValue() {
        return this.property;
    }

    public TableAvailable getTable() {
        return this.table;
    }

    @Override
    public void accept(Selector s) {
        SQLFunctionExpressionUtil.accept(s, this.getTable(), this.func);
    }

    @Override
    public void accept(AsSelector s) {
        SQLFunctionExpressionUtil.accept(s, this.getTable(), this.func);
    }

    @Override
    public void accept(GroupSelector s) {
        SQLFunctionExpressionUtil.accept(s, this.getTable(), this.func);
    }

    @Override
    public void accept(OrderSelector s) {
        SQLFunctionExpressionUtil.accept(s, this.getTable(), this.func);
    }

    @Override
    public void asc(boolean condition, OrderByModeEnum nullsModeEnum) {
        if (condition) {
            this.getCurrentEntitySQLContext().accept(new SQLOrderSelectImpl(s -> {
                s.setAsc(true);
                SQLFunc fx = this.getEntitySQLContext().getRuntimeContext().fx();
                SQLFunction sqlFunction = this.func.apply(fx);
                if (nullsModeEnum != null) {
                    SQLFunction orderByNullsModeFunction = fx.orderByNullsMode(sqlFunction, true, nullsModeEnum);
                    s.func(this.getTable(), orderByNullsModeFunction, true);
                } else {
                    s.func(this.getTable(), sqlFunction, true);
                }
            }));
        }
    }

    @Override
    public void desc(boolean condition, OrderByModeEnum nullsModeEnum) {
        if (condition) {
            this.getCurrentEntitySQLContext().accept(new SQLOrderSelectImpl(s -> {
                s.setAsc(false);
                SQLFunc fx = this.getEntitySQLContext().getRuntimeContext().fx();
                SQLFunction sqlFunction = this.func.apply(fx);
                if (nullsModeEnum != null) {
                    SQLFunction orderByNullsModeFunction = fx.orderByNullsMode(sqlFunction, false, nullsModeEnum);
                    s.func(this.getTable(), orderByNullsModeFunction, false);
                } else {
                    s.func(this.getTable(), sqlFunction, true);
                }
            }));
        }
    }

    @Override
    public Function<SQLFunc, SQLFunction> func() {
        return this.func;
    }

    @Override
    public EntitySQLContext getEntitySQLContext() {
        return this.entitySQLContext;
    }

    @Override
    public Class<?> getPropertyType() {
        return this.propType;
    }

    @Override
    public <TR> void _setPropertyType(Class<TR> clazz) {
        this.propType = clazz;
    }
}

