/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.api.proxy.entity.save.abstraction;

import com.easy.query.api.proxy.entity.save.EntitySavable;
import com.easy.query.api.proxy.entity.save.SaveCheckModeEnum;
import com.easy.query.api.proxy.entity.save.command.SaveCommand;
import com.easy.query.api.proxy.entity.save.provider.InsertSaveProvider;
import com.easy.query.api.proxy.entity.save.provider.UpdateSaveProvider;
import com.easy.query.core.api.client.EasyQueryClient;
import com.easy.query.core.basic.extension.track.EntityState;
import com.easy.query.core.basic.extension.track.TrackContext;
import com.easy.query.core.common.ValueHolder;
import com.easy.query.core.context.QueryRuntimeContext;
import com.easy.query.core.exception.EasyQueryException;
import com.easy.query.core.exception.EasyQueryInvalidOperationException;
import com.easy.query.core.expression.lambda.SQLFuncExpression1;
import com.easy.query.core.expression.parser.core.available.MappingPath;
import com.easy.query.core.metadata.IncludePathTreeNode;
import com.easy.query.core.proxy.ProxyEntity;
import com.easy.query.core.util.EasyCollectionUtil;
import com.easy.query.core.util.EasyUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public abstract class AbstractEntitySavable<TProxy extends ProxyEntity<TProxy, T>, T>
implements EntitySavable<TProxy, T> {
    protected final List<T> entities = new ArrayList<T>();
    private final TProxy tProxy;
    private final Class<T> entityClass;
    private final EasyQueryClient easyQueryClient;
    private final QueryRuntimeContext runtimeContext;
    private final TrackContext currentTrackContext;
    private boolean batch;
    private SaveCheckModeEnum saveCheckMode;
    private IncludePathTreeNode includePathTreeRoot;

    public AbstractEntitySavable(TProxy tProxy, Class<T> entityClass, Collection<T> entities, EasyQueryClient easyQueryClient) {
        this.tProxy = tProxy;
        this.entityClass = entityClass;
        this.easyQueryClient = easyQueryClient;
        this.runtimeContext = easyQueryClient.getRuntimeContext();
        if (entities == null) {
            throw new EasyQueryException("\u4e0d\u652f\u6301\u7a7a\u5bf9\u8c61\u7684save");
        }
        this.entities.addAll(entities);
        boolean threadInTransaction = this.runtimeContext.getConnectionManager().currentThreadInTransaction();
        if (!threadInTransaction) {
            throw new EasyQueryInvalidOperationException("current thread not in transaction");
        }
        this.currentTrackContext = Objects.requireNonNull(this.runtimeContext.getTrackManager().getCurrentTrackContext(), "currentTrackContext can not be null");
        this.batch = false;
        this.saveCheckMode = SaveCheckModeEnum.STRICT;
    }

    @Override
    public List<T> getEntities() {
        return this.entities;
    }

    public EntitySavable<TProxy, T> batch(boolean use) {
        this.batch = use;
        return this;
    }

    @Override
    public EntitySavable<TProxy, T> checkMode(SaveCheckModeEnum saveCheckMode) {
        this.saveCheckMode = saveCheckMode;
        return this;
    }

    @Override
    public EntitySavable<TProxy, T> savePath(SQLFuncExpression1<TProxy, List<MappingPath>> navigateIncludeSQLExpression) {
        ValueHolder includeAvailableValueHolder = new ValueHolder();
        this.tProxy.getEntitySQLContext()._include(() -> {
            List values = (List)navigateIncludeSQLExpression.apply(this.tProxy);
            if (values != null) {
                includeAvailableValueHolder.setValue((Object)values);
            }
        });
        List values = (List)includeAvailableValueHolder.getValue();
        if (values != null) {
            this.includePathTreeRoot = EasyUtil.getIncludePathTreeRoot0((List)values);
        }
        return this;
    }

    public void executeCommand() {
        if (!this.entities.isEmpty()) {
            ArrayList<SaveCommand> saveCommands = new ArrayList<SaveCommand>();
            ArrayList<Object> insertEntities = new ArrayList<Object>();
            ArrayList<Object> updateEntities = new ArrayList<Object>();
            for (T entity : this.entities) {
                EntityState entityState = this.currentTrackContext.getTrackEntityState(entity);
                if (entityState == null) {
                    insertEntities.add(entity);
                    continue;
                }
                updateEntities.add(entity);
            }
            List<Set<String>> savePathLimit = this.getSavePathLimit();
            if (EasyCollectionUtil.isNotEmpty(insertEntities)) {
                saveCommands.add(new InsertSaveProvider(this.entityClass, insertEntities, this.easyQueryClient, this.saveCheckMode, savePathLimit).createCommand());
            }
            if (EasyCollectionUtil.isNotEmpty(updateEntities)) {
                saveCommands.add(new UpdateSaveProvider(this.entityClass, updateEntities, this.easyQueryClient, this.saveCheckMode, savePathLimit).createCommand());
            }
            for (SaveCommand saveCommand : saveCommands) {
                saveCommand.execute(this.batch);
            }
        }
    }

    private List<Set<String>> getSavePathLimit() {
        ArrayList<Set<String>> savePathLimit = new ArrayList<Set<String>>();
        if (this.includePathTreeRoot != null) {
            this.parseSavePath(this.includePathTreeRoot, savePathLimit, 0);
        }
        return savePathLimit;
    }

    private void parseSavePath(IncludePathTreeNode includePathTreeRoot, List<Set<String>> savePathLimit, int deep) {
        if (EasyCollectionUtil.isNotEmpty((Collection)includePathTreeRoot.getChildren())) {
            Set<String> savablePathSet = this.getSavablePath(savePathLimit, deep);
            for (IncludePathTreeNode child : includePathTreeRoot.getChildren()) {
                savablePathSet.add(child.getName());
                this.parseSavePath(child, savePathLimit, deep + 1);
            }
        }
    }

    public Set<String> getSavablePath(List<Set<String>> savePathLimit, int index) {
        if (index == savePathLimit.size()) {
            savePathLimit.add(new HashSet());
        } else if (index > savePathLimit.size()) {
            throw new EasyQueryInvalidOperationException("index out of range");
        }
        return savePathLimit.get(index);
    }
}

