/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.api.proxy.entity.save.command;

import com.easy.query.api.proxy.entity.save.SavableContext;
import com.easy.query.api.proxy.entity.save.SaveCommandContext;
import com.easy.query.api.proxy.entity.save.SaveNode;
import com.easy.query.api.proxy.entity.save.command.SaveCommand;
import com.easy.query.core.api.client.EasyQueryClient;
import com.easy.query.core.basic.api.insert.ClientInsertable;
import com.easy.query.core.metadata.EntityMetadata;
import com.easy.query.core.metadata.NavigateMetadata;
import com.easy.query.core.util.EasyCollectionUtil;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class InsertSaveCommand
implements SaveCommand {
    private final EntityMetadata entityMetadata;
    private final List<Object> entities;
    private final EasyQueryClient easyQueryClient;
    private final SaveCommandContext saveCommandContext;

    public InsertSaveCommand(EntityMetadata entityMetadata, List<Object> entities, EasyQueryClient easyQueryClient, SaveCommandContext saveCommandContext) {
        this.entityMetadata = entityMetadata;
        this.entities = entities;
        this.easyQueryClient = easyQueryClient;
        this.saveCommandContext = saveCommandContext;
    }

    @Override
    public void execute(boolean batch) {
        ((ClientInsertable)this.easyQueryClient.insertable(this.entities).batch(batch)).executeRows(this.insertFillAutoIncrement(this.entityMetadata));
        List<SavableContext> savableContexts = this.saveCommandContext.getSavableContexts();
        for (int i = 0; i < savableContexts.size(); ++i) {
            SavableContext savableContext = savableContexts.get(i);
            for (Map.Entry<NavigateMetadata, SaveNode> nodeKv : savableContext.getSaveNodeMap().entrySet()) {
                SaveNode saveNode = nodeKv.getValue();
                List inserts = saveNode.getInserts().stream().map(o -> {
                    o.insertBefore();
                    return o.getEntity();
                }).collect(Collectors.toList());
                ((ClientInsertable)this.easyQueryClient.insertable(inserts).batch(batch)).executeRows(this.insertFillAutoIncrement(saveNode.getEntityMetadata()));
            }
        }
    }

    private boolean insertFillAutoIncrement(EntityMetadata entityMetadata) {
        List generatedKeyColumns = entityMetadata.getGeneratedKeyColumns();
        return EasyCollectionUtil.isNotEmpty((Collection)generatedKeyColumns);
    }
}

