/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.api.proxy.entity.save.command;

import com.easy.query.api.proxy.entity.save.SavableContext;
import com.easy.query.api.proxy.entity.save.SaveCommandContext;
import com.easy.query.api.proxy.entity.save.SaveNode;
import com.easy.query.api.proxy.entity.save.command.SaveCommand;
import com.easy.query.core.api.client.EasyQueryClient;
import com.easy.query.core.basic.api.delete.ClientEntityDeletable;
import com.easy.query.core.basic.api.insert.ClientInsertable;
import com.easy.query.core.basic.api.update.ClientEntityUpdatable;
import com.easy.query.core.metadata.EntityMetadata;
import com.easy.query.core.metadata.NavigateMetadata;
import com.easy.query.core.util.EasyCollectionUtil;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class UpdateSaveCommand
implements SaveCommand {
    private final EntityMetadata entityMetadata;
    private final List<Object> entities;
    private final EasyQueryClient easyQueryClient;
    private final SaveCommandContext saveCommandContext;

    public UpdateSaveCommand(EntityMetadata entityMetadata, List<Object> entities, EasyQueryClient easyQueryClient, SaveCommandContext saveCommandContext) {
        this.entityMetadata = entityMetadata;
        this.entities = entities;
        this.easyQueryClient = easyQueryClient;
        this.saveCommandContext = saveCommandContext;
    }

    @Override
    public void execute(boolean batch) {
        SaveNode saveNode;
        SavableContext savableContext;
        int i;
        List<SavableContext> savableContexts = this.saveCommandContext.getSavableContexts();
        for (i = savableContexts.size() - 1; i >= 0; --i) {
            savableContext = savableContexts.get(i);
            for (Map.Entry<NavigateMetadata, SaveNode> saveNodeEntry : savableContext.getSaveNodeMap().entrySet()) {
                saveNode = saveNodeEntry.getValue();
                ((ClientEntityDeletable)((ClientEntityDeletable)this.easyQueryClient.deletable(saveNode.getDeletes()).batch(batch)).allowDeleteStatement(true)).executeRows();
                if (!EasyCollectionUtil.isNotEmpty(saveNode.getDeleteBys())) continue;
                NavigateMetadata navigateMetadata = saveNodeEntry.getKey();
                String[] selfMappingProperties = navigateMetadata.getSelfMappingProperties();
                String[] targetMappingProperties = navigateMetadata.getTargetMappingProperties();
                ((ClientEntityDeletable)((ClientEntityDeletable)this.easyQueryClient.deletable(saveNode.getDeleteBys()).batch(batch)).allowDeleteStatement(true)).whereColumns(col -> {
                    for (String selfMappingProperty : selfMappingProperties) {
                        col.column(selfMappingProperty);
                    }
                    for (String targetMappingProperty : targetMappingProperties) {
                        col.column(targetMappingProperty);
                    }
                }).executeRows();
            }
        }
        ((ClientEntityUpdatable)this.easyQueryClient.updatable(this.entities).batch(batch)).executeRows();
        for (i = 0; i < savableContexts.size(); ++i) {
            savableContext = savableContexts.get(i);
            for (Map.Entry<NavigateMetadata, SaveNode> nodeKv : savableContext.getSaveNodeMap().entrySet()) {
                saveNode = nodeKv.getValue();
                List inserts = saveNode.getInserts().stream().map(o -> {
                    o.insertBefore();
                    return o.getEntity();
                }).collect(Collectors.toList());
                ((ClientInsertable)this.easyQueryClient.insertable(inserts).batch(batch)).executeRows(this.insertFillAutoIncrement(saveNode.getEntityMetadata()));
                ((ClientEntityUpdatable)this.easyQueryClient.updatable(saveNode.getUpdates()).batch(batch)).executeRows();
            }
        }
    }

    private boolean insertFillAutoIncrement(EntityMetadata entityMetadata) {
        List generatedKeyColumns = entityMetadata.getGeneratedKeyColumns();
        return EasyCollectionUtil.isNotEmpty((Collection)generatedKeyColumns);
    }
}

