/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.api.proxy.entity.save.provider;

import com.easy.query.api.proxy.entity.save.SavableContext;
import com.easy.query.api.proxy.entity.save.SaveCheckModeEnum;
import com.easy.query.api.proxy.entity.save.SaveCommandContext;
import com.easy.query.api.proxy.entity.save.TargetValueTypeEnum;
import com.easy.query.api.proxy.entity.save.provider.SaveProvider;
import com.easy.query.core.api.client.EasyQueryClient;
import com.easy.query.core.basic.extension.track.TrackContext;
import com.easy.query.core.context.QueryRuntimeContext;
import com.easy.query.core.enums.RelationTypeEnum;
import com.easy.query.core.exception.EasyQueryInvalidOperationException;
import com.easy.query.core.expression.lambda.Property;
import com.easy.query.core.metadata.ColumnMetadata;
import com.easy.query.core.metadata.EntityMetadata;
import com.easy.query.core.metadata.EntityMetadataManager;
import com.easy.query.core.metadata.NavigateMetadata;
import com.easy.query.core.util.EasyArrayUtil;
import com.easy.query.core.util.EasyClassUtil;
import com.easy.query.core.util.EasyCollectionUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public abstract class AbstractSaveProvider
implements SaveProvider {
    protected final Class<?> entityClass;
    protected final List<Object> entities;
    protected final EasyQueryClient easyQueryClient;
    protected final QueryRuntimeContext runtimeContext;
    protected final SaveCheckModeEnum saveCheckMode;
    protected final EntityMetadataManager entityMetadataManager;
    protected final TrackContext currentTrackContext;
    protected final List<Set<String>> savePathLimit;
    protected final SaveCommandContext saveCommandContext;

    public AbstractSaveProvider(Class<?> entityClass, List<Object> entities, EasyQueryClient easyQueryClient, SaveCheckModeEnum saveCheckMode, List<Set<String>> savePathLimit) {
        this.entityClass = entityClass;
        this.entities = entities;
        this.easyQueryClient = easyQueryClient;
        this.runtimeContext = easyQueryClient.getRuntimeContext();
        this.saveCheckMode = saveCheckMode;
        TrackContext currentTrackContext = this.runtimeContext.getTrackManager().getCurrentTrackContext();
        if (currentTrackContext == null) {
            throw new EasyQueryInvalidOperationException("currentTrackContext can not be null");
        }
        this.currentTrackContext = currentTrackContext;
        this.entityMetadataManager = this.runtimeContext.getEntityMetadataManager();
        this.savePathLimit = savePathLimit;
        this.saveCommandContext = new SaveCommandContext(entityClass);
    }

    protected boolean isSavePathLimitContains(NavigateMetadata navigateMetadata, int deep) {
        if (this.savePathLimit.isEmpty()) {
            return true;
        }
        if (this.savePathLimit.size() > deep) {
            return this.savePathLimit.get(deep).contains(navigateMetadata.getPropertyName());
        }
        return false;
    }

    protected TargetValueTypeEnum getTargetValueType(EntityMetadata selfMetadata, NavigateMetadata navigateMetadata) {
        if (navigateMetadata.getRelationType() == RelationTypeEnum.ManyToMany) {
            boolean any;
            if (navigateMetadata.getMappingClass() != null && (any = this.selfPropsIsKeys(selfMetadata, navigateMetadata))) {
                return TargetValueTypeEnum.VALUE_OBJECT;
            }
            return TargetValueTypeEnum.RELATION_OTHER;
        }
        boolean selfIsKey = this.selfPropsIsKeys(selfMetadata, navigateMetadata);
        if (selfIsKey) {
            return TargetValueTypeEnum.VALUE_OBJECT;
        }
        boolean targetIsKey = this.targetPropsIsKeys(selfMetadata, navigateMetadata);
        if (targetIsKey) {
            return TargetValueTypeEnum.AGGREGATE_ROOT;
        }
        return TargetValueTypeEnum.RELATION_OTHER;
    }

    protected boolean selfPropsIsKeys(EntityMetadata selfMetadata, NavigateMetadata navigateMetadata) {
        Collection keyProperties;
        Object[] selfPropertiesOrPrimary = navigateMetadata.getSelfPropertiesOrPrimary();
        if (selfPropertiesOrPrimary.length != (keyProperties = selfMetadata.getKeyProperties()).size()) {
            return false;
        }
        return EasyArrayUtil.all((Object[])selfPropertiesOrPrimary, prop -> keyProperties.contains(prop));
    }

    protected boolean targetPropsIsKeys(EntityMetadata selfMetadata, NavigateMetadata navigateMetadata) {
        Collection keyProperties;
        Object[] targetPropertiesOrPrimary = navigateMetadata.getTargetPropertiesOrPrimary(this.runtimeContext);
        if (targetPropertiesOrPrimary.length != (keyProperties = selfMetadata.getKeyProperties()).size()) {
            return false;
        }
        return EasyArrayUtil.all((Object[])targetPropertiesOrPrimary, prop -> keyProperties.contains(prop));
    }

    protected void setTargetValue(TargetValueTypeEnum targetValueType, Object selfEntity, Object targetEntity, EntityMetadata selfEntityMetadata, NavigateMetadata navigateMetadata, EntityMetadata targetEntityMetadata) {
        if (targetValueType == TargetValueTypeEnum.VALUE_OBJECT) {
            String[] selfPropertiesOrPrimary = navigateMetadata.getSelfPropertiesOrPrimary();
            String[] targetPropertiesOrPrimary = navigateMetadata.getTargetPropertiesOrPrimary(this.runtimeContext);
            for (int i = 0; i < selfPropertiesOrPrimary.length; ++i) {
                String self = selfPropertiesOrPrimary[i];
                String target = targetPropertiesOrPrimary[i];
                ColumnMetadata selfColumn = selfEntityMetadata.getColumnNotNull(self);
                Object selfValue = selfColumn.getGetterCaller().apply(selfEntity);
                if (selfValue == null) {
                    throw new EasyQueryInvalidOperationException("entity:[" + EasyClassUtil.getInstanceSimpleName((Object)selfEntity) + "] property:[" + self + "] value can not be null, cant set relation value for entity:[" + EasyClassUtil.getInstanceSimpleName((Object)targetEntity) + "]");
                }
                ColumnMetadata targetColumn = targetEntityMetadata.getColumnNotNull(target);
                Object currentValue = targetColumn.getGetterCaller().apply(targetEntity);
                if (currentValue == null) {
                    targetColumn.getSetterCaller().call(targetEntity, selfValue);
                    continue;
                }
                if (Objects.equals(currentValue, selfValue)) continue;
                throw new EasyQueryInvalidOperationException("relation value not equals,entity:[" + EasyClassUtil.getInstanceSimpleName((Object)targetEntity) + "],property:[" + target + "],value:[" + currentValue + "],should:[" + selfValue + "]");
            }
        } else if (targetValueType == TargetValueTypeEnum.AGGREGATE_ROOT) {
            String[] selfPropertiesOrPrimary = navigateMetadata.getSelfPropertiesOrPrimary();
            String[] targetPropertiesOrPrimary = navigateMetadata.getTargetPropertiesOrPrimary(this.runtimeContext);
            for (int i = 0; i < selfPropertiesOrPrimary.length; ++i) {
                String self = selfPropertiesOrPrimary[i];
                String target = targetPropertiesOrPrimary[i];
                ColumnMetadata targetColumn = targetEntityMetadata.getColumnNotNull(target);
                Object targetValue = targetColumn.getGetterCaller().apply(targetEntity);
                if (targetValue == null) {
                    throw new EasyQueryInvalidOperationException("entity:[" + EasyClassUtil.getInstanceSimpleName((Object)targetEntity) + "] property:[" + target + "] value can not be null, cant set relation value for entity:[" + EasyClassUtil.getInstanceSimpleName((Object)selfEntity) + "]");
                }
                ColumnMetadata selfColumn = selfEntityMetadata.getColumnNotNull(self);
                selfColumn.getSetterCaller().call(selfEntity, targetValue);
                Object currentValue = selfColumn.getGetterCaller().apply(selfEntity);
                if (currentValue == null) {
                    selfColumn.getSetterCaller().call(selfEntity, targetValue);
                    continue;
                }
                if (Objects.equals(currentValue, targetValue)) continue;
                throw new EasyQueryInvalidOperationException("relation value not equals,entity:[" + EasyClassUtil.getInstanceSimpleName((Object)selfEntity) + "],property:[" + self + "],value:[" + currentValue + "],should:[" + targetValue + "]");
            }
        } else {
            throw new EasyQueryInvalidOperationException("save not support target value type:" + (Object)((Object)targetValueType));
        }
    }

    protected void setMappingEntity(Object selfEntity, Object targetEntity, Object mappingEntity, EntityMetadata selfEntityMetadata, NavigateMetadata navigateMetadata, EntityMetadata targetEntityMetadata, EntityMetadata mappingEntityMetadata) {
        String[] selfMappingProperties = navigateMetadata.getSelfMappingProperties();
        String[] selfPropertiesOrPrimary = navigateMetadata.getSelfPropertiesOrPrimary();
        for (int i = 0; i < selfMappingProperties.length; ++i) {
            String selfMappingProperty = selfMappingProperties[i];
            String self = selfPropertiesOrPrimary[i];
            ColumnMetadata selfColumn = selfEntityMetadata.getColumnNotNull(self);
            Object selfValue = selfColumn.getGetterCaller().apply(selfEntity);
            if (selfValue == null) {
                throw new EasyQueryInvalidOperationException("entityClass:[" + EasyClassUtil.getInstanceSimpleName((Object)selfEntity) + "] property:[" + self + "] value can not be null,Please make sure the [" + EasyClassUtil.getInstanceSimpleName((Object)selfEntity) + "] instance has been persisted to the database before use.");
            }
            ColumnMetadata columnMetadata = mappingEntityMetadata.getColumnNotNull(selfMappingProperty);
            columnMetadata.getSetterCaller().call(mappingEntity, selfValue);
        }
        String[] targetMappingProperties = navigateMetadata.getTargetMappingProperties();
        String[] targetPropertiesOrPrimary = navigateMetadata.getTargetPropertiesOrPrimary(this.runtimeContext);
        for (int i = 0; i < targetMappingProperties.length; ++i) {
            String targetMappingProperty = targetMappingProperties[i];
            String target = targetPropertiesOrPrimary[i];
            ColumnMetadata targetColumn = targetEntityMetadata.getColumnNotNull(target);
            Object targetValue = targetColumn.getGetterCaller().apply(targetEntity);
            if (targetValue == null) {
                throw new EasyQueryInvalidOperationException("entityClass:[" + EasyClassUtil.getInstanceSimpleName((Object)targetEntity) + "] property:[" + target + "] value can not be null,Please make sure the [" + EasyClassUtil.getInstanceSimpleName((Object)targetEntity) + "] instance has been persisted to the database before use.");
            }
            ColumnMetadata columnMetadata = mappingEntityMetadata.getColumnNotNull(targetMappingProperty);
            columnMetadata.getSetterCaller().call(mappingEntity, targetValue);
        }
    }

    protected abstract EntityMetadata checkNavigateContinueAndGetTargetEntityMetadata(NavigateMetadata var1, Object var2, EntityMetadata var3, int var4);

    protected List<NavigateMetadata> getNavigateSavableValueObjects(SavableContext savableContext, Object entity, EntityMetadata entityMetadata, Collection<NavigateMetadata> navigateMetadataList, int deep) {
        ArrayList<NavigateMetadata> valueObjects = new ArrayList<NavigateMetadata>();
        ArrayList<NavigateMetadata> aggregateRoots = new ArrayList<NavigateMetadata>();
        HashSet navigateMetadataSet = new HashSet(entityMetadata.getNavigateMetadatas());
        for (NavigateMetadata navigateMetadata : navigateMetadataList) {
            navigateMetadataSet.remove(navigateMetadata);
            EntityMetadata targetEntityMetadata = this.checkNavigateContinueAndGetTargetEntityMetadata(navigateMetadata, entity, entityMetadata, deep);
            if (targetEntityMetadata == null || this.saveCommandContext.circulateCheck(navigateMetadata.getNavigatePropertyType(), deep)) continue;
            savableContext.putSaveNodeMap(navigateMetadata, targetEntityMetadata);
            TargetValueTypeEnum targetValueType = this.getTargetValueType(entityMetadata, navigateMetadata);
            if (targetValueType == TargetValueTypeEnum.VALUE_OBJECT) {
                valueObjects.add(navigateMetadata);
            }
            if (targetValueType != TargetValueTypeEnum.AGGREGATE_ROOT) continue;
            aggregateRoots.add(navigateMetadata);
        }
        for (NavigateMetadata navigateMetadata : aggregateRoots) {
            Property getter = navigateMetadata.getGetter();
            Object aggregateRoot = getter.apply(entity);
            if (aggregateRoot == null) continue;
            EntityMetadata aggregateRootMetadata = this.entityMetadataManager.getEntityMetadata(navigateMetadata.getNavigatePropertyType());
            this.setTargetValue(TargetValueTypeEnum.AGGREGATE_ROOT, entity, aggregateRoot, entityMetadata, navigateMetadata, aggregateRootMetadata);
        }
        if (this.savePathLimit.isEmpty() && this.saveCheckMode == SaveCheckModeEnum.STRICT) {
            for (NavigateMetadata navigateMetadata : navigateMetadataSet) {
                this.checkNavigatePathTrackedCheck(navigateMetadata, entity, entityMetadata);
            }
        }
        return valueObjects;
    }

    protected void checkNavigatePathTrackedCheck(NavigateMetadata navigate, Object entity, EntityMetadata selfEntityMetadata) {
        if (this.saveCheckMode == SaveCheckModeEnum.STRICT) {
            Object newEntity;
            Object newNavigateValue;
            Collection navigateValues;
            Property getter = navigate.getGetter();
            Object navigateValue = getter.apply(entity);
            if (navigateValue == null) {
                return;
            }
            if (navigateValue instanceof Collection && EasyCollectionUtil.isEmpty((Collection)(navigateValues = (Collection)navigateValue)) && (newNavigateValue = getter.apply(newEntity = selfEntityMetadata.getBeanConstructorCreator().get())) != null) {
                return;
            }
            throw new EasyQueryInvalidOperationException("The current navigation property [" + EasyClassUtil.getInstanceSimpleName((Object)entity) + "." + navigate.getPropertyName() + "] is not being tracked.");
        }
    }
}

