/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.api.proxy.entity.save.provider;

import com.easy.query.api.proxy.entity.save.SavableContext;
import com.easy.query.api.proxy.entity.save.SaveCheckModeEnum;
import com.easy.query.api.proxy.entity.save.SaveNode;
import com.easy.query.api.proxy.entity.save.TargetValueTypeEnum;
import com.easy.query.api.proxy.entity.save.command.EmptySaveCommand;
import com.easy.query.api.proxy.entity.save.command.InsertSaveCommand;
import com.easy.query.api.proxy.entity.save.command.SaveCommand;
import com.easy.query.api.proxy.entity.save.provider.AbstractSaveProvider;
import com.easy.query.core.api.client.EasyQueryClient;
import com.easy.query.core.basic.extension.track.EntityState;
import com.easy.query.core.enums.MappingClassSaveModeEnum;
import com.easy.query.core.enums.RelationTypeEnum;
import com.easy.query.core.exception.EasyQueryInvalidOperationException;
import com.easy.query.core.expression.lambda.Property;
import com.easy.query.core.metadata.EntityMetadata;
import com.easy.query.core.metadata.NavigateMetadata;
import com.easy.query.core.util.EasyArrayUtil;
import com.easy.query.core.util.EasyClassUtil;
import com.easy.query.core.util.EasyCollectionUtil;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class InsertSaveProvider
extends AbstractSaveProvider {
    public InsertSaveProvider(Class<?> entityClass, List<Object> entities, EasyQueryClient easyQueryClient, SaveCheckModeEnum saveCheckMode, List<Set<String>> savePathLimit) {
        super(entityClass, entities, easyQueryClient, saveCheckMode, savePathLimit);
    }

    @Override
    protected EntityMetadata checkNavigateContinueAndGetTargetEntityMetadata(NavigateMetadata navigateMetadata, Object entity, EntityMetadata entityMetadata, int deep) {
        if (!this.isSavePathLimitContains(navigateMetadata, deep)) {
            return null;
        }
        if (navigateMetadata.getRelationType() == RelationTypeEnum.ManyToMany && navigateMetadata.getMappingClass() != null) {
            return this.entityMetadataManager.getEntityMetadata(navigateMetadata.getMappingClass());
        }
        return this.entityMetadataManager.getEntityMetadata(navigateMetadata.getNavigatePropertyType());
    }

    @Override
    public SaveCommand createCommand() {
        if (EasyCollectionUtil.isNotEmpty((Collection)this.entities)) {
            EntityMetadata entityMetadata = this.entityMetadataManager.getEntityMetadata(this.entityClass);
            for (Object entity : this.entities) {
                this.saveCommandContext.addProcessEntity(entity);
                this.saveEntity(entity, entityMetadata, 0);
            }
            return new InsertSaveCommand(entityMetadata, this.entities, this.easyQueryClient, this.saveCommandContext);
        }
        return EmptySaveCommand.INSTANCE;
    }

    private void saveEntity(Object entity, EntityMetadata entityMetadata, int deep) {
        EntityState entityState = this.currentTrackContext.getTrackEntityState(entity);
        if (entityState != null) {
            throw new EasyQueryInvalidOperationException("entity:" + EasyClassUtil.getSimpleName(entity.getClass()) + " has been tracked");
        }
        SavableContext savableContext = this.saveCommandContext.getSavableContext(deep);
        List<NavigateMetadata> valueObjects = this.getNavigateSavableValueObjects(savableContext, entity, entityMetadata, entityMetadata.getNavigateMetadatas(), deep);
        for (NavigateMetadata navigateMetadata : valueObjects) {
            this.processNavigate(entity, entityMetadata, navigateMetadata, savableContext);
        }
    }

    private void processNavigate(Object entity, EntityMetadata selfEntityMetadata, NavigateMetadata navigateMetadata, SavableContext savableContext) {
        if (EasyArrayUtil.isNotEmpty((Object[])navigateMetadata.getDirectMapping())) {
            throw new EasyQueryInvalidOperationException("save not support direct mapping");
        }
        EntityMetadata targetEntityMetadata = this.entityMetadataManager.getEntityMetadata(navigateMetadata.getNavigatePropertyType());
        SaveNode saveNode = savableContext.getSaveNode(navigateMetadata);
        Property getter = navigateMetadata.getGetter();
        Object navigates = getter.apply(entity);
        if (navigates instanceof Collection) {
            for (Object targetEntity : (Collection)navigates) {
                this.processEntity(entity, targetEntity, selfEntityMetadata, targetEntityMetadata, navigateMetadata, saveNode);
            }
        } else if (navigates != null) {
            this.processEntity(entity, navigates, selfEntityMetadata, targetEntityMetadata, navigateMetadata, saveNode);
        }
    }

    private void processEntity(Object selfEntity, Object targetEntity, EntityMetadata selfEntityMetadata, EntityMetadata targetEntityMetadata, NavigateMetadata navigateMetadata, SaveNode saveNode) {
        if (this.saveCommandContext.isProcessEntity(targetEntity)) {
            return;
        }
        this.saveCommandContext.addProcessEntity(targetEntity);
        if (navigateMetadata.getRelationType() == RelationTypeEnum.ManyToMany) {
            if (navigateMetadata.getMappingClass() == null) {
                throw new EasyQueryInvalidOperationException("entity:[" + EasyClassUtil.getSimpleName((Class)navigateMetadata.getEntityMetadata().getEntityClass()) + "]-[" + EasyClassUtil.getSimpleName((Class)navigateMetadata.getNavigatePropertyType()) + "] many to many relation must have mapping class");
            }
            if (navigateMetadata.getMappingClassSaveMode() == MappingClassSaveModeEnum.THROW) {
                throw new EasyQueryInvalidOperationException("entity:[" + EasyClassUtil.getSimpleName((Class)navigateMetadata.getEntityMetadata().getEntityClass()) + "]-[" + EasyClassUtil.getSimpleName((Class)navigateMetadata.getNavigatePropertyType()) + "] many to many relation mapping class save mode is throw");
            }
            if (navigateMetadata.getMappingClassSaveMode() == MappingClassSaveModeEnum.AUTO) {
                EntityMetadata mappingClassEntityMetadata = this.entityMetadataManager.getEntityMetadata(navigateMetadata.getMappingClass());
                Object mappingEntity = mappingClassEntityMetadata.getBeanConstructorCreator().get();
                saveNode.getInserts().add(new SaveNode.InsertItem(mappingEntity, t -> this.setMappingEntity(selfEntity, targetEntity, t, selfEntityMetadata, navigateMetadata, targetEntityMetadata, mappingClassEntityMetadata)));
            }
        } else {
            saveNode.getInserts().add(new SaveNode.InsertItem(targetEntity, t -> this.setTargetValue(TargetValueTypeEnum.VALUE_OBJECT, selfEntity, t, selfEntityMetadata, navigateMetadata, targetEntityMetadata)));
            EntityState trackEntityState = this.currentTrackContext.getTrackEntityState(targetEntity);
            if (trackEntityState == null) {
                this.saveEntity(targetEntity, targetEntityMetadata, saveNode.getIndex() + 1);
            }
        }
    }
}

