/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.api.proxy.entity.save.provider;

import com.easy.query.api.proxy.entity.save.SavableContext;
import com.easy.query.api.proxy.entity.save.SaveCheckModeEnum;
import com.easy.query.api.proxy.entity.save.SaveCommandContext;
import com.easy.query.api.proxy.entity.save.SaveNode;
import com.easy.query.api.proxy.entity.save.TargetValueTypeEnum;
import com.easy.query.api.proxy.entity.save.command.EmptySaveCommand;
import com.easy.query.api.proxy.entity.save.command.SaveCommand;
import com.easy.query.api.proxy.entity.save.command.UpdateSaveCommand;
import com.easy.query.api.proxy.entity.save.provider.AbstractSaveProvider;
import com.easy.query.core.api.client.EasyQueryClient;
import com.easy.query.core.basic.extension.track.EntityState;
import com.easy.query.core.basic.extension.track.EntityValueState;
import com.easy.query.core.enums.MappingClassSaveModeEnum;
import com.easy.query.core.enums.RelationTypeEnum;
import com.easy.query.core.exception.EasyQueryInvalidOperationException;
import com.easy.query.core.expression.lambda.Property;
import com.easy.query.core.metadata.ColumnMetadata;
import com.easy.query.core.metadata.EntityMetadata;
import com.easy.query.core.metadata.NavigateMetadata;
import com.easy.query.core.util.EasyArrayUtil;
import com.easy.query.core.util.EasyClassUtil;
import com.easy.query.core.util.EasyCollectionUtil;
import com.easy.query.core.util.EasyTrackUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class UpdateSaveProvider
extends AbstractSaveProvider {
    private final SaveCommandContext saveCommandContext;
    private SaveCommandContext savePathCommandContext;

    public UpdateSaveProvider(Class<?> entityClass, List<Object> entities, EasyQueryClient easyQueryClient, SaveCheckModeEnum saveCheckMode, List<Set<String>> savePathLimit) {
        super(entityClass, entities, easyQueryClient, saveCheckMode, savePathLimit);
        this.saveCommandContext = new SaveCommandContext(entityClass);
    }

    @Override
    public SaveCommand createCommand() {
        if (EasyCollectionUtil.isNotEmpty((Collection)this.entities)) {
            EntityMetadata entityMetadata = this.entityMetadataManager.getEntityMetadata(this.entityClass);
            for (Object entity : this.entities) {
                String trackKey = EasyTrackUtil.getTrackKey((EntityMetadata)entityMetadata, entity);
                this.savePathCommandContext = new SaveCommandContext(this.entityClass);
                this.createIncludePath(this.entityClass, entityMetadata, trackKey, 0);
                this.saveCommandContext.addProcessEntity(entity);
                this.saveEntity(entity, entityMetadata, 0);
            }
            return new UpdateSaveCommand(entityMetadata, this.entities, this.easyQueryClient, this.saveCommandContext);
        }
        return EmptySaveCommand.INSTANCE;
    }

    private void createIncludePath(Class<?> entityClass, EntityMetadata entityMetadata, String trackKey, int deep) {
        EntityState entityState = this.currentTrackContext.getTrackEntityState(entityClass, trackKey);
        if (entityState != null) {
            SavableContext savableContext = this.savePathCommandContext.getSavableContext(deep);
            List includes = entityState.getIncludes();
            if (includes != null) {
                for (NavigateMetadata include : includes) {
                    TargetValueTypeEnum targetValueType;
                    if (EasyArrayUtil.isNotEmpty((Object[])include.getDirectMapping())) {
                        return;
                    }
                    if (this.savePathCommandContext.circulateCheck(include.getNavigatePropertyType(), deep) || (targetValueType = this.getTargetValueType(entityMetadata, include)) != TargetValueTypeEnum.VALUE_OBJECT && targetValueType != TargetValueTypeEnum.AGGREGATE_ROOT) continue;
                    this.createNavigatePath(include, savableContext, entityState.getTrackKeys(include));
                }
            }
        }
    }

    private void createNavigatePath(NavigateMetadata navigateMetadata, SavableContext savableContext, Set<String> trackKeys) {
        EntityMetadata targetEntityMetadata = null;
        targetEntityMetadata = navigateMetadata.getRelationType() == RelationTypeEnum.ManyToMany && navigateMetadata.getMappingClass() != null ? this.entityMetadataManager.getEntityMetadata(navigateMetadata.getMappingClass()) : this.entityMetadataManager.getEntityMetadata(navigateMetadata.getNavigatePropertyType());
        SaveNode saveNode = savableContext.putSaveNodeMap(navigateMetadata, targetEntityMetadata);
        if (trackKeys != null) {
            for (String trackKey : trackKeys) {
                if (trackKey == null) continue;
                this.createIncludePath(targetEntityMetadata.getEntityClass(), targetEntityMetadata, trackKey, saveNode.getIndex() + 1);
            }
        }
    }

    private void saveEntity(Object entity, EntityMetadata entityMetadata, int deep) {
        EntityState entityState = this.currentTrackContext.getTrackEntityState(entity);
        SavableContext savableContext = this.saveCommandContext.getSavableContext(deep);
        SavableContext savablePathContext = this.savePathCommandContext.getSavableContext(deep);
        Set<NavigateMetadata> navigateMetadataSet = savablePathContext.getSaveNodeMap().keySet();
        List<NavigateMetadata> valueObjects = this.getNavigateSavableValueObjects(savableContext, entity, entityMetadata, navigateMetadataSet, deep);
        for (NavigateMetadata navigateMetadata : valueObjects) {
            Set trackKeys = entityState == null ? null : entityState.getTrackKeys(navigateMetadata);
            this.processNavigate(entity, entityMetadata, navigateMetadata, savableContext, trackKeys == null ? new HashSet() : trackKeys);
        }
    }

    private void processNavigate(Object entity, EntityMetadata selfEntityMetadata, NavigateMetadata navigateMetadata, SavableContext savableContext, Set<String> trackKeys) {
        if (trackKeys != null) {
            if (EasyArrayUtil.isNotEmpty((Object[])navigateMetadata.getDirectMapping())) {
                throw new EasyQueryInvalidOperationException("save not support direct mapping");
            }
            EntityMetadata targetEntityMetadata = this.entityMetadataManager.getEntityMetadata(navigateMetadata.getNavigatePropertyType());
            SaveNode saveNode = savableContext.getSaveNode(navigateMetadata);
            LinkedHashMap<String, Object> dbEntityMap = new LinkedHashMap<String, Object>();
            for (String trackKey : trackKeys) {
                EntityState trackEntityState = this.currentTrackContext.getTrackEntityState(navigateMetadata.getNavigatePropertyType(), trackKey);
                Objects.requireNonNull(trackEntityState, "trackEntityState cant be null,trackKey:" + trackKey);
                dbEntityMap.put(trackKey, trackEntityState.getOriginalValue());
            }
            Property getter = navigateMetadata.getGetter();
            Object navigates = getter.apply(entity);
            if (navigates instanceof Collection) {
                for (Object targetEntity : (Collection)navigates) {
                    this.processEntity(dbEntityMap, entity, targetEntity, selfEntityMetadata, targetEntityMetadata, navigateMetadata, saveNode);
                }
            } else if (navigates != null) {
                this.processEntity(dbEntityMap, entity, navigates, selfEntityMetadata, targetEntityMetadata, navigateMetadata, saveNode);
            }
            for (Object value : dbEntityMap.values()) {
                this.saveNodeDelete(entity, value, selfEntityMetadata, targetEntityMetadata, navigateMetadata, saveNode);
            }
        }
    }

    private void processEntity(Map<String, Object> dbEntityMap, Object selfEntity, Object targetEntity, EntityMetadata selfEntityMetadata, EntityMetadata targetEntityMetadata, NavigateMetadata navigateMetadata, SaveNode saveNode) {
        if (this.saveCommandContext.isProcessEntity(targetEntity)) {
            return;
        }
        this.saveCommandContext.addProcessEntity(targetEntity);
        String newNavigateEntityKey = EasyTrackUtil.getTrackKey((EntityMetadata)targetEntityMetadata, (Object)targetEntity);
        if (newNavigateEntityKey == null || !dbEntityMap.containsKey(newNavigateEntityKey)) {
            this.saveNodeInsert(selfEntity, targetEntity, selfEntityMetadata, targetEntityMetadata, navigateMetadata, saveNode);
        } else {
            dbEntityMap.remove(newNavigateEntityKey);
            EntityState trackEntityState = this.currentTrackContext.getTrackEntityState(navigateMetadata.getNavigatePropertyType(), newNavigateEntityKey);
            Objects.requireNonNull(trackEntityState, "trackEntityState cant be null,trackKey:" + newNavigateEntityKey);
            if (targetEntity != trackEntityState.getCurrentValue()) {
                throw new EasyQueryInvalidOperationException("entity:" + targetEntity + " is not same with:" + trackEntityState.getCurrentValue());
            }
            this.saveNodeUpdate(trackEntityState, targetEntity, targetEntityMetadata, navigateMetadata, saveNode);
        }
        if (navigateMetadata.getRelationType() != RelationTypeEnum.ManyToMany) {
            this.saveEntity(targetEntity, targetEntityMetadata, saveNode.getIndex() + 1);
        }
    }

    private void saveNodeDelete(Object selfEntity, Object targetEntity, EntityMetadata selfEntityMetadata, EntityMetadata targetEntityMetadata, NavigateMetadata navigateMetadata, SaveNode saveNode) {
        if (navigateMetadata.getRelationType() == RelationTypeEnum.ManyToMany) {
            if (navigateMetadata.getMappingClass() == null) {
                throw new EasyQueryInvalidOperationException("entity:[" + EasyClassUtil.getSimpleName((Class)navigateMetadata.getEntityMetadata().getEntityClass()) + "]-[" + EasyClassUtil.getSimpleName((Class)navigateMetadata.getNavigatePropertyType()) + "] many to many relation must have mapping class");
            }
            if (navigateMetadata.getMappingClassSaveMode() == MappingClassSaveModeEnum.THROW) {
                throw new EasyQueryInvalidOperationException("entity:[" + EasyClassUtil.getSimpleName((Class)navigateMetadata.getEntityMetadata().getEntityClass()) + "]-[" + EasyClassUtil.getSimpleName((Class)navigateMetadata.getNavigatePropertyType()) + "] many to many relation mapping class save mode is throw");
            }
            if (navigateMetadata.getMappingClassSaveMode() == MappingClassSaveModeEnum.AUTO) {
                EntityMetadata mappingClassEntityMetadata = this.entityMetadataManager.getEntityMetadata(navigateMetadata.getMappingClass());
                Object mappingEntity = mappingClassEntityMetadata.getBeanConstructorCreator().get();
                this.setMappingEntity(selfEntity, targetEntity, mappingEntity, selfEntityMetadata, navigateMetadata, targetEntityMetadata, mappingClassEntityMetadata);
                saveNode.getDeleteBys().add(mappingEntity);
            }
        } else {
            saveNode.getDeletes().add(targetEntity);
        }
    }

    private void saveNodeUpdate(EntityState trackEntityState, Object targetEntity, EntityMetadata targetEntityMetadata, NavigateMetadata navigateMetadata, SaveNode saveNode) {
        if (navigateMetadata.getRelationType() == RelationTypeEnum.ManyToMany) {
            if (navigateMetadata.getMappingClass() == null) {
                throw new EasyQueryInvalidOperationException("entity:[" + EasyClassUtil.getSimpleName((Class)navigateMetadata.getEntityMetadata().getEntityClass()) + "]-[" + EasyClassUtil.getSimpleName((Class)navigateMetadata.getNavigatePropertyType()) + "] many to many relation must have mapping class");
            }
            if (navigateMetadata.getMappingClassSaveMode() == MappingClassSaveModeEnum.THROW) {
                throw new EasyQueryInvalidOperationException("entity:[" + EasyClassUtil.getSimpleName((Class)navigateMetadata.getEntityMetadata().getEntityClass()) + "]-[" + EasyClassUtil.getSimpleName((Class)navigateMetadata.getNavigatePropertyType()) + "] many to many relation mapping class save mode is throw");
            }
            return;
        }
        for (Map.Entry propColumn : targetEntityMetadata.getProperty2ColumnMap().entrySet()) {
            EntityValueState entityValueState = trackEntityState.getEntityValueState((ColumnMetadata)propColumn.getValue());
            if (!entityValueState.isChanged()) continue;
            saveNode.getUpdates().add(targetEntity);
            break;
        }
    }

    private void saveNodeInsert(Object selfEntity, Object targetEntity, EntityMetadata selfEntityMetadata, EntityMetadata targetEntityMetadata, NavigateMetadata navigateMetadata, SaveNode saveNode) {
        if (navigateMetadata.getRelationType() == RelationTypeEnum.ManyToMany) {
            if (navigateMetadata.getMappingClass() == null) {
                throw new EasyQueryInvalidOperationException("entity:[" + EasyClassUtil.getSimpleName((Class)navigateMetadata.getEntityMetadata().getEntityClass()) + "]-[" + EasyClassUtil.getSimpleName((Class)navigateMetadata.getNavigatePropertyType()) + "] many to many relation must have mapping class");
            }
            if (navigateMetadata.getMappingClassSaveMode() == MappingClassSaveModeEnum.THROW) {
                throw new EasyQueryInvalidOperationException("entity:[" + EasyClassUtil.getSimpleName((Class)navigateMetadata.getEntityMetadata().getEntityClass()) + "]-[" + EasyClassUtil.getSimpleName((Class)navigateMetadata.getNavigatePropertyType()) + "] many to many relation mapping class save mode is throw");
            }
            if (navigateMetadata.getMappingClassSaveMode() == MappingClassSaveModeEnum.AUTO) {
                EntityMetadata mappingClassEntityMetadata = this.entityMetadataManager.getEntityMetadata(navigateMetadata.getMappingClass());
                Object mappingEntity = mappingClassEntityMetadata.getBeanConstructorCreator().get();
                saveNode.getInserts().add(new SaveNode.InsertItem(mappingEntity, t -> this.setMappingEntity(selfEntity, targetEntity, t, selfEntityMetadata, navigateMetadata, targetEntityMetadata, mappingClassEntityMetadata)));
            }
        } else {
            saveNode.getInserts().add(new SaveNode.InsertItem(targetEntity, t -> this.setTargetValue(TargetValueTypeEnum.VALUE_OBJECT, selfEntity, t, selfEntityMetadata, navigateMetadata, targetEntityMetadata)));
        }
    }

    @Override
    protected EntityMetadata checkNavigateContinueAndGetTargetEntityMetadata(NavigateMetadata navigateMetadata, Object entity, EntityMetadata entityMetadata, int deep) {
        SavableContext pathSavableContext = this.savePathCommandContext.getSavableContext(deep);
        if (!this.isSavePathLimitContains(navigateMetadata, deep)) {
            return null;
        }
        SaveNode saveNode = pathSavableContext.getSaveNode(navigateMetadata);
        if (saveNode == null) {
            this.checkNavigatePathTrackedCheck(navigateMetadata, entity, entityMetadata);
            return null;
        }
        return saveNode.getEntityMetadata();
    }
}

