/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.proxy.extension.functions;

import com.easy.query.core.context.QueryRuntimeContext;
import com.easy.query.core.func.SQLFunc;
import com.easy.query.core.func.SQLFunction;
import com.easy.query.core.proxy.PropTypeColumn;
import com.easy.query.core.proxy.SQLSelectAsExpression;
import com.easy.query.core.proxy.extension.functions.ColumnObjectFunctionAvailable;
import com.easy.query.core.proxy.extension.functions.cast.ColumnFunctionCastBooleanAvailable;
import com.easy.query.core.proxy.extension.functions.cast.ColumnFunctionCastDateTimeAvailable;
import com.easy.query.core.proxy.extension.functions.cast.ColumnFunctionCastNumberAvailable;
import com.easy.query.core.proxy.extension.functions.cast.ColumnFunctionCastStringAvailable;
import com.easy.query.core.proxy.extension.functions.type.AnyTypeExpression;
import com.easy.query.core.proxy.extension.functions.type.BooleanTypeExpression;
import com.easy.query.core.proxy.extension.functions.type.DateTimeTypeExpression;
import com.easy.query.core.proxy.extension.functions.type.JSONObjectTypeExpression;
import com.easy.query.core.proxy.extension.functions.type.NumberTypeExpression;
import com.easy.query.core.proxy.extension.functions.type.StringTypeExpression;
import com.easy.query.core.proxy.extension.functions.type.impl.AnyTypeExpressionImpl;
import com.easy.query.core.proxy.extension.functions.type.impl.JSONObjectTypeExpressionImpl;
import com.easy.query.core.proxy.impl.SQLPredicateImpl;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.function.Function;

public interface ColumnJSONObjectFunctionAvailable<TProperty>
extends ColumnObjectFunctionAvailable<TProperty, AnyTypeExpression<TProperty>>,
SQLSelectAsExpression,
PropTypeColumn<TProperty>,
ColumnFunctionCastStringAvailable<TProperty>,
ColumnFunctionCastBooleanAvailable<TProperty>,
ColumnFunctionCastNumberAvailable<TProperty>,
ColumnFunctionCastDateTimeAvailable<TProperty> {
    @Override
    default public AnyTypeExpression<TProperty> createChainExpression(Function<SQLFunc, SQLFunction> func, Class<?> propType) {
        return new AnyTypeExpressionImpl(this.getCurrentEntitySQLContext(), this.getTable(), this.getValue(), func, propType);
    }

    default public AnyTypeExpression<Object> getField(String jsonKey) {
        String key = ColumnJSONObjectFunctionAvailable.getJsonKey(this.getEntitySQLContext().getRuntimeContext(), jsonKey);
        return new AnyTypeExpressionImpl<Object>(this.getCurrentEntitySQLContext(), this.getTable(), this.getValue(), fx -> fx.jsonObjectField(s -> {
            PropTypeColumn.acceptAnyValue(s, this);
            s.format((Object)key);
        }), Object.class);
    }

    default public JSONObjectTypeExpression<Object> getJsonObject(String jsonKey) {
        String key = ColumnJSONObjectFunctionAvailable.getJsonKey(this.getEntitySQLContext().getRuntimeContext(), jsonKey);
        return new JSONObjectTypeExpressionImpl<Object>(this.getCurrentEntitySQLContext(), this.getTable(), this.getValue(), fx -> fx.jsonObjectExtract(s -> {
            PropTypeColumn.acceptAnyValue(s, this);
            s.format((Object)key);
        }), Object.class);
    }

    default public StringTypeExpression<String> getString(String jsonKey) {
        return this.getField(jsonKey).asStr();
    }

    default public BooleanTypeExpression<Boolean> getBoolean(String jsonKey) {
        return this.getJsonObject(jsonKey).toBoolean();
    }

    default public DateTimeTypeExpression<LocalDateTime> getLocalDateTime(String jsonKey) {
        return this.getField(jsonKey).toDateTime(LocalDateTime.class);
    }

    default public DateTimeTypeExpression<LocalDate> getLocalDate(String jsonKey) {
        return this.getField(jsonKey).toDateTime(LocalDate.class);
    }

    default public NumberTypeExpression<Integer> getInteger(String jsonKey) {
        return this.getJsonObject(jsonKey).toNumber(Integer.class);
    }

    default public NumberTypeExpression<Long> getLong(String jsonKey) {
        return this.getJsonObject(jsonKey).toNumber(Long.class);
    }

    default public NumberTypeExpression<BigDecimal> getBigDecimal(String jsonKey) {
        return this.getJsonObject(jsonKey).toNumber(BigDecimal.class);
    }

    default public void containsKey(String jsonKey) {
        String key = ColumnJSONObjectFunctionAvailable.getJsonKey(this.getEntitySQLContext().getRuntimeContext(), jsonKey);
        this.getCurrentEntitySQLContext().accept(new SQLPredicateImpl(f -> {
            SQLFunc fx = f.getRuntimeContext().fx();
            SQLFunction sqlFunction = fx.jsonObjectContainsKey(s -> {
                PropTypeColumn.acceptAnyValue(s, this);
                s.format((Object)key);
            });
            f.sqlFunctionExecute(this.getTable(), sqlFunction);
        }));
    }

    public static String getJsonKey(QueryRuntimeContext runtimeContext, String jsonKey) {
        return runtimeContext.getMapColumnNameChecker().checkColumnName(jsonKey);
    }
}

