/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.api.proxy.entity.save;

import com.easy.query.api.proxy.entity.save.MemoryAddressCompareValue;
import com.easy.query.api.proxy.entity.save.SaveNodeTypeEnum;
import com.easy.query.core.exception.EasyQueryInvalidOperationException;
import com.easy.query.core.metadata.EntityMetadata;
import com.easy.query.core.util.EasyClassUtil;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

public class SaveNode {
    private final Map<MemoryAddressCompareValue, EntitySaveSate> entityItems;
    private final List<Object> deleteBys;
    private final int index;
    private final EntityMetadata entityMetadata;

    public SaveNode(int index, EntityMetadata entityMetadata) {
        this.index = index;
        this.entityMetadata = entityMetadata;
        this.deleteBys = new ArrayList<Object>();
        this.entityItems = new LinkedHashMap<MemoryAddressCompareValue, EntitySaveSate>();
    }

    public int getIndex() {
        return this.index;
    }

    public EntityMetadata getEntityMetadata() {
        return this.entityMetadata;
    }

    public Map<MemoryAddressCompareValue, EntitySaveSate> getEntityItems() {
        return this.entityItems;
    }

    public void putDeleteItem(MemoryAddressCompareValue valueObject) {
        EntitySaveSate entitySaveSate = this.entityItems.computeIfAbsent(valueObject, key -> new EntitySaveSate());
        if (entitySaveSate.getType() == SaveNodeTypeEnum.INIT) {
            entitySaveSate.setAggregateRoot(null);
            entitySaveSate.setConsumer(null);
            entitySaveSate.setType(SaveNodeTypeEnum.DELETE);
        } else if (entitySaveSate.getType() == SaveNodeTypeEnum.INSERT) {
            entitySaveSate.setType(SaveNodeTypeEnum.CHANGE);
        } else {
            throw new EasyQueryInvalidOperationException("The current object:[" + EasyClassUtil.getInstanceSimpleName((Object)valueObject.getEntity()) + "] has a conflicting save state and cannot be changed from [" + this.getEntitySaveStateAggregateRootDisplayName(entitySaveSate) + "." + (Object)((Object)entitySaveSate.getType()) + "] to [" + (Object)((Object)SaveNodeTypeEnum.DELETE) + "].");
        }
    }

    public void putInsertItem(MemoryAddressCompareValue valueObject, Object aggregateRoot, Consumer<Object> consumer) {
        EntitySaveSate entitySaveSate = this.entityItems.computeIfAbsent(valueObject, key -> new EntitySaveSate());
        if (entitySaveSate.getType() == SaveNodeTypeEnum.INIT) {
            entitySaveSate.setAggregateRoot(aggregateRoot);
            entitySaveSate.setConsumer(consumer);
            entitySaveSate.setType(SaveNodeTypeEnum.INSERT);
        } else if (entitySaveSate.getType() == SaveNodeTypeEnum.DELETE) {
            entitySaveSate.setAggregateRoot(aggregateRoot);
            entitySaveSate.setConsumer(consumer);
            entitySaveSate.setType(SaveNodeTypeEnum.CHANGE);
        } else {
            throw new EasyQueryInvalidOperationException("The current object:[" + EasyClassUtil.getInstanceSimpleName((Object)valueObject.getEntity()) + "] has a conflicting save state and cannot be changed from [" + this.getEntitySaveStateAggregateRootDisplayName(entitySaveSate) + "." + (Object)((Object)entitySaveSate.getType()) + "] to [" + EasyClassUtil.getInstanceSimpleName((Object)aggregateRoot) + "." + (Object)((Object)SaveNodeTypeEnum.INSERT) + "].");
        }
    }

    public void putUpdateItem(MemoryAddressCompareValue valueObject, Object aggregateRoot, Consumer<Object> consumer) {
        EntitySaveSate entitySaveSate = this.entityItems.computeIfAbsent(valueObject, key -> new EntitySaveSate());
        if (entitySaveSate.getType() != SaveNodeTypeEnum.INIT) {
            throw new EasyQueryInvalidOperationException("The current object:[" + EasyClassUtil.getInstanceSimpleName((Object)valueObject.getEntity()) + "] has a conflicting save state and cannot be changed from [" + this.getEntitySaveStateAggregateRootDisplayName(entitySaveSate) + "." + (Object)((Object)entitySaveSate.getType()) + "] to [" + EasyClassUtil.getInstanceSimpleName((Object)aggregateRoot) + "." + (Object)((Object)SaveNodeTypeEnum.UPDATE) + "].");
        }
        entitySaveSate.setAggregateRoot(aggregateRoot);
        entitySaveSate.setConsumer(consumer);
        entitySaveSate.setType(SaveNodeTypeEnum.UPDATE);
    }

    private String getEntitySaveStateAggregateRootDisplayName(EntitySaveSate entitySaveSate) {
        if (entitySaveSate.getAggregateRoot() == null) {
            return "-";
        }
        return EasyClassUtil.getInstanceSimpleName((Object)entitySaveSate.getAggregateRoot());
    }

    public void putIgnoreUpdateItem(MemoryAddressCompareValue valueObject, Object aggregateRoot, Consumer<Object> consumer) {
        EntitySaveSate entitySaveSate = this.entityItems.computeIfAbsent(valueObject, key -> new EntitySaveSate());
        if (entitySaveSate.getType() != SaveNodeTypeEnum.INIT) {
            throw new EasyQueryInvalidOperationException("The current object:[" + EasyClassUtil.getInstanceSimpleName((Object)valueObject.getEntity()) + "] has a conflicting save state and cannot be changed from [" + this.getEntitySaveStateAggregateRootDisplayName(entitySaveSate) + "." + (Object)((Object)entitySaveSate.getType()) + "] to [" + EasyClassUtil.getInstanceSimpleName((Object)aggregateRoot) + "." + (Object)((Object)SaveNodeTypeEnum.UPDATE_IGNORE) + "].");
        }
        entitySaveSate.setAggregateRoot(aggregateRoot);
        entitySaveSate.setConsumer(consumer);
        entitySaveSate.setType(SaveNodeTypeEnum.UPDATE_IGNORE);
    }

    public List<Object> getDeleteBys() {
        return this.deleteBys;
    }

    public static class EntitySaveSate {
        private Object aggregateRoot;
        private Consumer<Object> consumer;
        private SaveNodeTypeEnum type = SaveNodeTypeEnum.INIT;

        public Object getAggregateRoot() {
            return this.aggregateRoot;
        }

        public void setAggregateRoot(Object aggregateRoot) {
            this.aggregateRoot = aggregateRoot;
        }

        public Consumer<Object> getConsumer() {
            return this.consumer;
        }

        public void executeBefore(Object entity) {
            if (this.consumer != null) {
                this.consumer.accept(entity);
            }
        }

        public void setConsumer(Consumer<Object> consumer) {
            this.consumer = consumer;
        }

        public SaveNodeTypeEnum getType() {
            return this.type;
        }

        public void setType(SaveNodeTypeEnum type) {
            this.type = type;
        }
    }
}

