/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.api.proxy.entity.save.provider;

import com.easy.query.api.proxy.entity.save.MemoryAddressCompareValue;
import com.easy.query.api.proxy.entity.save.OwnershipPolicyEnum;
import com.easy.query.api.proxy.entity.save.SavableContext;
import com.easy.query.api.proxy.entity.save.SaveModeEnum;
import com.easy.query.api.proxy.entity.save.SaveNode;
import com.easy.query.api.proxy.entity.save.TargetValueTypeEnum;
import com.easy.query.api.proxy.entity.save.command.BasicSaveCommand;
import com.easy.query.api.proxy.entity.save.command.EmptySaveCommand;
import com.easy.query.api.proxy.entity.save.command.SaveCommand;
import com.easy.query.api.proxy.entity.save.provider.AbstractSaveProvider;
import com.easy.query.core.api.client.EasyQueryClient;
import com.easy.query.core.basic.extension.track.EntityState;
import com.easy.query.core.basic.extension.track.EntityValueState;
import com.easy.query.core.basic.extension.track.TrackContext;
import com.easy.query.core.enums.RelationTypeEnum;
import com.easy.query.core.enums.ValueTypeEnum;
import com.easy.query.core.exception.EasyQueryInvalidOperationException;
import com.easy.query.core.expression.lambda.Property;
import com.easy.query.core.metadata.ColumnMetadata;
import com.easy.query.core.metadata.EntityMetadata;
import com.easy.query.core.metadata.NavigateMetadata;
import com.easy.query.core.util.EasyArrayUtil;
import com.easy.query.core.util.EasyClassUtil;
import com.easy.query.core.util.EasyCollectionUtil;
import com.easy.query.core.util.EasyTrackUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class AutoTrackSaveProvider
extends AbstractSaveProvider {
    public AutoTrackSaveProvider(TrackContext currentTrackContext, Class<?> entityClass, List<Object> entities, EasyQueryClient easyQueryClient, List<Set<String>> savePathLimit, SaveModeEnum saveMode, OwnershipPolicyEnum ownershipPolicy) {
        super(currentTrackContext, entityClass, entities, easyQueryClient, savePathLimit, saveMode, ownershipPolicy);
    }

    @Override
    public SaveCommand createCommand() {
        if (EasyCollectionUtil.isNotEmpty((Collection)this.entities)) {
            EntityMetadata entityMetadata = this.entityMetadataManager.getEntityMetadata(this.entityClass);
            ArrayList<Object> inserts = new ArrayList<Object>();
            ArrayList<Object> updates = new ArrayList<Object>();
            for (Object entity : this.entities) {
                if (this.saveCommandContext.isProcessEntity(entity)) {
                    throw new EasyQueryInvalidOperationException("entity:" + entity + " has been added to the save command");
                }
                this.saveCommandContext.addProcessEntity(entity);
                EntityState trackEntityState = this.currentTrackContext.getTrackEntityState(entity);
                if (trackEntityState == null) {
                    inserts.add(entity);
                } else {
                    updates.add(entity);
                }
                this.saveEntity(entity, entityMetadata, 0);
            }
            return new BasicSaveCommand(entityMetadata, inserts, updates, this.easyQueryClient, this.saveCommandContext, this.saveMode);
        }
        return EmptySaveCommand.INSTANCE;
    }

    private void saveEntity(Object entity, EntityMetadata entityMetadata, int deep) {
        EntityState entityState = this.currentTrackContext.getTrackEntityState(entity);
        SavableContext savableContext = this.saveCommandContext.getCreateSavableContext(deep);
        Collection navigateMetadataList = entityState == null ? entityMetadata.getNavigateMetadatas() : entityState.getIncludes();
        List<NavigateMetadata> valueObjects = this.getNavigateSavableValueObjects(savableContext, entity, entityMetadata, navigateMetadataList, deep);
        for (NavigateMetadata navigateMetadata : valueObjects) {
            if (entityState == null) {
                this.valueObjectInsert(entity, entityMetadata, navigateMetadata, savableContext);
                continue;
            }
            Set trackKeys = entityState.getTrackKeys(navigateMetadata);
            this.valueObjectUpdate(entity, entityMetadata, navigateMetadata, savableContext, trackKeys == null ? new HashSet() : trackKeys);
        }
    }

    private void valueObjectInsert(Object entity, EntityMetadata selfEntityMetadata, NavigateMetadata navigateMetadata, SavableContext savableContext) {
        if (EasyArrayUtil.isNotEmpty((Object[])navigateMetadata.getDirectMapping())) {
            throw new EasyQueryInvalidOperationException("save not support direct mapping");
        }
        EntityMetadata targetEntityMetadata = this.entityMetadataManager.getEntityMetadata(navigateMetadata.getNavigatePropertyType());
        SaveNode saveNode = savableContext.getSaveNode(navigateMetadata);
        Property getter = navigateMetadata.getGetter();
        Object navigates = getter.apply(entity);
        if (navigates instanceof Collection) {
            for (Object targetEntity : (Collection)navigates) {
                this.valueObjectEntityInsert(entity, targetEntity, selfEntityMetadata, targetEntityMetadata, navigateMetadata, saveNode);
            }
        } else if (navigates != null) {
            this.valueObjectEntityInsert(entity, navigates, selfEntityMetadata, targetEntityMetadata, navigateMetadata, saveNode);
        }
    }

    private void valueObjectEntityInsert(Object selfEntity, Object targetEntity, EntityMetadata selfEntityMetadata, EntityMetadata targetEntityMetadata, NavigateMetadata navigateMetadata, SaveNode saveNode) {
        this.saveNodeInsert(selfEntity, targetEntity, selfEntityMetadata, targetEntityMetadata, navigateMetadata, saveNode);
        if (navigateMetadata.getRelationType() != RelationTypeEnum.ManyToMany) {
            this.saveEntity(targetEntity, targetEntityMetadata, saveNode.getIndex() + 1);
        }
    }

    private void valueObjectUpdate(Object entity, EntityMetadata selfEntityMetadata, NavigateMetadata navigateMetadata, SavableContext savableContext, Set<String> trackKeys) {
        if (trackKeys != null) {
            if (EasyArrayUtil.isNotEmpty((Object[])navigateMetadata.getDirectMapping())) {
                throw new EasyQueryInvalidOperationException("save not support direct mapping");
            }
            EntityMetadata targetEntityMetadata = this.entityMetadataManager.getEntityMetadata(navigateMetadata.getNavigatePropertyType());
            SaveNode saveNode = savableContext.getSaveNode(navigateMetadata);
            if (saveNode == null) {
                throw new EasyQueryInvalidOperationException("entity:[" + EasyClassUtil.getSimpleName((Class)navigateMetadata.getEntityMetadata().getEntityClass()) + "." + EasyClassUtil.getSimpleName((Class)navigateMetadata.getNavigatePropertyType()) + "] save node is null");
            }
            LinkedHashMap<String, Object> dbEntityMap = new LinkedHashMap<String, Object>();
            for (String trackKey : trackKeys) {
                EntityState trackEntityState = this.currentTrackContext.getTrackEntityState(navigateMetadata.getNavigatePropertyType(), trackKey);
                Objects.requireNonNull(trackEntityState, "trackEntityState cant be null,trackKey:" + trackKey);
                dbEntityMap.put(trackKey, trackEntityState.getCurrentValue());
            }
            Property getter = navigateMetadata.getGetter();
            Object navigates = getter.apply(entity);
            if (navigates instanceof Collection) {
                for (Object targetEntity : (Collection)navigates) {
                    this.valueObjectEntityInsert(dbEntityMap, entity, targetEntity, selfEntityMetadata, targetEntityMetadata, navigateMetadata, saveNode);
                }
            } else if (navigates != null) {
                this.valueObjectEntityInsert(dbEntityMap, entity, navigates, selfEntityMetadata, targetEntityMetadata, navigateMetadata, saveNode);
            }
            for (Object value : dbEntityMap.values()) {
                this.saveNodeDelete(entity, value, selfEntityMetadata, targetEntityMetadata, navigateMetadata, saveNode);
            }
        }
    }

    private void valueObjectEntityInsert(Map<String, Object> dbEntityMap, Object selfEntity, Object targetEntity, EntityMetadata selfEntityMetadata, EntityMetadata targetEntityMetadata, NavigateMetadata navigateMetadata, SaveNode saveNode) {
        String newNavigateEntityKey = EasyTrackUtil.getTrackKey((EntityMetadata)targetEntityMetadata, (Object)targetEntity);
        if (newNavigateEntityKey == null || !dbEntityMap.containsKey(newNavigateEntityKey)) {
            this.saveNodeInsert(selfEntity, targetEntity, selfEntityMetadata, targetEntityMetadata, navigateMetadata, saveNode);
        } else {
            dbEntityMap.remove(newNavigateEntityKey);
            EntityState trackEntityState = this.currentTrackContext.getTrackEntityState(navigateMetadata.getNavigatePropertyType(), newNavigateEntityKey);
            Objects.requireNonNull(trackEntityState, "trackEntityState cant be null,trackKey:" + newNavigateEntityKey);
            if (targetEntity != trackEntityState.getCurrentValue()) {
                throw new EasyQueryInvalidOperationException("entity:" + targetEntity + " is not same with:" + trackEntityState.getCurrentValue());
            }
            this.saveNodeUpdate(trackEntityState, selfEntity, targetEntity, targetEntityMetadata, navigateMetadata, saveNode);
        }
        if (navigateMetadata.getRelationType() != RelationTypeEnum.ManyToMany) {
            this.saveEntity(targetEntity, targetEntityMetadata, saveNode.getIndex() + 1);
        }
    }

    private void saveNodeDelete(Object selfEntity, Object targetEntity, EntityMetadata selfEntityMetadata, EntityMetadata targetEntityMetadata, NavigateMetadata navigateMetadata, SaveNode saveNode) {
        if (navigateMetadata.getRelationType() == RelationTypeEnum.ManyToMany) {
            if (navigateMetadata.getMappingClass() == null) {
                throw new EasyQueryInvalidOperationException("entity:[" + EasyClassUtil.getSimpleName((Class)navigateMetadata.getEntityMetadata().getEntityClass()) + "]-[" + EasyClassUtil.getSimpleName((Class)navigateMetadata.getNavigatePropertyType()) + "] many to many relation must have mapping class");
            }
            if (navigateMetadata.getValueType() == ValueTypeEnum.AUTO_CHECK) {
                throw new EasyQueryInvalidOperationException("entity:[" + EasyClassUtil.getSimpleName((Class)navigateMetadata.getEntityMetadata().getEntityClass()) + "]-[" + EasyClassUtil.getSimpleName((Class)navigateMetadata.getNavigatePropertyType()) + "] many to many relation mapping class save mode is not set");
            }
            if (navigateMetadata.getValueType() == ValueTypeEnum.VALUE_OBJECT) {
                EntityMetadata mappingClassEntityMetadata = this.entityMetadataManager.getEntityMetadata(navigateMetadata.getMappingClass());
                Object mappingEntity = mappingClassEntityMetadata.getBeanConstructorCreator().get();
                this.setMappingEntity(selfEntity, targetEntity, mappingEntity, selfEntityMetadata, navigateMetadata, targetEntityMetadata, mappingClassEntityMetadata);
                saveNode.getDeleteBys().add(mappingEntity);
            }
        } else {
            saveNode.putDeleteItem(new MemoryAddressCompareValue(targetEntity));
        }
    }

    private void saveNodeUpdate(EntityState trackEntityState, Object selfEntity, Object targetEntity, EntityMetadata targetEntityMetadata, NavigateMetadata navigateMetadata, SaveNode saveNode) {
        if (navigateMetadata.getRelationType() == RelationTypeEnum.ManyToMany) {
            if (navigateMetadata.getMappingClass() == null) {
                throw new EasyQueryInvalidOperationException("entity:[" + EasyClassUtil.getSimpleName((Class)navigateMetadata.getEntityMetadata().getEntityClass()) + "]-[" + EasyClassUtil.getSimpleName((Class)navigateMetadata.getNavigatePropertyType()) + "] many to many relation must have mapping class");
            }
            if (navigateMetadata.getValueType() == ValueTypeEnum.AUTO_CHECK) {
                throw new EasyQueryInvalidOperationException("entity:[" + EasyClassUtil.getSimpleName((Class)navigateMetadata.getEntityMetadata().getEntityClass()) + "]-[" + EasyClassUtil.getSimpleName((Class)navigateMetadata.getNavigatePropertyType()) + "] many to many relation mapping class save mode is not set");
            }
            return;
        }
        boolean hasChanged = false;
        for (Map.Entry propColumn : targetEntityMetadata.getProperty2ColumnMap().entrySet()) {
            EntityValueState entityValueState = trackEntityState.getEntityValueState((ColumnMetadata)propColumn.getValue());
            if (!entityValueState.isChanged()) continue;
            hasChanged = true;
            break;
        }
        if (hasChanged) {
            saveNode.putUpdateItem(new MemoryAddressCompareValue(targetEntity), selfEntity, null);
        } else {
            saveNode.putIgnoreUpdateItem(new MemoryAddressCompareValue(targetEntity), selfEntity, null);
        }
    }

    private void saveNodeInsert(Object selfEntity, Object targetEntity, EntityMetadata selfEntityMetadata, EntityMetadata targetEntityMetadata, NavigateMetadata navigateMetadata, SaveNode saveNode) {
        if (navigateMetadata.getRelationType() == RelationTypeEnum.ManyToMany) {
            if (navigateMetadata.getMappingClass() == null) {
                throw new EasyQueryInvalidOperationException("entity:[" + EasyClassUtil.getSimpleName((Class)navigateMetadata.getEntityMetadata().getEntityClass()) + "]-[" + EasyClassUtil.getSimpleName((Class)navigateMetadata.getNavigatePropertyType()) + "] many to many relation must have mapping class");
            }
            if (navigateMetadata.getValueType() == ValueTypeEnum.AUTO_CHECK) {
                throw new EasyQueryInvalidOperationException("entity:[" + EasyClassUtil.getSimpleName((Class)navigateMetadata.getEntityMetadata().getEntityClass()) + "]-[" + EasyClassUtil.getSimpleName((Class)navigateMetadata.getNavigatePropertyType()) + "] many to many relation mapping class save mode not set");
            }
            if (navigateMetadata.getValueType() == ValueTypeEnum.VALUE_OBJECT) {
                EntityMetadata mappingClassEntityMetadata = this.entityMetadataManager.getEntityMetadata(navigateMetadata.getMappingClass());
                Object mappingEntity = mappingClassEntityMetadata.getBeanConstructorCreator().get();
                saveNode.putInsertItem(new MemoryAddressCompareValue(mappingEntity), selfEntity, t -> this.setMappingEntity(selfEntity, targetEntity, t, selfEntityMetadata, navigateMetadata, targetEntityMetadata, mappingClassEntityMetadata));
            }
        } else {
            saveNode.putInsertItem(new MemoryAddressCompareValue(targetEntity), selfEntity, t -> this.setTargetValue(TargetValueTypeEnum.VALUE_OBJECT, selfEntity, t, selfEntityMetadata, navigateMetadata, targetEntityMetadata));
        }
    }
}

