/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.proxy.configurer;

import com.easy.query.core.exception.EasyQueryInvalidOperationException;
import com.easy.query.core.expression.parser.core.available.TableAvailable;
import com.easy.query.core.expression.sql.builder.EntityExpressionBuilder;
import com.easy.query.core.expression.sql.builder.EntityTableExpressionBuilder;
import com.easy.query.core.proxy.ProxyEntity;
import com.easy.query.core.proxy.configurer.TableConfigurer;
import com.easy.query.core.proxy.core.EntitySQLContext;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;

public class DefaultTableConfigurer<TProxy extends ProxyEntity<TProxy, TEntity>, TEntity>
implements TableConfigurer<TProxy, TEntity> {
    private final EntitySQLContext entitySQLContext;
    private final TProxy tProxy;
    private final EntityTableExpressionBuilder tableExpressionBuilder;

    public DefaultTableConfigurer(EntitySQLContext entitySQLContext, TProxy tProxy) {
        this.entitySQLContext = entitySQLContext;
        this.tProxy = tProxy;
        this.tableExpressionBuilder = this.getTableExpressionBuilder();
        if (this.tableExpressionBuilder == null) {
            throw new EasyQueryInvalidOperationException("Table information not found in the expression context.");
        }
    }

    private EntityTableExpressionBuilder getTableExpressionBuilder() {
        TableAvailable table = this.tProxy.getTable();
        EntityExpressionBuilder entityExpressionBuilder = this.entitySQLContext.getEntityExpressionBuilder();
        List tables = entityExpressionBuilder.getTables();
        for (EntityTableExpressionBuilder value : tables) {
            if (value.getEntityTable() != table) continue;
            return value;
        }
        Map relationTables = entityExpressionBuilder.getRelationTables();
        for (Map.Entry rtkv : relationTables.entrySet()) {
            EntityTableExpressionBuilder value = (EntityTableExpressionBuilder)rtkv.getValue();
            if (((EntityTableExpressionBuilder)rtkv.getValue()).getEntityTable() != table) continue;
            return value;
        }
        return null;
    }

    @Override
    public TableConfigurer<TProxy, TEntity> useLogicDelete(boolean use) {
        this.tableExpressionBuilder.setTableLogicDelete(() -> use);
        return this;
    }

    @Override
    public TableConfigurer<TProxy, TEntity> asTable(Function<String, String> tableNameAs) {
        this.tableExpressionBuilder.setTableNameAs(tableNameAs);
        return this;
    }

    @Override
    public TableConfigurer<TProxy, TEntity> asAlias(String alias) {
        this.tableExpressionBuilder.asAlias(alias);
        return this;
    }

    @Override
    public TableConfigurer<TProxy, TEntity> asTableSegment(BiFunction<String, String, String> segmentAs) {
        this.tableExpressionBuilder.setTableSegmentAs(segmentAs);
        return this;
    }
}

