/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.proxy.extension.functions;

import com.easy.query.core.expression.lambda.SQLFuncExpression2;
import com.easy.query.core.func.SQLFunc;
import com.easy.query.core.func.SQLFunction;
import com.easy.query.core.func.def.enums.MathMethodEnum;
import com.easy.query.core.func.def.enums.NumberCalcEnum;
import com.easy.query.core.proxy.PropTypeColumn;
import com.easy.query.core.proxy.core.Expression;
import com.easy.query.core.proxy.extension.functions.ColumnAggregateFilterFunctionAvailable;
import com.easy.query.core.proxy.extension.functions.ColumnObjectFunctionAvailable;
import com.easy.query.core.proxy.extension.functions.cast.ColumnFunctionCastBooleanAvailable;
import com.easy.query.core.proxy.extension.functions.cast.ColumnFunctionCastNumberAvailable;
import com.easy.query.core.proxy.extension.functions.cast.ColumnFunctionCastStringAvailable;
import com.easy.query.core.proxy.extension.functions.type.NumberTypeExpression;
import com.easy.query.core.proxy.extension.functions.type.filter.NumberFilterTypeExpression;
import com.easy.query.core.proxy.extension.functions.type.filter.impl.NumberFilterTypeExpressionImpl;
import com.easy.query.core.proxy.extension.functions.type.filter.impl.NumberSumFilterTypeExpressionImpl;
import com.easy.query.core.proxy.extension.functions.type.impl.NumberTypeExpressionImpl;
import java.math.BigDecimal;
import java.util.function.Function;

public interface ColumnNumberFunctionAvailable<TProperty>
extends ColumnObjectFunctionAvailable<TProperty, NumberTypeExpression<TProperty>>,
ColumnAggregateFilterFunctionAvailable<TProperty, NumberFilterTypeExpression<TProperty>>,
ColumnFunctionCastStringAvailable<TProperty>,
ColumnFunctionCastNumberAvailable<TProperty>,
ColumnFunctionCastBooleanAvailable<TProperty> {
    default public NumberFilterTypeExpression<TProperty> nullOrDefaultZero() {
        return this.createFilterChainExpression((self, fx) -> fx.nullOrDefault(x -> {
            PropTypeColumn.acceptAnyValue(x, self);
            x.format((Object)0);
        }), this.getPropertyType());
    }

    @Override
    default public NumberFilterTypeExpression<TProperty> max() {
        return this.createFilterChainExpression((self, fx) -> fx.max(x -> PropTypeColumn.acceptAnyValue(x, self)), this.getPropertyType());
    }

    @Override
    default public NumberFilterTypeExpression<TProperty> min() {
        return this.createFilterChainExpression((self, fx) -> fx.min(x -> PropTypeColumn.acceptAnyValue(x, self)), this.getPropertyType());
    }

    default public NumberFilterTypeExpression<BigDecimal> avg() {
        return this.avg(false);
    }

    default public NumberFilterTypeExpression<BigDecimal> avg(boolean distinct) {
        return new NumberFilterTypeExpressionImpl<BigDecimal>(this.getCurrentEntitySQLContext(), this, this.getTable(), this.getValue(), (self, fx) -> fx.avg(x -> PropTypeColumn.columnFuncSelector(x, self)).distinct(distinct), BigDecimal.class);
    }

    default public <T extends Number> NumberFilterTypeExpression<T> sum() {
        return this.sum(false);
    }

    default public <T extends Number> NumberFilterTypeExpression<T> sum(Class<T> resultClass) {
        return this.sum(false).asAnyType(resultClass);
    }

    default public NumberFilterTypeExpression<Integer> sumInt() {
        return this.sum(false).asAnyType(Integer.class);
    }

    default public NumberFilterTypeExpression<Integer> sumInt(boolean distinct) {
        return this.sum(distinct).asAnyType(Integer.class);
    }

    default public NumberFilterTypeExpression<Long> sumLong() {
        return this.sum(false).asAnyType(Long.class);
    }

    default public NumberFilterTypeExpression<Long> sumLong(boolean distinct) {
        return this.sum(distinct).asAnyType(Long.class);
    }

    default public <T extends Number> NumberFilterTypeExpression<T> sum(boolean distinct) {
        return new NumberSumFilterTypeExpressionImpl(this.getCurrentEntitySQLContext(), this, this.getTable(), this.getValue(), (self, fx) -> fx.sum(x -> PropTypeColumn.columnFuncSelector(x, self)).distinct(distinct), this.getPropertyType());
    }

    default public <T extends Number> NumberFilterTypeExpression<T> sum(boolean distinct, Class<T> resultClass) {
        return new NumberSumFilterTypeExpressionImpl(this.getCurrentEntitySQLContext(), this, this.getTable(), this.getValue(), (self, fx) -> fx.sum(x -> PropTypeColumn.columnFuncSelector(x, self)).distinct(distinct), this.getPropertyType()).asAnyType(resultClass);
    }

    default public NumberFilterTypeExpression<BigDecimal> sumBigDecimal() {
        return this.sum(false);
    }

    default public NumberFilterTypeExpression<BigDecimal> sumBigDecimal(boolean distinct) {
        return new NumberSumFilterTypeExpressionImpl<BigDecimal>(this.getCurrentEntitySQLContext(), this, this.getTable(), this.getValue(), (self, fx) -> fx.sum(x -> PropTypeColumn.columnFuncSelector(x, self)).distinct(distinct), BigDecimal.class);
    }

    default public NumberTypeExpression<TProperty> abs() {
        return new NumberTypeExpressionImpl(this.getCurrentEntitySQLContext(), this.getTable(), this.getValue(), fx -> fx.math(o -> PropTypeColumn.acceptAnyValue(o, this), MathMethodEnum.Abs), this.getPropertyType());
    }

    default public NumberTypeExpression<Integer> signum() {
        return new NumberTypeExpressionImpl<Integer>(this.getCurrentEntitySQLContext(), this.getTable(), this.getValue(), fx -> fx.math(o -> PropTypeColumn.acceptAnyValue(o, this), MathMethodEnum.Signum), Integer.class);
    }

    default public NumberTypeExpression<BigDecimal> floor() {
        return new NumberTypeExpressionImpl<BigDecimal>(this.getCurrentEntitySQLContext(), this.getTable(), this.getValue(), fx -> fx.math(o -> PropTypeColumn.acceptAnyValue(o, this), MathMethodEnum.Floor), BigDecimal.class);
    }

    default public NumberTypeExpression<BigDecimal> ceiling() {
        return new NumberTypeExpressionImpl<BigDecimal>(this.getCurrentEntitySQLContext(), this.getTable(), this.getValue(), fx -> fx.math(o -> PropTypeColumn.acceptAnyValue(o, this), MathMethodEnum.Ceiling), BigDecimal.class);
    }

    default public NumberTypeExpression<BigDecimal> round() {
        return new NumberTypeExpressionImpl<BigDecimal>(this.getCurrentEntitySQLContext(), this.getTable(), this.getValue(), fx -> fx.math(o -> PropTypeColumn.acceptAnyValue(o, this), MathMethodEnum.Round), BigDecimal.class);
    }

    default public NumberTypeExpression<BigDecimal> round(int decimals) {
        return new NumberTypeExpressionImpl<BigDecimal>(this.getCurrentEntitySQLContext(), this.getTable(), this.getValue(), fx -> fx.math(o -> {
            PropTypeColumn.acceptAnyValue(o, this);
            o.value((Object)decimals);
        }, MathMethodEnum.Round), BigDecimal.class);
    }

    default public NumberTypeExpression<BigDecimal> exp() {
        return new NumberTypeExpressionImpl<BigDecimal>(this.getCurrentEntitySQLContext(), this.getTable(), this.getValue(), fx -> fx.math(o -> PropTypeColumn.acceptAnyValue(o, this), MathMethodEnum.Exp), BigDecimal.class);
    }

    default public NumberTypeExpression<BigDecimal> log() {
        return new NumberTypeExpressionImpl<BigDecimal>(this.getCurrentEntitySQLContext(), this.getTable(), this.getValue(), fx -> fx.math(o -> PropTypeColumn.acceptAnyValue(o, this), MathMethodEnum.Log), BigDecimal.class);
    }

    default public NumberTypeExpression<BigDecimal> log10() {
        return new NumberTypeExpressionImpl<BigDecimal>(this.getCurrentEntitySQLContext(), this.getTable(), this.getValue(), fx -> fx.math(o -> PropTypeColumn.acceptAnyValue(o, this), MathMethodEnum.Log10), BigDecimal.class);
    }

    default public NumberTypeExpression<BigDecimal> pow(BigDecimal exponent) {
        return new NumberTypeExpressionImpl<BigDecimal>(this.getCurrentEntitySQLContext(), this.getTable(), this.getValue(), fx -> fx.math(o -> {
            PropTypeColumn.acceptAnyValue(o, this);
            o.value((Object)exponent);
        }, MathMethodEnum.Pow), BigDecimal.class);
    }

    default public NumberTypeExpression<BigDecimal> sqrt() {
        return new NumberTypeExpressionImpl<BigDecimal>(this.getCurrentEntitySQLContext(), this.getTable(), this.getValue(), fx -> fx.math(o -> PropTypeColumn.acceptAnyValue(o, this), MathMethodEnum.Sqrt), BigDecimal.class);
    }

    default public NumberTypeExpression<BigDecimal> cos() {
        return new NumberTypeExpressionImpl<BigDecimal>(this.getCurrentEntitySQLContext(), this.getTable(), this.getValue(), fx -> fx.math(o -> PropTypeColumn.acceptAnyValue(o, this), MathMethodEnum.Cos), BigDecimal.class);
    }

    default public NumberTypeExpression<BigDecimal> sin() {
        return new NumberTypeExpressionImpl<BigDecimal>(this.getCurrentEntitySQLContext(), this.getTable(), this.getValue(), fx -> fx.math(o -> PropTypeColumn.acceptAnyValue(o, this), MathMethodEnum.Sin), BigDecimal.class);
    }

    default public NumberTypeExpression<BigDecimal> tan() {
        return new NumberTypeExpressionImpl<BigDecimal>(this.getCurrentEntitySQLContext(), this.getTable(), this.getValue(), fx -> fx.math(o -> PropTypeColumn.acceptAnyValue(o, this), MathMethodEnum.Tan), BigDecimal.class);
    }

    default public NumberTypeExpression<BigDecimal> acos() {
        return new NumberTypeExpressionImpl<BigDecimal>(this.getCurrentEntitySQLContext(), this.getTable(), this.getValue(), fx -> fx.math(o -> PropTypeColumn.acceptAnyValue(o, this), MathMethodEnum.Acos), BigDecimal.class);
    }

    default public NumberTypeExpression<BigDecimal> asin() {
        return new NumberTypeExpressionImpl<BigDecimal>(this.getCurrentEntitySQLContext(), this.getTable(), this.getValue(), fx -> fx.math(o -> PropTypeColumn.acceptAnyValue(o, this), MathMethodEnum.Asin), BigDecimal.class);
    }

    default public NumberTypeExpression<BigDecimal> atan() {
        return new NumberTypeExpressionImpl<BigDecimal>(this.getCurrentEntitySQLContext(), this.getTable(), this.getValue(), fx -> fx.math(o -> PropTypeColumn.acceptAnyValue(o, this), MathMethodEnum.Atan), BigDecimal.class);
    }

    default public NumberTypeExpression<BigDecimal> atan2(BigDecimal other) {
        return this.atan2(Expression.of(this.getEntitySQLContext()).constant(other));
    }

    default public NumberTypeExpression<BigDecimal> atan2(PropTypeColumn<BigDecimal> other) {
        return new NumberTypeExpressionImpl<BigDecimal>(this.getCurrentEntitySQLContext(), this.getTable(), this.getValue(), fx -> fx.math(o -> {
            PropTypeColumn.acceptAnyValue(o, this);
            PropTypeColumn.acceptAnyValue(o, other);
        }, MathMethodEnum.Atan2), BigDecimal.class);
    }

    default public NumberTypeExpression<BigDecimal> truncate() {
        return new NumberTypeExpressionImpl<BigDecimal>(this.getCurrentEntitySQLContext(), this.getTable(), this.getValue(), fx -> fx.math(o -> PropTypeColumn.acceptAnyValue(o, this), MathMethodEnum.Truncate), BigDecimal.class);
    }

    default public <TOtherProperty extends Number> NumberTypeExpression<BigDecimal> add(PropTypeColumn<TOtherProperty> other) {
        return new NumberTypeExpressionImpl<BigDecimal>(this.getCurrentEntitySQLContext(), this.getTable(), this.getValue(), fx -> fx.numberCalc(o -> {
            PropTypeColumn.acceptAnyValue(o, this);
            PropTypeColumn.acceptAnyValue(o, other);
        }, NumberCalcEnum.NUMBER_ADD), this.getPropertyType());
    }

    default public <TOtherProperty extends Number> NumberTypeExpression<BigDecimal> add(TOtherProperty constant) {
        return this.add((TOtherProperty)((Object)Expression.of(this.getEntitySQLContext()).constant(constant)));
    }

    default public <TOtherProperty extends Number> NumberTypeExpression<BigDecimal> subtract(PropTypeColumn<TOtherProperty> other) {
        return new NumberTypeExpressionImpl<BigDecimal>(this.getCurrentEntitySQLContext(), this.getTable(), this.getValue(), fx -> fx.numberCalc(o -> {
            PropTypeColumn.acceptAnyValue(o, this);
            PropTypeColumn.acceptAnyValue(o, other);
        }, NumberCalcEnum.NUMBER_SUBTRACT), this.getPropertyType());
    }

    default public <TOtherProperty extends Number> NumberTypeExpression<BigDecimal> subtract(TOtherProperty constant) {
        return this.subtract((TOtherProperty)((Object)Expression.of(this.getEntitySQLContext()).constant(constant)));
    }

    default public <TOtherProperty extends Number> NumberTypeExpression<BigDecimal> multiply(PropTypeColumn<TOtherProperty> other) {
        return new NumberTypeExpressionImpl<BigDecimal>(this.getCurrentEntitySQLContext(), this.getTable(), this.getValue(), fx -> fx.numberCalc(o -> {
            PropTypeColumn.acceptAnyValue(o, this);
            PropTypeColumn.acceptAnyValue(o, other);
        }, NumberCalcEnum.NUMBER_MULTIPLY), this.getPropertyType());
    }

    default public <TOtherProperty extends Number> NumberTypeExpression<BigDecimal> multiply(TOtherProperty constant) {
        return this.multiply((TOtherProperty)((Object)Expression.of(this.getEntitySQLContext()).constant(constant)));
    }

    default public <TOtherProperty extends Number> NumberTypeExpression<BigDecimal> divide(PropTypeColumn<TOtherProperty> other) {
        return new NumberTypeExpressionImpl<BigDecimal>(this.getCurrentEntitySQLContext(), this.getTable(), this.getValue(), fx -> fx.numberCalc(o -> {
            PropTypeColumn.acceptAnyValue(o, this);
            PropTypeColumn.acceptAnyValue(o, other);
        }, NumberCalcEnum.NUMBER_DIVIDE), this.getPropertyType());
    }

    default public <TOtherProperty extends Number> NumberTypeExpression<BigDecimal> divide(TOtherProperty constant) {
        return this.divide((TOtherProperty)((Object)Expression.of(this.getEntitySQLContext()).constant(constant)));
    }

    @Override
    default public NumberTypeExpression<TProperty> createChainExpression(Function<SQLFunc, SQLFunction> func, Class<?> propType) {
        return new NumberTypeExpressionImpl(this.getCurrentEntitySQLContext(), this.getTable(), this.getValue(), func, propType);
    }

    @Override
    default public NumberFilterTypeExpression<TProperty> createFilterChainExpression(SQLFuncExpression2<PropTypeColumn<?>, SQLFunc, SQLFunction> func, Class<?> propType) {
        return new NumberFilterTypeExpressionImpl(this.getCurrentEntitySQLContext(), this, this.getTable(), this.getValue(), func, propType);
    }
}

