/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.processor;

import com.easy.query.core.annotation.ColumnIgnore;
import com.easy.query.core.annotation.EntityFileProxy;
import com.easy.query.core.annotation.EntityProxy;
import com.easy.query.core.annotation.Navigate;
import com.easy.query.core.annotation.ProxyProperty;
import com.easy.query.core.annotation.ValueObject;
import com.easy.query.core.enums.RelationTypeEnum;
import com.easy.query.core.util.EasyStringUtil;
import com.easy.query.processor.EasyQueryProxyProperties;
import com.easy.query.processor.templates.AptCreatorHelper;
import com.easy.query.processor.templates.AptFileCompiler;
import com.easy.query.processor.templates.AptPropertyInfo;
import com.easy.query.processor.templates.AptSelectPropertyInfo;
import com.easy.query.processor.templates.AptSelectorInfo;
import com.easy.query.processor.templates.AptValueObjectInfo;
import com.easy.query.processor.templates.PropertyColumn;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.JavaFileObject;

@SupportedAnnotationTypes(value={"com.easy.query.core.annotation.EntityProxy"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
public class ProxyGenerateProcessor
extends AbstractProcessor {
    private static final Map<String, String> TYPE_MAPPING = new HashMap<String, String>();
    private static final Map<String, PropertyColumn> TYPE_COLUMN_MAPPING = new HashMap<String, PropertyColumn>();
    private static final String FIELD_DOC_COMMENT_TEMPLATE = "\n    /**\n     * {@link @{entityClass}#get@{property}}\n     @{comment}\n     */";
    private static final String FIELD_EMPTY_DOC_COMMENT_TEMPLATE = "\n    /**\n     * {@link @{entityClass}#get@{property}}\n     */";
    private Filer filer;
    private Elements elementUtils;
    private Types typeUtils;

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.filer = processingEnv.getFiler();
        this.elementUtils = processingEnv.getElementUtils();
        this.typeUtils = processingEnv.getTypeUtils();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (!roundEnv.processingOver()) {
            EasyQueryProxyProperties props = new EasyQueryProxyProperties(this.filer);
            String enable = props.getProperties().getProperty("processor.enable", "");
            if ("false".equalsIgnoreCase(enable)) {
                return true;
            }
            String basePath = props.getProperties().getProperty("processor.basePath", "");
            AtomicReference entityClassNameReference = new AtomicReference();
            roundEnv.getElementsAnnotatedWith(EntityProxy.class).forEach(entityClassElement -> {
                EntityFileProxy entityFileProxy = entityClassElement.getAnnotation(EntityFileProxy.class);
                if (entityFileProxy != null) {
                    return;
                }
                EntityProxy entityProxy = entityClassElement.getAnnotation(EntityProxy.class);
                entityClassNameReference.set(entityClassElement.toString());
                String entityFullName = (String)entityClassNameReference.get();
                String realGenPackage = this.guessTablesPackage(entityFullName);
                String entityClassName = entityClassElement.getSimpleName().toString();
                String proxyInstanceName = EasyStringUtil.isBlank((String)entityProxy.value()) ? entityClassName + "Proxy" : entityProxy.value();
                HashSet<String> ignoreProperties = new HashSet<String>(Arrays.asList(entityProxy.ignoreProperties()));
                TypeElement classElement = (TypeElement)entityClassElement;
                AptFileCompiler aptFileCompiler = new AptFileCompiler(realGenPackage, entityClassName, proxyInstanceName, new AptSelectorInfo(proxyInstanceName + "Fetcher"));
                aptFileCompiler.addImports("com.easy.query.core.proxy.fetcher.AbstractFetcher");
                aptFileCompiler.addImports("com.easy.query.core.proxy.SQLSelectAsExpression");
                aptFileCompiler.addImports("com.easy.query.core.proxy.core.EntitySQLContext");
                AptValueObjectInfo aptValueObjectInfo = new AptValueObjectInfo(entityClassName);
                aptFileCompiler.addImports(entityFullName);
                do {
                    this.fillPropertyAndColumns(aptFileCompiler, aptValueObjectInfo, classElement, ignoreProperties);
                } while ((classElement = (TypeElement)this.typeUtils.asElement(classElement.getSuperclass())) != null);
                String content = this.buildTablesClass(aptFileCompiler, aptValueObjectInfo);
                this.genClass(basePath, realGenPackage, proxyInstanceName, content);
            });
        }
        return false;
    }

    public boolean isAbsolutePath(String path) {
        return path != null && (path.startsWith("/") || path.indexOf(":") > 0);
    }

    private String getProjectRootPath(String genFilePath) {
        File file = new File(genFilePath);
        int count = 20;
        return this.getProjectRootPath(file, count);
    }

    private String getProjectRootPath(File file, int count) {
        if (count <= 0) {
            return null;
        }
        if (file.isFile()) {
            return this.getProjectRootPath(file.getParentFile(), --count);
        }
        if (new File(file, "pom.xml").exists() && !new File(file.getParentFile(), "pom.xml").exists()) {
            return file.getAbsolutePath();
        }
        return this.getProjectRootPath(file.getParentFile(), --count);
    }

    private boolean isFromTestSource(String path) {
        return path.contains("test-sources") || path.contains("test-annotations");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void genClass(String basePath, String genPackageName, String className, String genContent) {
        Writer writer = null;
        try {
            String realPath;
            JavaFileObject sourceFile = this.filer.createSourceFile(genPackageName + "." + className, new Element[0]);
            if (basePath == null || basePath.trim().length() == 0) {
                writer = sourceFile.openWriter();
                writer.write(genContent);
                writer.flush();
                return;
            }
            String defaultGenPath = sourceFile.toUri().getPath();
            if (this.isAbsolutePath(basePath)) {
                realPath = basePath;
            } else {
                String projectRootPath = this.getProjectRootPath(defaultGenPath);
                realPath = new File(projectRootPath, basePath).getAbsolutePath();
            }
            boolean fromTestSource = this.isFromTestSource(defaultGenPath);
            realPath = fromTestSource ? new File(realPath, "src/test/java").getAbsolutePath() : new File(realPath, "src/main/java").getAbsolutePath();
            File genJavaFile = new File(realPath, (genPackageName + "." + className).replace(".", "/") + ".java");
            if (!genJavaFile.getParentFile().exists() && !genJavaFile.getParentFile().mkdirs()) {
                System.out.println(">>>>>ERROR: can not mkdirs by easy-query processor for: " + genJavaFile.getParentFile());
                return;
            }
            writer = new PrintWriter(new FileOutputStream(genJavaFile));
            writer.write(genContent);
            writer.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static String camelToUnderline(String string) {
        if (string == null || string.trim().length() == 0) {
            return "";
        }
        int len = string.length();
        StringBuilder sb = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            char c = string.charAt(i);
            if (Character.isUpperCase(c) && i > 0) {
                sb.append('_');
            }
            sb.append(Character.toLowerCase(c));
        }
        return sb.toString();
    }

    public static String firstCharToUpperCase(String string) {
        char firstChar = string.charAt(0);
        if (firstChar >= 'a' && firstChar <= 'z') {
            char[] arr = string.toCharArray();
            arr[0] = (char)(arr[0] - 32);
            return new String(arr);
        }
        return string;
    }

    public static String firstCharToLowerCase(String str) {
        char firstChar = str.charAt(0);
        if (firstChar >= 'A' && firstChar <= 'Z') {
            char[] arr = str.toCharArray();
            arr[0] = (char)(arr[0] + 32);
            return new String(arr);
        }
        return str;
    }

    private static String buildName(String name, String style) {
        if ("upperCase".equalsIgnoreCase(style)) {
            return ProxyGenerateProcessor.camelToUnderline(name).toUpperCase();
        }
        if ("lowerCase".equalsIgnoreCase(style)) {
            return ProxyGenerateProcessor.camelToUnderline(name).toLowerCase();
        }
        if ("upperCamelCase".equalsIgnoreCase(style)) {
            return ProxyGenerateProcessor.firstCharToUpperCase(name);
        }
        return ProxyGenerateProcessor.firstCharToLowerCase(name);
    }

    private String buildTablesClass(AptFileCompiler aptFileCompiler, AptValueObjectInfo aptValueObjectInfo) {
        return AptCreatorHelper.createProxy(aptFileCompiler, aptValueObjectInfo);
    }

    private String guessTablesPackage(String entityClassName) {
        StringBuilder guessPackage = new StringBuilder();
        if (!entityClassName.contains(".")) {
            guessPackage.append("proxy");
        } else {
            guessPackage.append(entityClassName, 0, entityClassName.lastIndexOf(".")).append(".proxy");
        }
        return guessPackage.toString();
    }

    private void fillValueObject(String parentProperty, AptValueObjectInfo aptValueObjectInfo, Element fieldClassElement, AptFileCompiler aptFileCompiler, Set<String> ignoreProperties) {
        String entityName = aptValueObjectInfo.getEntityName();
        List<? extends Element> enclosedElements = fieldClassElement.getEnclosedElements();
        for (Element element : enclosedElements) {
            ColumnIgnore column;
            Set<Modifier> modifiers;
            if (ElementKind.FIELD != element.getKind() || (modifiers = element.getModifiers()).contains((Object)Modifier.STATIC)) continue;
            String propertyName = element.toString();
            if (!ignoreProperties.isEmpty() && ignoreProperties.contains(parentProperty + "." + propertyName) || (column = element.getAnnotation(ColumnIgnore.class)) != null) continue;
            Navigate navigate = element.getAnnotation(Navigate.class);
            boolean includeProperty = navigate != null;
            boolean includeManyProperty = false;
            ProxyProperty proxyProperty = element.getAnnotation(ProxyProperty.class);
            String proxyPropertyName = proxyProperty != null ? proxyProperty.value() : propertyName;
            TypeMirror type = element.asType();
            boolean isGeneric = type.getKind() == TypeKind.TYPEVAR;
            boolean isDeclared = type.getKind() == TypeKind.DECLARED;
            String fieldGenericType = this.getGenericTypeString(isGeneric, isDeclared, includeProperty, type);
            String docComment = this.elementUtils.getDocComment(element);
            ValueObject valueObject = element.getAnnotation(ValueObject.class);
            boolean isValueObject = valueObject != null;
            String fieldName = isValueObject ? fieldGenericType.substring(fieldGenericType.lastIndexOf(".") + 1) : entityName;
            String fieldComment = this.getFiledComment(docComment, fieldName, propertyName);
            PropertyColumn propertyColumn = ProxyGenerateProcessor.getPropertyColumn(fieldGenericType);
            aptFileCompiler.addImports(propertyColumn.getImport());
            if (includeProperty) {
                aptFileCompiler.addImports("com.easy.query.core.proxy.columns.SQLNavigateColumn");
                String navigatePropertyProxyFullName = this.getNavigatePropertyProxyFullName(propertyColumn.getPropertyType(), navigate.propIsProxy());
                if (navigatePropertyProxyFullName != null) {
                    propertyColumn.setNavigateProxyName(navigatePropertyProxyFullName);
                } else {
                    fieldComment = fieldComment + "\n//apt\u63d0\u793a\u65e0\u6cd5\u83b7\u53d6\u5bfc\u822a\u5c5e\u6027\u4ee3\u7406:" + propertyColumn.getPropertyType();
                }
                if (navigate.value() == RelationTypeEnum.OneToMany || navigate.value() == RelationTypeEnum.ManyToMany) {
                    includeManyProperty = true;
                    aptFileCompiler.addImports("com.easy.query.core.proxy.columns.SQLQueryable");
                }
            }
            aptValueObjectInfo.addProperties(new AptPropertyInfo(propertyName, propertyColumn, fieldComment, fieldName, isValueObject, includeProperty, includeManyProperty, proxyPropertyName));
            if (valueObject == null) continue;
            aptFileCompiler.addImports(fieldGenericType);
            String valueObjectClassName = fieldGenericType.substring(fieldGenericType.lastIndexOf(".") + 1);
            Element fieldClass = ((DeclaredType)type).asElement();
            AptValueObjectInfo fieldAptValueObjectInfo = new AptValueObjectInfo(valueObjectClassName);
            aptValueObjectInfo.getChildren().add(fieldAptValueObjectInfo);
            this.fillValueObject(parentProperty + "." + propertyName, fieldAptValueObjectInfo, fieldClass, aptFileCompiler, ignoreProperties);
        }
    }

    private void fillPropertyAndColumns(AptFileCompiler aptFileCompiler, AptValueObjectInfo aptValueObjectInfo, TypeElement classElement, Set<String> ignoreProperties) {
        List<? extends Element> enclosedElements = classElement.getEnclosedElements();
        for (Element element : enclosedElements) {
            ColumnIgnore column;
            Set<Modifier> modifiers;
            if (ElementKind.FIELD != element.getKind() || (modifiers = element.getModifiers()).contains((Object)Modifier.STATIC)) continue;
            String propertyName = element.toString();
            if (!ignoreProperties.isEmpty() && ignoreProperties.contains(propertyName) || (column = element.getAnnotation(ColumnIgnore.class)) != null) continue;
            Navigate navigate = element.getAnnotation(Navigate.class);
            boolean includeProperty = navigate != null;
            boolean includeManyProperty = false;
            ProxyProperty proxyProperty = element.getAnnotation(ProxyProperty.class);
            String proxyPropertyName = proxyProperty != null ? proxyProperty.value() : propertyName;
            TypeMirror type = element.asType();
            boolean isGeneric = type.getKind() == TypeKind.TYPEVAR;
            boolean isDeclared = type.getKind() == TypeKind.DECLARED;
            String fieldGenericType = this.getGenericTypeString(isGeneric, isDeclared, includeProperty, type);
            String docComment = this.elementUtils.getDocComment(element);
            ValueObject valueObject = element.getAnnotation(ValueObject.class);
            boolean isValueObject = valueObject != null;
            String fieldName = isValueObject ? fieldGenericType.substring(fieldGenericType.lastIndexOf(".") + 1) : aptFileCompiler.getEntityClassName();
            String fieldComment = this.getFiledComment(docComment, fieldName, propertyName);
            PropertyColumn propertyColumn = ProxyGenerateProcessor.getPropertyColumn(fieldGenericType);
            aptFileCompiler.addImports(propertyColumn.getImport());
            if (!includeProperty) {
                aptFileCompiler.getSelectorInfo().addProperties(new AptSelectPropertyInfo(propertyName, fieldComment, proxyPropertyName));
            } else {
                aptFileCompiler.addImports("com.easy.query.core.proxy.columns.SQLNavigateColumn");
                String navigatePropertyProxyFullName = this.getNavigatePropertyProxyFullName(propertyColumn.getPropertyType(), navigate.propIsProxy());
                if (navigatePropertyProxyFullName != null) {
                    propertyColumn.setNavigateProxyName(navigatePropertyProxyFullName);
                } else {
                    fieldComment = fieldComment + "\n//apt\u63d0\u793a\u65e0\u6cd5\u83b7\u53d6\u5bfc\u822a\u5c5e\u6027\u4ee3\u7406:" + propertyColumn.getPropertyType();
                }
                if (navigate.value() == RelationTypeEnum.OneToMany || navigate.value() == RelationTypeEnum.ManyToMany) {
                    includeManyProperty = true;
                    aptFileCompiler.addImports("com.easy.query.core.proxy.columns.SQLQueryable");
                }
            }
            aptValueObjectInfo.addProperties(new AptPropertyInfo(propertyName, propertyColumn, fieldComment, fieldName, isValueObject, includeProperty, includeManyProperty, proxyPropertyName));
            if (valueObject == null) continue;
            aptFileCompiler.addImports("com.easy.query.core.proxy.AbstractValueObjectProxyEntity");
            aptFileCompiler.addImports(fieldGenericType);
            String valueObjectClassName = fieldGenericType.substring(fieldGenericType.lastIndexOf(".") + 1);
            Element fieldClass = ((DeclaredType)type).asElement();
            AptValueObjectInfo fieldAptValueObjectInfo = new AptValueObjectInfo(valueObjectClassName);
            aptValueObjectInfo.getChildren().add(fieldAptValueObjectInfo);
            this.fillValueObject(propertyName, fieldAptValueObjectInfo, fieldClass, aptFileCompiler, ignoreProperties);
        }
    }

    private String getNavigatePropertyProxyFullName(String fullClassName, boolean propIsProxy) {
        TypeElement typeElement = this.elementUtils.getTypeElement(fullClassName);
        if (typeElement != null) {
            EntityProxy annotation = typeElement.getAnnotation(EntityProxy.class);
            if (annotation != null) {
                if (EasyStringUtil.isBlank((String)annotation.value())) {
                    return this.getDefaultClassProxyName(fullClassName);
                }
                return fullClassName.substring(0, fullClassName.lastIndexOf(".")) + ".proxy." + annotation.value();
            }
            EntityFileProxy annotationFile = typeElement.getAnnotation(EntityFileProxy.class);
            if (annotationFile != null) {
                if (EasyStringUtil.isBlank((String)annotationFile.value())) {
                    return this.getDefaultClassProxyName(fullClassName);
                }
                return fullClassName.substring(0, fullClassName.lastIndexOf(".")) + ".proxy." + annotationFile.value();
            }
        }
        if (propIsProxy) {
            return this.getDefaultClassProxyName(fullClassName);
        }
        return null;
    }

    private String getDefaultClassProxyName(String fullClassName) {
        return fullClassName.substring(0, fullClassName.lastIndexOf(".")) + ".proxy." + fullClassName.substring(fullClassName.lastIndexOf(".") + 1) + "Proxy";
    }

    private String getFiledComment(String docComment, String className, String propertyName) {
        if (docComment == null) {
            return FIELD_EMPTY_DOC_COMMENT_TEMPLATE.replace("@{entityClass}", className).replace("@{property}", EasyStringUtil.toUpperCaseFirstOne((String)propertyName));
        }
        String[] commentLines = docComment.trim().split("\n");
        StringBuilder fieldComment = new StringBuilder();
        fieldComment.append("* ").append(commentLines[0]);
        for (int i = 1; i < commentLines.length; ++i) {
            fieldComment.append("\n     *").append(commentLines[i]);
        }
        return FIELD_DOC_COMMENT_TEMPLATE.replace("@{comment}", fieldComment.toString()).replace("@{entityClass}", className).replace("@{property}", EasyStringUtil.toUpperCaseFirstOne((String)propertyName));
    }

    private String getGenericTypeString(boolean isGeneric, boolean isDeclared, boolean includeProperty, TypeMirror type) {
        if (isGeneric) {
            return "java.lang.Object";
        }
        String typeString = this.defTypeString(isDeclared, includeProperty, type);
        if (typeString.contains("<") && typeString.contains(">")) {
            String trim = type.toString().trim();
            if (type.getAnnotationMirrors().size() > 0 && trim.lastIndexOf(") ::") > -1) {
                return type.toString().trim().substring(type.toString().trim().lastIndexOf(") ::") + 4).replaceAll(">\\)", ">");
            }
            return trim;
        }
        return TYPE_MAPPING.getOrDefault(typeString, typeString);
    }

    private String defTypeString(boolean isDeclared, boolean includeProperty, TypeMirror type) {
        if (includeProperty) {
            List<? extends TypeMirror> typeArguments;
            if (type instanceof DeclaredType && (typeArguments = ((DeclaredType)type).getTypeArguments()) != null && typeArguments.size() == 1) {
                return typeArguments.get(0).toString().trim();
            }
            String trim = type.toString().trim();
            return ProxyGenerateProcessor.parseGenericType(trim);
        }
        Element element = this.typeUtils.asElement(type);
        if (element != null) {
            return element.asType().toString().trim();
        }
        return type.toString().trim();
    }

    public static String parseGenericType(String genericTypeString) {
        if (genericTypeString.contains(",")) {
            return genericTypeString;
        }
        String regex = "<(.+?)>$";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(genericTypeString);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return genericTypeString;
    }

    public static PropertyColumn getPropertyColumn(String fieldGenericType) {
        return TYPE_COLUMN_MAPPING.getOrDefault(fieldGenericType, new PropertyColumn("SQLAnyColumn", fieldGenericType));
    }

    static {
        TYPE_MAPPING.put("float", "java.lang.Float");
        TYPE_MAPPING.put("double", "java.lang.Double");
        TYPE_MAPPING.put("short", "java.lang.Short");
        TYPE_MAPPING.put("int", "java.lang.Integer");
        TYPE_MAPPING.put("long", "java.lang.Long");
        TYPE_MAPPING.put("byte", "java.lang.Byte");
        TYPE_MAPPING.put("boolean", "java.lang.Boolean");
        TYPE_COLUMN_MAPPING.put("java.lang.Float", new PropertyColumn("SQLNumberColumn", "java.lang.Float"));
        TYPE_COLUMN_MAPPING.put("java.lang.Double", new PropertyColumn("SQLNumberColumn", "java.lang.Double"));
        TYPE_COLUMN_MAPPING.put("java.lang.Short", new PropertyColumn("SQLNumberColumn", "java.lang.Short"));
        TYPE_COLUMN_MAPPING.put("java.lang.Integer", new PropertyColumn("SQLNumberColumn", "java.lang.Integer"));
        TYPE_COLUMN_MAPPING.put("java.lang.Long", new PropertyColumn("SQLNumberColumn", "java.lang.Long"));
        TYPE_COLUMN_MAPPING.put("java.lang.Byte", new PropertyColumn("SQLNumberColumn", "java.lang.Byte"));
        TYPE_COLUMN_MAPPING.put("java.math.BigDecimal", new PropertyColumn("SQLNumberColumn", "java.math.BigDecimal"));
        TYPE_COLUMN_MAPPING.put("java.lang.Boolean", new PropertyColumn("SQLBooleanColumn", "java.lang.Boolean"));
        TYPE_COLUMN_MAPPING.put("java.lang.String", new PropertyColumn("SQLStringColumn", "java.lang.String"));
        TYPE_COLUMN_MAPPING.put("java.util.UUID", new PropertyColumn("SQLStringColumn", "java.util.UUID"));
        TYPE_COLUMN_MAPPING.put("java.sql.Timestamp", new PropertyColumn("SQLDateTimeColumn", "java.sql.Timestamp"));
        TYPE_COLUMN_MAPPING.put("java.sql.Time", new PropertyColumn("SQLDateTimeColumn", "java.sql.Time"));
        TYPE_COLUMN_MAPPING.put("java.sql.Date", new PropertyColumn("SQLDateTimeColumn", "java.sql.Date"));
        TYPE_COLUMN_MAPPING.put("java.util.Date", new PropertyColumn("SQLDateTimeColumn", "java.util.Date"));
        TYPE_COLUMN_MAPPING.put("java.time.LocalDate", new PropertyColumn("SQLDateTimeColumn", "java.time.LocalDate"));
        TYPE_COLUMN_MAPPING.put("java.time.LocalDateTime", new PropertyColumn("SQLDateTimeColumn", "java.time.LocalDateTime"));
        TYPE_COLUMN_MAPPING.put("java.time.LocalTime", new PropertyColumn("SQLDateTimeColumn", "java.time.LocalTime"));
    }
}

