/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.processor;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Properties;
import javax.annotation.processing.Filer;
import javax.tools.FileObject;
import javax.tools.StandardLocation;

public class EasyQueryProxyProperties {
    private static final String DEFAULT_ENCODING = "UTF-8";
    protected Properties properties = new Properties();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EasyQueryProxyProperties(Filer filer) {
        InputStream inputStream = null;
        try {
            FileObject propertiesFileObject = filer.getResource(StandardLocation.CLASS_OUTPUT, "", "easy-query-proxy.properties");
            File propertiesFile = new File(propertiesFileObject.toUri());
            if (propertiesFile.exists()) {
                inputStream = propertiesFileObject.openInputStream();
            } else if (this.getClass().getClassLoader().getResource("easy-query-proxy.properties") != null) {
                inputStream = this.getClass().getClassLoader().getResourceAsStream("easy-query-proxy.properties");
            } else {
                File pomXmlFile = new File(propertiesFile.getParentFile().getParentFile().getParentFile(), "pom.xml");
                if (pomXmlFile.exists()) {
                    propertiesFile = new File(pomXmlFile.getParentFile(), "src/main/resources/easy-query-proxy.properties");
                }
            }
            if (inputStream == null && propertiesFile.exists()) {
                inputStream = Files.newInputStream(propertiesFile.toPath(), new OpenOption[0]);
            }
            if (inputStream != null) {
                this.properties.load(new InputStreamReader(inputStream, DEFAULT_ENCODING));
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public Properties getProperties() {
        return this.properties;
    }
}

