/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.sqlite.func;

import com.easy.query.core.expression.parser.core.available.TableAvailable;
import com.easy.query.core.func.column.ColumnExpression;
import com.easy.query.core.func.def.AbstractExpressionSQLFunction;
import com.easy.query.core.func.def.enums.DateTimeUnitEnum;
import com.easy.query.core.util.EasyCollectionUtil;
import java.util.List;

public class SQLiteDateTimePropertySQLFunction
extends AbstractExpressionSQLFunction {
    private final List<ColumnExpression> columnExpressions;
    private final DateTimeUnitEnum dateTimeUnitEnum;

    public SQLiteDateTimePropertySQLFunction(List<ColumnExpression> columnExpressions, DateTimeUnitEnum dateTimeUnitEnum) {
        this.columnExpressions = columnExpressions;
        this.dateTimeUnitEnum = dateTimeUnitEnum;
    }

    public String sqlSegment(TableAvailable defaultTable) {
        if (EasyCollectionUtil.isEmpty(this.columnExpressions)) {
            throw new IllegalArgumentException("columnExpressions is empty");
        }
        switch (this.dateTimeUnitEnum) {
            case DayOfYear: {
                return "CAST(strftime('%j',{0}) AS INTEGER)";
            }
            case DayOfWeek: {
                return "CAST(strftime('%w',{0}) AS INTEGER)";
            }
            case DayOfWeekSunDayLastDay: {
                return "(CASE WHEN CAST(strftime('%w',{0}) AS INTEGER) = 0 THEN 7 ELSE CAST(strftime('%w',{0}) AS INTEGER) END)";
            }
            case Year: {
                return "CAST(strftime('%Y',{0}) AS INTEGER)";
            }
            case Month: {
                return "CAST(strftime('%m',{0}) AS INTEGER)";
            }
            case Day: {
                return "CAST(strftime('%d',{0}) AS INTEGER)";
            }
            case Hour: {
                return "CAST(strftime('%H',{0}) AS INTEGER)";
            }
            case Minute: {
                return "CAST(strftime('%M',{0}) AS INTEGER)";
            }
            case Second: {
                return "CAST(strftime('%S',{0}) AS INTEGER)";
            }
        }
        throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u5f53\u524d\u5c5e\u6027\u83b7\u53d6:" + this.dateTimeUnitEnum);
    }

    public int paramMarks() {
        return this.columnExpressions.size();
    }

    protected List<ColumnExpression> getColumnExpressions() {
        return this.columnExpressions;
    }
}

