/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.sqlite.migration;

import com.easy.query.core.configuration.dialect.SQLKeyword;
import com.easy.query.core.inject.ServiceProvider;
import com.easy.query.core.migration.AbstractDatabaseMigrationProvider;
import com.easy.query.core.migration.ColumnDbTypeResult;
import com.easy.query.core.migration.MigrationCommand;
import com.easy.query.core.migration.MigrationEntityParser;
import com.easy.query.core.migration.commands.DefaultMigrationCommand;
import com.easy.query.core.migration.data.ColumnMigrationData;
import com.easy.query.core.migration.data.ForeignKeyMigrationData;
import com.easy.query.core.migration.data.IndexMigrationData;
import com.easy.query.core.migration.data.TableMigrationData;
import com.easy.query.core.util.EasyCollectionUtil;
import com.easy.query.core.util.EasyDatabaseUtil;
import com.easy.query.core.util.EasyStringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import javax.sql.DataSource;

public class SQLiteDatabaseMigrationProvider
extends AbstractDatabaseMigrationProvider {
    private final ServiceProvider serviceProvider;

    public SQLiteDatabaseMigrationProvider(DataSource dataSource, SQLKeyword sqlKeyword, MigrationEntityParser migrationEntityParser, ServiceProvider serviceProvider) {
        super(dataSource, sqlKeyword, migrationEntityParser);
        this.serviceProvider = serviceProvider;
    }

    public String databaseExistSQL(String databaseName) {
        throw new UnsupportedOperationException("sqlite not support check database exists.");
    }

    public String createDatabaseSQL(String databaseName) {
        throw new UnsupportedOperationException("sqlite not support create database command.");
    }

    public String getDatabaseName() {
        return "main";
    }

    public boolean tableExists(String schema, String tableName) {
        ArrayList sqlParameters = new ArrayList();
        List maps = EasyDatabaseUtil.sqlQuery((DataSource)this.dataSource, (String)String.format("select 1 from %s.sqlite_master where type='table' and name='%s'", this.getDatabaseName(), tableName), sqlParameters);
        return EasyCollectionUtil.isNotEmpty((Collection)maps);
    }

    public MigrationCommand renameTable(TableMigrationData tableMigrationData) {
        String sql = "ALTER TABLE " + this.getQuoteSQLName(tableMigrationData.getSchema(), tableMigrationData.getOldTableName()) + " RENAME TO " + this.getQuoteSQLName(tableMigrationData.getSchema(), tableMigrationData.getTableName()) + ";";
        return new DefaultMigrationCommand(sql);
    }

    public MigrationCommand createTable(TableMigrationData tableMigrationData) {
        StringBuilder sql = new StringBuilder();
        sql.append("CREATE TABLE IF NOT EXISTS ").append(this.getQuoteSQLName(tableMigrationData.getSchema(), tableMigrationData.getTableName())).append(" ( ");
        for (ColumnMigrationData column : tableMigrationData.getColumns()) {
            sql.append(newLine).append(this.getQuoteSQLName(column.getName())).append(" ");
            ColumnDbTypeResult columnDbTypeResult = new ColumnDbTypeResult(column.getDbType(), column.getDefValue());
            sql.append(columnDbTypeResult.columnType);
            if (column.isNotNull()) {
                sql.append(" NOT NULL ");
            } else {
                sql.append(" NULL ");
            }
            if (column.isPrimary()) {
                sql.append(" PRIMARY KEY");
            }
            if (column.isGeneratedKey()) {
                sql.append(" AUTOINCREMENT");
            } else if (EasyStringUtil.isNotBlank((String)columnDbTypeResult.defValue)) {
                sql.append(" DEFAULT ").append(columnDbTypeResult.defValue);
            }
            sql.append(",");
        }
        List keys = EasyCollectionUtil.filter((List)tableMigrationData.getColumns(), s -> s.isPrimary());
        if (EasyCollectionUtil.isNotEmpty((Collection)keys)) {
            sql.append(" ").append(newLine).append(" PRIMARY KEY (");
            int i = keys.size();
            for (ColumnMigrationData keyColumn : keys) {
                sql.append(this.getQuoteSQLName(keyColumn.getName()));
                if (--i > 0) {
                    sql.append(", ");
                    continue;
                }
                sql.append(")");
            }
        } else {
            sql.deleteCharAt(sql.length() - 1);
        }
        List foreignKeys = tableMigrationData.getForeignKeys();
        if (EasyCollectionUtil.isNotEmpty((Collection)foreignKeys)) {
            for (ForeignKeyMigrationData foreignKeyMigrationData : foreignKeys) {
                String selfColumns = Arrays.stream(foreignKeyMigrationData.getSelfColumn()).map(self -> this.getQuoteSQLName((String)self)).collect(Collectors.joining(","));
                String targetColumns = Arrays.stream(foreignKeyMigrationData.getTargetColumn()).map(target -> this.getQuoteSQLName((String)target)).collect(Collectors.joining(","));
                sql.append(newLine).append(",");
                sql.append(" FOREIGN KEY (").append(selfColumns).append(") REFERENCES ").append(this.getQuoteSQLName(foreignKeyMigrationData.getTargetTable())).append("(").append(targetColumns).append(")");
                if (!EasyStringUtil.isNotBlank((String)foreignKeyMigrationData.getAction())) continue;
                sql.append(" ").append(foreignKeyMigrationData.getAction()).append(" ");
            }
        }
        sql.append(newLine).append(");");
        return new DefaultMigrationCommand(sql.toString());
    }

    protected MigrationCommand renameColumn(TableMigrationData table, String renameFrom, ColumnMigrationData column) {
        StringBuilder sql = new StringBuilder();
        sql.append("ALTER TABLE ").append(this.getQuoteSQLName(table.getSchema(), table.getTableName())).append(" RENAME COLUMN ").append(this.getQuoteSQLName(renameFrom)).append(" TO ").append(this.getQuoteSQLName(column.getName())).append(" ");
        ColumnDbTypeResult columnDbTypeResult = new ColumnDbTypeResult(column.getDbType(), column.getDefValue());
        sql.append(columnDbTypeResult.columnType);
        if (column.isNotNull()) {
            sql.append(" NOT NULL");
        } else {
            sql.append(" NULL");
        }
        sql.append(";");
        return new DefaultMigrationCommand(sql.toString());
    }

    protected MigrationCommand addColumn(TableMigrationData table, ColumnMigrationData column) {
        StringBuilder sql = new StringBuilder();
        sql.append("ALTER TABLE ").append(this.getQuoteSQLName(table.getSchema(), table.getTableName())).append(" ADD COLUMN ").append(this.getQuoteSQLName(column.getName())).append(" ");
        ColumnDbTypeResult columnDbTypeResult = new ColumnDbTypeResult(column.getDbType(), column.getDefValue());
        sql.append(columnDbTypeResult.columnType);
        if (column.isNotNull()) {
            sql.append(" NOT NULL");
        } else {
            sql.append(" NULL");
        }
        if (EasyStringUtil.isNotBlank((String)columnDbTypeResult.defValue)) {
            sql.append(" DEFAULT ").append(columnDbTypeResult.defValue);
        }
        sql.append(";");
        return new DefaultMigrationCommand(sql.toString());
    }

    public MigrationCommand dropTable(TableMigrationData table) {
        return new DefaultMigrationCommand("DROP TABLE " + this.getQuoteSQLName(table.getSchema(), table.getTableName()) + ";");
    }

    protected MigrationCommand createIndex(TableMigrationData table, IndexMigrationData tableIndex) {
        StringBuilder sql = new StringBuilder();
        sql.append("CREATE ");
        if (tableIndex.isUnique()) {
            sql.append("UNIQUE INDEX ");
        } else {
            sql.append("INDEX ");
        }
        sql.append(tableIndex.getIndexName());
        sql.append(" ON ").append(this.getQuoteSQLName(table.getSchema(), table.getTableName()));
        sql.append(" (");
        StringJoiner joiner = new StringJoiner(",");
        for (int i = 0; i < tableIndex.getFields().size(); ++i) {
            IndexMigrationData.EntityField entityField = (IndexMigrationData.EntityField)tableIndex.getFields().get(i);
            String column = this.getQuoteSQLName(entityField.getColumnName()) + " " + (entityField.isAsc() ? "ASC" : "DESC");
            joiner.add(column);
        }
        sql.append(joiner);
        sql.append(");");
        return new DefaultMigrationCommand(sql.toString());
    }

    protected MigrationCommand createTableForeignKey(TableMigrationData table, ForeignKeyMigrationData foreignKey) {
        return null;
    }
}

