/*
 * Decompiled with CFR 0.152.
 */
package com.ebay.taskgraph.context;

import com.ebay.taskgraph.context.ErrorHolder;
import com.ebay.taskgraph.context.ITrackingKey;
import com.ebay.taskgraph.context.TrackingKey;
import com.ebay.taskgraph.diagnostic.DiagnosticConfig;
import com.ebay.taskgraph.diagnostic.DiagnosticHolder;
import com.ebay.taskgraph.diagnostic.IDiagnosticHolder;
import com.ebay.taskgraph.diagnostic.IProfiler;
import com.ebay.taskgraph.diagnostic.Profiler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResponseContext {
    public static final ResponseContext NULL = new ResponseContext(new DiagnosticConfig(false, false, false), "NULL");
    private static final Logger LOGGER = LoggerFactory.getLogger(ResponseContext.class);
    private static final String STRING_LIST_TYPE = "STRING_LIST";
    private final IDiagnosticHolder diagnostic;
    private final IProfiler profiler;
    private final DiagnosticConfig diagnosticConfig;
    private final String name;
    private Map<ITrackingKey, Object> tracking;
    private ErrorHolder error;

    public ResponseContext() {
        this(DiagnosticConfig.NONE, "NULL");
    }

    public ResponseContext(DiagnosticConfig diagnosticConfig, String name) {
        this.diagnostic = DiagnosticHolder.getDiagnosticHolder(diagnosticConfig);
        this.diagnosticConfig = diagnosticConfig;
        this.name = name;
        this.profiler = Profiler.getProfiler(name, this.diagnosticConfig);
    }

    public IProfiler newProfiler(String name) {
        IProfiler profiler = Profiler.getProfiler(name, this.diagnosticConfig);
        profiler.start();
        return profiler;
    }

    public ResponseContext newContext(String name) {
        ResponseContext rc = new ResponseContext(this.diagnosticConfig, name);
        rc.getProfiler().start();
        return rc;
    }

    public ErrorHolder getError() {
        if (null == this.error) {
            this.error = new ErrorHolder();
        }
        return this.error;
    }

    public IDiagnosticHolder getDiagnostic() {
        return this.diagnostic;
    }

    public DiagnosticConfig getDiagnosticConfig() {
        return this.diagnosticConfig;
    }

    public void add(ResponseContext context) {
        if (this == context) {
            LOGGER.error("Adding response context to itself!");
        } else {
            if (context.error != null) {
                this.getError().add(context.error);
            }
            this.diagnostic.addDiagnostic(context.getDiagnostic());
            this.profiler.add(context.getProfiler());
            if (context.tracking != null) {
                for (Map.Entry<ITrackingKey, Object> entry : context.tracking.entrySet()) {
                    if (entry.getValue() instanceof List) {
                        for (Object trackingString : (List)entry.getValue()) {
                            this.addTracking(entry.getKey().getKey().toString(), trackingString.toString());
                        }
                        continue;
                    }
                    this.addTracking(entry.getKey(), entry.getValue());
                }
            }
        }
    }

    public IProfiler getProfiler() {
        return this.profiler;
    }

    @Deprecated
    public void addTracking(String key, String trackingString) {
        TrackingKey trackingKey;
        ArrayList<String> trackingList;
        if (null == this.tracking) {
            this.tracking = new HashMap<ITrackingKey, Object>();
        }
        if (null == (trackingList = (ArrayList<String>)this.tracking.get(trackingKey = new TrackingKey(STRING_LIST_TYPE, key)))) {
            trackingList = new ArrayList<String>();
            this.tracking.put(trackingKey, trackingList);
        }
        if (!trackingList.contains(trackingString)) {
            trackingList.add(trackingString);
        }
    }

    public void addTracking(ITrackingKey key, Object value) {
        if (null == this.tracking) {
            this.tracking = new HashMap<ITrackingKey, Object>();
        }
        if (this.tracking.containsKey(key)) {
            LOGGER.error("Trying to add tracking for existing key:" + key + ", new value:" + value + ", old value:" + this.tracking.get(key));
        } else {
            this.tracking.put(key, value);
        }
    }

    @Deprecated
    public List<String> getTracking(String trackingKey) {
        if (null == this.tracking) {
            return Collections.emptyList();
        }
        List trackingList = (List)this.tracking.get(new TrackingKey(STRING_LIST_TYPE, trackingKey));
        if (null == trackingList) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(trackingList);
    }

    public Map<String, List<String>> getTracking() {
        if (null == this.tracking) {
            return Collections.emptyMap();
        }
        HashMap<String, List> rval = new HashMap<String, List>();
        for (Map.Entry<ITrackingKey, Object> entry : this.tracking.entrySet()) {
            if (entry.getKey() == null || !STRING_LIST_TYPE.equals(entry.getKey().getType())) continue;
            List listValue = (List)entry.getValue();
            rval.put(entry.getKey().getKey().toString(), listValue);
        }
        return Collections.unmodifiableMap(rval);
    }

    public Map<ITrackingKey, Object> getTrackingByType(String type) {
        if (null == this.tracking) {
            return Collections.emptyMap();
        }
        HashMap<ITrackingKey, Object> rval = new HashMap<ITrackingKey, Object>();
        for (Map.Entry<ITrackingKey, Object> entry : this.tracking.entrySet()) {
            if (!entry.getKey().getType().equals(type)) continue;
            rval.put(entry.getKey(), entry.getValue());
        }
        return rval;
    }

    public String getName() {
        return this.name;
    }
}

