/*
 * Decompiled with CFR 0.152.
 */
package com.ebay.taskgraph.diagnostic;

import com.ebay.taskgraph.diagnostic.TaskData;
import com.ebay.taskgraph.util.JsonHelper;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.core.HttpHeaders;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiagnosticConfig {
    public static final String SHOWDIAG = "showdiag";
    public static final String SERVICEDOWNLOAD = "forceServiceDownload";
    public static final String PROFILE = "profile";
    public static final String TASKDIAG = "taskdiag";
    public static final String TASKMOCKS = "taskmocks";
    public static final DiagnosticConfig NONE;
    private static final long MAX_COUNT = 0x3FFFFFFFFFFFFFFFL;
    private static long COUNT;
    private static final Logger LOGGER;
    public final boolean showDiagnostics;
    public final boolean serviceDiagnostics;
    public final boolean profile;
    private final Set<String> taskDiagnostics;
    private final Map<String, Object> taskMocks;

    public DiagnosticConfig(HttpHeaders headers) {
        this(headers, 0.0);
    }

    public DiagnosticConfig(HttpHeaders headers, double profilePercentage) {
        this(DiagnosticConfig.isTrue(headers, SHOWDIAG), DiagnosticConfig.isTrue(headers, SERVICEDOWNLOAD), DiagnosticConfig.isTrue(headers, PROFILE) || DiagnosticConfig.doProfile(profilePercentage, COUNT), DiagnosticConfig.initializeTaskDiagnostics(DiagnosticConfig.getHeaderValue(headers, TASKDIAG)), DiagnosticConfig.initializeTaskData(DiagnosticConfig.getHeaderValue(headers, TASKMOCKS)));
    }

    public DiagnosticConfig(boolean showDiagnostics, boolean serviceDiagnostics, boolean profile) {
        this(showDiagnostics, serviceDiagnostics, profile, Collections.emptySet(), Collections.emptyMap());
        DiagnosticConfig.incrementCount();
    }

    public DiagnosticConfig(boolean showDiagnostics, boolean serviceDiagnostics, boolean profile, Set<String> taskDiagnostics, Map<String, Object> taskmocks) {
        this.showDiagnostics = showDiagnostics;
        this.serviceDiagnostics = serviceDiagnostics;
        this.profile = profile;
        this.taskDiagnostics = taskDiagnostics;
        this.taskMocks = taskmocks;
        DiagnosticConfig.incrementCount();
    }

    private static Set<String> initializeTaskDiagnostics(String headerValue) {
        Set<String> taskDiagnostics = Collections.emptySet();
        if (headerValue != null && !headerValue.isEmpty()) {
            String[] values;
            taskDiagnostics = new HashSet<String>();
            for (String val : values = headerValue.split(",")) {
                taskDiagnostics.add(val.trim());
            }
        }
        return taskDiagnostics;
    }

    private static Map<String, Object> initializeTaskData(String headerValue) {
        Map<String, Object> taskData = Collections.emptyMap();
        if (headerValue != null && !headerValue.isEmpty()) {
            taskData = new HashMap<String, Object>();
            List props = JsonHelper.readJsonStringAsList(headerValue);
            if (props != null) {
                for (Object prop : props) {
                    TaskData td = JsonHelper.convertValue(prop, TaskData.class);
                    taskData.put(td.getName(), td.getValue());
                }
            }
        }
        return taskData;
    }

    private static void incrementCount() {
        if (++COUNT > 0x3FFFFFFFFFFFFFFFL) {
            COUNT = 0L;
        }
    }

    private static boolean isTrue(HttpHeaders headers, String headerName) {
        String val = DiagnosticConfig.getHeaderValue(headers, headerName);
        return val != null && "1".equals(val);
    }

    private static String getHeaderValue(HttpHeaders headers, String headerName) {
        if (null == headers || null == headers.getRequestHeaders()) {
            return null;
        }
        List val = null;
        try {
            for (Map.Entry header : headers.getRequestHeaders().entrySet()) {
                if (!headerName.equalsIgnoreCase((String)header.getKey())) continue;
                val = (List)header.getValue();
                break;
            }
        }
        catch (IllegalStateException e) {
            LOGGER.error("Error accessing header", (Throwable)e);
        }
        return val != null && val.size() > 0 ? (String)val.get(0) : null;
    }

    static boolean doProfile(double profilePercentage, long count) {
        if (profilePercentage > 0.1) {
            profilePercentage = 0.1;
        }
        if (profilePercentage <= 0.0) {
            return false;
        }
        long profileMod = (long)(1.0 / profilePercentage);
        return 0L == count % profileMod;
    }

    public boolean publishDiagnostics() {
        return this.showDiagnostics || this.serviceDiagnostics || this.profile;
    }

    public boolean taskDiagnosticEnabled(String name) {
        return this.taskDiagnostics.contains(name);
    }

    public <T> T getTaskData(String name, T originalTaskResult) {
        Object data = this.taskMocks.get(name);
        Object taskData = originalTaskResult;
        if (data != null) {
            taskData = data instanceof String && "null".equals(data.toString()) ? null : (null == originalTaskResult ? data : (originalTaskResult.getClass().equals(data.getClass()) ? data : JsonHelper.convertValue(data, originalTaskResult.getClass())));
        }
        return taskData;
    }

    static {
        COUNT = 0L;
        LOGGER = LoggerFactory.getLogger(DiagnosticConfig.class);
        NONE = new DiagnosticConfig(false, false, false);
    }
}

