/*
 * Decompiled with CFR 0.152.
 */
package com.ebay.taskgraph.diagnostic;

import com.ebay.taskgraph.diagnostic.Diagnostic;
import com.ebay.taskgraph.diagnostic.DiagnosticConfig;
import com.ebay.taskgraph.diagnostic.DiagnosticHolderNull;
import com.ebay.taskgraph.diagnostic.IDiagnosticHolder;
import com.ebay.taskgraph.diagnostic.JsonDiagnostic;
import com.ebay.taskgraph.diagnostic.ServiceCallDiagnostic;
import com.ebay.taskgraph.diagnostic.ThrowableDiagnostic;
import com.ebay.taskgraph.service.IServiceInvoker;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.core.HttpHeaders;

public class DiagnosticHolder
implements IDiagnosticHolder {
    private final DiagnosticConfig config;
    private Map<String, Diagnostic> diagnostics = Collections.synchronizedMap(new HashMap());
    private List<ThrowableDiagnostic> throwables = new ArrayList<ThrowableDiagnostic>();
    private List<JsonDiagnostic> jsons = new ArrayList<JsonDiagnostic>();
    private List<ServiceCallDiagnostic<?, ?>> serviceCalls = new ArrayList();

    private DiagnosticHolder(DiagnosticConfig diagnosticConfig) {
        this.config = diagnosticConfig;
    }

    public static IDiagnosticHolder getDiagnosticHolder(DiagnosticConfig showDiagnostics) {
        if (showDiagnostics.showDiagnostics || showDiagnostics.serviceDiagnostics) {
            return new DiagnosticHolder(showDiagnostics);
        }
        return DiagnosticHolderNull.INSTANCE;
    }

    @Override
    public List<Diagnostic> getDiagnostics() {
        for (ThrowableDiagnostic throwableDiagnostic : this.throwables) {
            this.appendOrAddDiagnostic(throwableDiagnostic.getThrowableDiagnostic());
        }
        for (ServiceCallDiagnostic serviceCallDiagnostic : this.serviceCalls) {
            this.appendOrAddDiagnostic(serviceCallDiagnostic.getServiceCallDiagnostic(this.config.serviceDiagnostics));
        }
        while (!this.jsons.isEmpty()) {
            JsonDiagnostic jd = this.jsons.remove(this.jsons.size() - 1);
            this.appendOrAddDiagnostic(jd.getJsonDiagnostic());
        }
        return new ArrayList<Diagnostic>(this.diagnostics.values());
    }

    private void appendOrAddDiagnostic(Diagnostic diag) {
        Diagnostic existingDiag = this.diagnostics.get(diag.getSender());
        if (existingDiag != null) {
            existingDiag.getValue().addAll(diag.getValue());
        } else {
            this.diagnostics.put(diag.getSender(), diag);
        }
    }

    @Override
    public void addThrowableDiagnostic(String sender, Throwable t) {
        if (this.config.showDiagnostics && t != null) {
            this.throwables.add(new ThrowableDiagnostic(sender, t));
        }
    }

    @Override
    public void addJsonDiagnostic(String sender, String type, Object o) {
        if (this.config.showDiagnostics) {
            this.jsons.add(new JsonDiagnostic(sender, type, o));
        }
    }

    @Override
    public void addDiagnostic(String sender, String diagnostic) {
        if (this.config.showDiagnostics) {
            Diagnostic currentValue = this.getDiagnostic(sender);
            currentValue.getValue().add(diagnostic);
        }
    }

    @Override
    public void addDiagnostic(IDiagnosticHolder diagnosticHolder) {
        if (diagnosticHolder instanceof DiagnosticHolder) {
            DiagnosticHolder dh = (DiagnosticHolder)diagnosticHolder;
            Set<String> keySet = dh.diagnostics.keySet();
            if (keySet != null && !keySet.isEmpty()) {
                for (String key : keySet) {
                    List<String> values = dh.getDiagnostic(key).getValue();
                    if (values == null || values.isEmpty()) continue;
                    this.addDiagnostic(key, values);
                }
            }
            this.throwables.addAll(dh.throwables);
            this.jsons.addAll(dh.jsons);
            this.serviceCalls.addAll(dh.serviceCalls);
        } else {
            List<Diagnostic> diagnostics = diagnosticHolder.getDiagnostics();
            for (Diagnostic diag : diagnostics) {
                this.diagnostics.put(diag.getSender(), diag);
            }
        }
    }

    @Override
    public void addDiagnostic(String sender, List<String> diagnostic) {
        if (this.config.showDiagnostics) {
            Diagnostic currentValue = this.getDiagnostic(sender);
            if (diagnostic != null) {
                currentValue.getValue().addAll(diagnostic);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Diagnostic getDiagnostic(String sender) {
        Map<String, Diagnostic> map = this.diagnostics;
        synchronized (map) {
            Diagnostic currentValue = this.diagnostics.get(sender);
            if (null == currentValue) {
                currentValue = DiagnosticHolder.createDiagnostic(sender);
                this.diagnostics.put(sender, currentValue);
            }
            return currentValue;
        }
    }

    static Diagnostic createDiagnostic(String sender) {
        Diagnostic diag = new Diagnostic();
        diag.setSender(sender);
        diag.setValue(Collections.synchronizedList(new ArrayList()));
        return diag;
    }

    @Override
    public <T, V> void addServiceDiagnostic(String sender, IServiceInvoker<T, V> client, T request, V response, HttpHeaders headers) {
        this.serviceCalls.add(new ServiceCallDiagnostic<T, V>(sender, client, request, response, headers));
    }

    @Override
    public boolean enabled() {
        return this.config.showDiagnostics;
    }

    @Override
    public DiagnosticConfig getConfig() {
        return this.config;
    }
}

