/*
 * Decompiled with CFR 0.152.
 */
package com.ebay.taskgraph.diagnostic;

import com.ebay.taskgraph.diagnostic.Diagnostic;
import com.ebay.taskgraph.util.JsonHelper;
import java.util.ArrayList;

public class JsonDiagnostic {
    private final String sender;
    private final String type;
    private final Object object;

    public JsonDiagnostic(String sender, String type, Object o) {
        this.sender = sender;
        this.type = type;
        this.object = o;
    }

    public Diagnostic getJsonDiagnostic() {
        ArrayList<String> value = new ArrayList<String>();
        try {
            String diag = JsonHelper.writeAsString(this.object);
            value.add(this.type + ':' + diag);
        }
        catch (Throwable t) {
            String diag = this.object != null ? this.object.toString() : "null";
            value.add(this.type + ':' + diag);
            value.add(this.type + " JSON exception:" + t.getMessage());
        }
        Diagnostic diagnostic = new Diagnostic();
        diagnostic.setSender(this.sender);
        diagnostic.setValue(value);
        return diagnostic;
    }
}

