/*
 * Decompiled with CFR 0.152.
 */
package com.ebay.taskgraph.diagnostic;

import com.ebay.taskgraph.diagnostic.Diagnostic;
import com.ebay.taskgraph.diagnostic.DiagnosticConfig;
import com.ebay.taskgraph.diagnostic.IProfiler;
import com.ebay.taskgraph.diagnostic.IProfilerEntry;
import com.ebay.taskgraph.diagnostic.ProfilerModel;
import com.ebay.taskgraph.diagnostic.ProfilerNull;
import com.ebay.taskgraph.diagnostic.ProfilerProperty;
import com.ebay.taskgraph.util.JsonHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Profiler
implements IProfiler,
IProfilerEntry {
    public static final String PROFILER_DIAGNOSTIC_NAME = "Profiler";
    private static final Logger LOGGER = LoggerFactory.getLogger(Profiler.class);
    private final Entry entry;
    private final List<IProfilerEntry> entries = Collections.synchronizedList(new ArrayList());

    public Profiler(String name) {
        this.entry = new Entry(name);
    }

    @Override
    public void start() {
        this.entry.start();
    }

    @Override
    public void stop() {
        this.entry.stop();
    }

    @Override
    public void add(IProfilerEntry entry) {
        entry.stop();
    }

    @Override
    public void add(IProfiler profiler) {
        profiler.stop();
        if (profiler != ProfilerNull.INSTANCE) {
            this.entries.add(profiler);
        }
    }

    @Override
    public void addData(String name, String value) {
        this.entry.addData(name, value);
    }

    @Override
    public ProfilerModel getModel(long requestStart) {
        ProfilerModel pm = this.entry.getModel(requestStart);
        if (this.entries.size() > 0) {
            ArrayList<ProfilerModel> children = new ArrayList<ProfilerModel>(this.entries.size());
            for (IProfilerEntry e : this.entries) {
                ProfilerModel model = e.getModel(requestStart);
                children.add(model);
            }
            pm.setChildren(children);
        }
        return pm;
    }

    public static String getEntryName(String context, String name) {
        if (context != null && context.length() > 0) {
            name = Profiler.removeDuplicatePath(context, name);
            name = context + '.' + name;
        }
        return name;
    }

    private static String removeDuplicatePath(String context, String name) {
        int index;
        int finalIndex = 0;
        StringBuilder pre = new StringBuilder();
        String remainder = name;
        while ((index = remainder.indexOf(46)) > 0) {
            pre.append(remainder.substring(0, index));
            if (!context.contains(pre.toString())) break;
            pre.append('.');
            finalIndex += ++index;
            remainder = remainder.substring(index);
        }
        if (finalIndex > 0) {
            remainder = name.substring(finalIndex);
        }
        return remainder;
    }

    public static IProfiler getProfiler(String name, DiagnosticConfig diagnosticConfig) {
        if (diagnosticConfig.showDiagnostics || diagnosticConfig.profile) {
            return new Profiler(name);
        }
        return ProfilerNull.INSTANCE;
    }

    @Override
    public IProfilerEntry newEntry(String entryName) {
        Entry entry = new Entry(this.entry.name + '.' + entryName);
        entry.start();
        this.entries.add(entry);
        return entry;
    }

    @Override
    public void log() {
        this.stop();
        if (LOGGER.isDebugEnabled()) {
            HashMap<String, List<Entry>> entries = new HashMap<String, List<Entry>>();
            Profiler.validate(entries, this);
        }
    }

    private static void validate(Map<String, List<Entry>> entries, Profiler entry) {
        Profiler.validateEntry(entries, entry.entry);
        if (entry.entries.size() > 0) {
            for (IProfilerEntry e : entry.entries) {
                if (e instanceof Profiler) {
                    Profiler.validate(entries, (Profiler)e);
                    continue;
                }
                if (!(e instanceof Entry)) continue;
                Profiler.validateEntry(entries, (Entry)e);
            }
        }
    }

    private static void validateEntry(Map<String, List<Entry>> entries, Entry entry) {
        List<Entry> exists = entries.get(entry.name);
        if (exists != null) {
            for (int i = exists.size() - 1; i >= 0; --i) {
                if (exists.get(i) != entry) continue;
                throw new RuntimeException("duplicate profiler entry (possible cycle): " + entry.name);
            }
            exists.add(entry);
        } else {
            exists = new ArrayList<Entry>();
            exists.add(entry);
            entries.put(entry.name, exists);
        }
    }

    private Diagnostic getProfilerDiagnostic(long requestStart) {
        Diagnostic d = new Diagnostic();
        d.setSender(PROFILER_DIAGNOSTIC_NAME);
        ArrayList<String> value = new ArrayList<String>(1);
        try {
            value.add(JsonHelper.writeAsString(this.getModel(requestStart)));
        }
        catch (RuntimeException e) {
            value.add(e.getMessage());
        }
        d.setValue(value);
        return d;
    }

    @Override
    public List<Diagnostic> getDiagnostics() {
        ArrayList<Diagnostic> rval = new ArrayList<Diagnostic>(1);
        rval.add(this.getProfilerDiagnostic(this.entry.absoluteStartTime));
        return rval;
    }

    @Override
    public String getName() {
        return this.entry.name;
    }

    @Override
    public long getStartTime() {
        return this.entry.absoluteStartTime;
    }

    @Override
    public String getData(String name) {
        return this.entry.getData(name);
    }

    static class Entry
    implements IProfilerEntry {
        private long absoluteStartTime = -1L;
        private long duration = -1L;
        private final String name;
        private Map<String, String> data = new LinkedHashMap<String, String>();

        public Entry(String name) {
            this.name = name;
        }

        @Override
        public void start() {
            if (this.absoluteStartTime < 0L) {
                this.absoluteStartTime = System.nanoTime();
            }
        }

        @Override
        public void stop() {
            if (this.absoluteStartTime > 0L && this.duration < 0L) {
                this.duration = System.nanoTime() - this.absoluteStartTime;
            }
        }

        @Override
        public ProfilerModel getModel(long requestStart) {
            long startTime = this.absoluteStartTime;
            if (startTime > 0L) {
                startTime -= requestStart;
            }
            ProfilerModel pm = new ProfilerModel();
            pm.setName(this.name);
            pm.setStartTime(startTime);
            pm.setDuration(this.duration);
            if (!this.data.isEmpty()) {
                ArrayList<ProfilerProperty> properties = new ArrayList<ProfilerProperty>();
                for (Map.Entry<String, String> entry : this.data.entrySet()) {
                    ProfilerProperty property = new ProfilerProperty();
                    property.setName(entry.getKey());
                    property.setValue(entry.getValue());
                    properties.add(property);
                }
                pm.setData(properties);
            }
            return pm;
        }

        @Override
        public void addData(String name, String value) {
            this.data.put(name, value);
        }

        @Override
        public String getData(String name) {
            return this.data.get(name);
        }
    }
}

