/*
 * Decompiled with CFR 0.152.
 */
package com.ebay.taskgraph.diagnostic;

import com.ebay.taskgraph.diagnostic.Diagnostic;
import com.ebay.taskgraph.diagnostic.IProfiler;
import com.ebay.taskgraph.diagnostic.IProfilerEntry;
import com.ebay.taskgraph.diagnostic.ProfilerModel;
import com.ebay.taskgraph.diagnostic.ProfilerProperty;
import java.util.ArrayList;
import java.util.List;

public class ProfilerFromModel
implements IProfiler {
    private final ProfilerModel model;
    private long startTime;

    public ProfilerFromModel(ProfilerModel pm, IProfiler parent) {
        this.model = pm;
        this.startTime = parent.getStartTime();
        ProfilerFromModel.renameTask(pm, pm, parent.getName() + '.');
        ProfilerProperty prop = new ProfilerProperty();
        prop.setName("dependencies");
        prop.setValue(parent.getName());
        pm.getData().add(prop);
        prop = new ProfilerProperty();
        prop.setName("parent_task");
        prop.setValue(parent.getName());
        pm.getData().add(prop);
        this.renameThreads(pm, parent.getName(), parent.getData("task_thread"));
    }

    private void renameThreads(ProfilerModel pm, String parent, String parentThread) {
        if (pm.getData() != null) {
            ProfilerProperty parentProp = null;
            ProfilerProperty threadProp = null;
            for (ProfilerProperty prop : pm.getData()) {
                if ("task_thread".equals(prop.getName()) && prop.getValue() != null) {
                    threadProp = prop;
                }
                if (!"parent_task".equals(prop.getName()) || prop.getValue() == null) continue;
                parentProp = prop;
            }
            if (null == parentProp) {
                parentProp = new ProfilerProperty();
                parentProp.setName("parent_task");
                parentProp.setValue(parent);
                pm.getData().add(parentProp);
            }
            if (null == threadProp) {
                threadProp = new ProfilerProperty();
                threadProp.setName("task_thread");
                threadProp.setValue(parentThread);
                pm.getData().add(threadProp);
            } else {
                threadProp.setValue(parent + '.' + threadProp.getValue());
            }
        }
        if (pm.getChildren() != null) {
            for (ProfilerModel child : pm.getChildren()) {
                this.renameThreads(child, parent, parentThread);
            }
        }
    }

    private static void renameTask(ProfilerModel root, ProfilerModel pm, String prefix) {
        if (ProfilerFromModel.isTask(pm)) {
            String currentName = ProfilerFromModel.getTaskName(pm);
            String newName = prefix + currentName;
            ProfilerFromModel.updateTaskName(pm, currentName, newName);
            ProfilerFromModel.updateDependencies(root, currentName, newName);
        }
        if (pm.getChildren() != null) {
            for (ProfilerModel child : pm.getChildren()) {
                ProfilerFromModel.renameTask(root, child, prefix);
            }
        }
    }

    private static boolean isTask(ProfilerModel pm) {
        boolean rval = false;
        if (pm.getData() != null) {
            for (ProfilerProperty prop : pm.getData()) {
                if (!"execType".equals(prop.getName())) continue;
                rval = true;
                break;
            }
        }
        return rval;
    }

    private static void updateDependencies(ProfilerModel pm, String currentName, String newName) {
        if (pm.getData() != null) {
            for (ProfilerProperty prop : pm.getData()) {
                if ("dependencies".equals(prop.getName())) {
                    if (prop.getValue().equals(currentName)) {
                        prop.setValue(prop.getValue().replace(currentName, newName));
                    } else if (prop.getValue().endsWith(":" + currentName)) {
                        prop.setValue(prop.getValue().replace(":" + currentName, ":" + newName));
                    } else if (prop.getValue().startsWith(currentName + ":")) {
                        prop.setValue(prop.getValue().replace(currentName + ":", newName + ":"));
                    } else if (prop.getValue().contains(":" + currentName + ":")) {
                        prop.setValue(prop.getValue().replace(":" + currentName + ":", ":" + newName + ":"));
                    }
                }
                if (!"parent_task".equals(prop.getName()) || prop.getValue() == null || !prop.getValue().equals(currentName)) continue;
                prop.setValue(prop.getValue().replace(currentName, newName));
            }
        }
        if (pm.getChildren() != null) {
            for (ProfilerModel child : pm.getChildren()) {
                ProfilerFromModel.updateDependencies(child, currentName, newName);
            }
        }
    }

    private static void updateTaskName(ProfilerModel pm, String currentName, String newName) {
        ProfilerProperty prop;
        boolean updated = false;
        boolean hasNodeLabel = false;
        if (null == pm.getData()) {
            pm.setData(new ArrayList<ProfilerProperty>());
        }
        for (ProfilerProperty prop2 : pm.getData()) {
            if ("task_name".equals(prop2.getName())) {
                prop2.setValue(newName);
                updated = true;
            }
            if (!"node_label".equals(prop2.getName())) continue;
            hasNodeLabel = true;
        }
        if (!updated) {
            prop = new ProfilerProperty();
            prop.setName("task_name");
            prop.setValue(newName);
            pm.getData().add(prop);
        }
        if (!hasNodeLabel) {
            prop = new ProfilerProperty();
            prop.setName("node_label");
            prop.setValue(currentName);
            pm.getData().add(prop);
        }
    }

    private static String getTaskName(ProfilerModel pm) {
        String taskName = pm.getName();
        if (pm.getData() != null) {
            for (ProfilerProperty prop : pm.getData()) {
                if (!"task_name".equals(prop.getName())) continue;
                taskName = prop.getValue();
                break;
            }
        }
        return taskName;
    }

    @Override
    public ProfilerModel getModel(long requestStart) {
        if (this.startTime > 0L) {
            ProfilerFromModel.updateStartTimes(this.model, this.startTime - requestStart);
            this.startTime = -1L;
        }
        return this.model;
    }

    private static void updateStartTimes(ProfilerModel pm, long startTime) {
        pm.setStartTime(pm.getStartTime() + startTime);
        if (pm.getChildren() != null) {
            for (ProfilerModel child : pm.getChildren()) {
                ProfilerFromModel.updateStartTimes(child, startTime);
            }
        }
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    @Override
    public void addData(String name, String value) {
    }

    @Override
    public String getData(String name) {
        return null;
    }

    @Override
    public String getName() {
        return null;
    }

    @Override
    public void add(IProfiler profiler) {
    }

    @Override
    public void add(IProfilerEntry entry) {
    }

    @Override
    public IProfilerEntry newEntry(String string) {
        return null;
    }

    @Override
    public void log() {
    }

    @Override
    public List<Diagnostic> getDiagnostics() {
        return null;
    }

    @Override
    public long getStartTime() {
        return 0L;
    }
}

