/*
 * Decompiled with CFR 0.152.
 */
package com.ebay.taskgraph.diagnostic;

import com.ebay.taskgraph.diagnostic.IProfiler;
import com.ebay.taskgraph.diagnostic.ProfilerModel;
import com.ebay.taskgraph.diagnostic.ProfilerProperty;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ProfilerValidator {
    public static void validate(IProfiler profiler) {
        profiler.log();
        ProfilerValidator.validate(profiler.getModel(0L));
    }

    public static void validate(ProfilerModel profiler) {
        HashMap<String, Boolean> entries = new HashMap<String, Boolean>();
        ProfilerValidator.collectEntries(entries, profiler);
        ProfilerValidator.validateDependencies(entries, profiler);
    }

    private static void collectEntries(Map<String, Boolean> entries, ProfilerModel profiler) {
        String taskName = ProfilerValidator.getTaskName(profiler);
        if (taskName != null) {
            if (entries.containsKey(taskName)) {
                throw new RuntimeException("Duplicate task name: " + taskName);
            }
            entries.put(taskName, Boolean.TRUE);
        }
        if (profiler.getChildren() != null) {
            for (ProfilerModel child : profiler.getChildren()) {
                ProfilerValidator.collectEntries(entries, child);
            }
        }
    }

    private static String getTaskName(ProfilerModel profiler) {
        String taskName = null;
        boolean isTask = false;
        if (profiler.getData() != null) {
            for (ProfilerProperty prop : profiler.getData()) {
                if ("execType".equals(prop.getName())) {
                    isTask = true;
                }
                if (!"task_name".equals(prop.getName())) continue;
                taskName = prop.getValue();
            }
        }
        if (isTask && null == taskName) {
            taskName = profiler.getName();
        }
        return taskName;
    }

    private static void validateDependencies(Map<String, Boolean> entries, ProfilerModel entry) {
        ProfilerValidator.validateDependencies(entries, entry.getData());
        if (entry.getChildren() != null) {
            for (ProfilerModel child : entry.getChildren()) {
                ProfilerValidator.validateDependencies(entries, child);
            }
        }
    }

    private static void validateDependencies(Map<String, Boolean> entries, List<ProfilerProperty> props) {
        if (props != null) {
            for (ProfilerProperty prop : props) {
                String[] deps;
                String dependencies;
                if (!"dependencies".equals(prop.getName()) || (dependencies = prop.getValue()) == null) continue;
                for (String d : deps = dependencies.split(":")) {
                    if (entries.containsKey(d)) continue;
                    throw new RuntimeException("No profiler entry for dependency: " + d);
                }
            }
        }
    }
}

