/*
 * Decompiled with CFR 0.152.
 */
package com.ebay.taskgraph.diagnostic;

import com.ebay.taskgraph.diagnostic.Diagnostic;
import java.util.ArrayList;
import java.util.List;

class ThrowableDiagnostic {
    private final String sender;
    private final Throwable throwable;

    ThrowableDiagnostic(String sender, Throwable throwable) {
        this.sender = sender;
        this.throwable = throwable;
    }

    static List<String> getThrowableDiagnosticValue(Throwable t) {
        ArrayList<String> value = new ArrayList<String>();
        value.add(t.getMessage() != null ? t.getMessage() : t.getClass().getSimpleName());
        ThrowableDiagnostic.addStackTrace(value, t);
        int maxDepth = 10;
        while (t.getCause() != null && maxDepth-- > 0) {
            t = t.getCause();
            value.add("Caused by: " + t.getMessage());
            ThrowableDiagnostic.addStackTrace(value, t);
        }
        return value;
    }

    private static void addStackTrace(List<String> diagnostic, Throwable t) {
        for (StackTraceElement s : t.getStackTrace()) {
            diagnostic.add(s.toString());
        }
    }

    public Diagnostic getThrowableDiagnostic() {
        Diagnostic diagnostic = new Diagnostic();
        diagnostic.setSender(this.sender);
        List<String> value = ThrowableDiagnostic.getThrowableDiagnosticValue(this.throwable);
        diagnostic.setValue(value);
        return diagnostic;
    }
}

