/*
 * Decompiled with CFR 0.152.
 */
package com.ebay.taskgraph.executor;

import com.ebay.taskgraph.diagnostic.DiagnosticConfig;

public class CallableTaskConfig {
    public final DiagnosticConfig diagnosticConfig;
    public final long timeout;
    public final ExecType execType;

    public CallableTaskConfig(DiagnosticConfig diagnosticConfig, long timeout, ExecType execType) {
        this.diagnosticConfig = diagnosticConfig;
        this.timeout = timeout;
        this.execType = execType;
    }

    public CallableTaskConfig(DiagnosticConfig diagnosticConfig, long timeout) {
        this(diagnosticConfig, timeout, ExecType.ASYNC);
    }

    public CallableTaskConfig(DiagnosticConfig diagnosticConfig, ExecType execType) {
        this(diagnosticConfig, Long.MAX_VALUE, execType);
    }

    public static CallableTaskConfig synch(DiagnosticConfig diagnosticConfig) {
        return new CallableTaskConfig(diagnosticConfig, ExecType.SYNC);
    }

    public static CallableTaskConfig simple(DiagnosticConfig diagnosticConfig) {
        return new CallableTaskConfig(diagnosticConfig, ExecType.SIMPLE);
    }

    public static enum ExecType {
        SYNC,
        ASYNC,
        ASYNC_TIMEOUT,
        SIMPLE;

    }
}

