/*
 * Decompiled with CFR 0.152.
 */
package com.ebay.taskgraph.executor;

import com.ebay.taskgraph.executor.CallableTaskConfig;
import com.ebay.taskgraph.executor.CallableTimeoutDecorator;
import com.ebay.taskgraph.executor.ICallableTask;
import com.ebay.taskgraph.executor.ICallableTaskExecutor;
import com.ebay.taskgraph.executor.ProfileDecorator;
import com.ebay.taskgraph.executor.TaskThreadLoggingDecorator;
import com.ebay.taskgraph.executor.workflow.WorkflowException;

public class CallableTaskExecutorHelper {
    public static <T> ICallableTask<T> getDecoratedTask(ICallableTaskExecutor executor, ICallableTask<T> task) {
        if (executor.getTask(task.getName()) != null) {
            throw new WorkflowException("Attempted to add a duplicate key: " + task.getName());
        }
        task = CallableTaskConfig.ExecType.ASYNC_TIMEOUT.equals((Object)task.getTaskConfig().execType) ? new CallableTimeoutDecorator<T>(task, executor) : new ProfileDecorator<T>(task);
        if (task.getContext().getDiagnosticConfig().profile || task.getContext().getDiagnosticConfig().showDiagnostics) {
            task = new TaskThreadLoggingDecorator<T>(task);
        }
        return task;
    }

    public static boolean isAsync(ICallableTask<?> task) {
        return CallableTaskConfig.ExecType.ASYNC.equals((Object)task.getTaskConfig().execType) || CallableTaskConfig.ExecType.ASYNC_TIMEOUT.equals((Object)task.getTaskConfig().execType);
    }
}

