/*
 * Decompiled with CFR 0.152.
 */
package com.ebay.taskgraph.executor;

import com.ebay.taskgraph.executor.ApplicationException;
import com.ebay.taskgraph.executor.ICallableTask;
import com.ebay.taskgraph.executor.ICallableTaskFuture;
import com.ebay.taskgraph.executor.Task;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class CallableTaskFuture<RESULT>
implements ICallableTaskFuture<RESULT> {
    public static final TimeUnit TIMEOUT_UNIT = TimeUnit.MILLISECONDS;
    private final Future<RESULT> future;
    private final ICallableTask<RESULT> task;
    private volatile Result<RESULT> result = null;
    private volatile ApplicationException applicationException = null;

    public CallableTaskFuture(Future<RESULT> future, ICallableTask<RESULT> task) {
        this.future = future;
        this.task = task;
    }

    @Override
    public synchronized RESULT getNoThrow(ICallableTask<?> caller) {
        Task.addDependency(this.task, caller);
        if (this.applicationException != null) {
            throw this.applicationException;
        }
        if (null == this.result) {
            Object result = null;
            try {
                result = this.future.get(this.task.getTaskConfig().timeout, TIMEOUT_UNIT);
            }
            catch (TimeoutException e) {
                this.task.getContext().getProfiler().stop();
                this.logException(e);
            }
            catch (ExecutionException e) {
                this.logException(e.getCause());
            }
            catch (Throwable t) {
                this.logException(t);
            }
            if (this.task.getTaskConfig().diagnosticConfig.taskDiagnosticEnabled(this.task.getName())) {
                Task.addTaskResponseDiagnostic(this.task, result);
            }
            result = this.task.getTaskConfig().diagnosticConfig.getTaskData(this.task.getName(), result);
            this.result = new Result(result);
        }
        return this.result.result;
    }

    @Override
    public RESULT get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        throw new UnsupportedOperationException("use getNoThrow() so that task dependencies are tracked");
    }

    @Override
    public RESULT get() throws InterruptedException, ExecutionException {
        throw new UnsupportedOperationException("use getNoThrow() so that task dependencies are tracked");
    }

    private void logException(Throwable t) {
        if (t instanceof ApplicationException) {
            this.applicationException = (ApplicationException)t;
        }
        Task.logTaskException(this.task, t);
    }

    @Override
    public ICallableTask<RESULT> getTask() {
        return this.task;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return this.future.cancel(mayInterruptIfRunning);
    }

    @Override
    public boolean isCancelled() {
        return this.future.isCancelled();
    }

    @Override
    public boolean isDone() {
        return this.result != null || this.applicationException != null || this.future.isDone();
    }

    private static class Result<RESULT> {
        final RESULT result;

        private Result(RESULT result) {
            this.result = result;
        }
    }
}

