/*
 * Decompiled with CFR 0.152.
 */
package com.ebay.taskgraph.executor;

import com.ebay.taskgraph.context.ResponseContext;
import com.ebay.taskgraph.executor.CallableTaskConfig;
import com.ebay.taskgraph.executor.ICallableTask;
import com.ebay.taskgraph.executor.ICallableTaskExecutor;
import com.ebay.taskgraph.executor.ICallableTaskFuture;
import com.ebay.taskgraph.executor.ProfileDecorator;
import com.ebay.taskgraph.executor.Task;

public class CallableTimeoutDecorator<T>
implements ICallableTask<T> {
    public static final ICallableTaskFuture<?>[] NULL_DEPENDENCIES = new ICallableTaskFuture[0];
    private final ICallableTask<T> task;
    private final CallableTaskConfig taskConfig;
    private final ICallableTaskFuture<T> taskFuture;

    public CallableTimeoutDecorator(ICallableTask<T> task, ICallableTaskExecutor executor) {
        this.task = task;
        this.taskConfig = CallableTaskConfig.simple(task.getTaskConfig().diagnosticConfig);
        CallableTaskInvoker<T> invoker = new CallableTaskInvoker<T>(this.task);
        this.taskFuture = executor.addTask(invoker);
    }

    @Override
    public T call() {
        this.waitForDependencies();
        T rval = this.taskFuture.getNoThrow(this.task);
        return rval;
    }

    @Override
    public String getName() {
        return this.task.getName();
    }

    @Override
    public ResponseContext getContext() {
        return this.task.getContext();
    }

    @Override
    public CallableTaskConfig getTaskConfig() {
        return this.taskConfig;
    }

    @Override
    public void waitForDependencies() {
        this.task.waitForDependencies();
    }

    @Override
    public ICallableTaskFuture<?>[] getDependencies() {
        return this.task.getDependencies();
    }

    public static class CallableTaskInvoker<T>
    extends Task
    implements ICallableTask<T> {
        private static final String TASK_SUFFIX = "_timeoutTask";
        private final ICallableTask<T> task;

        public CallableTaskInvoker(ICallableTask<T> task) {
            super(task.getName() + TASK_SUFFIX, new ResponseContext(task.getTaskConfig().diagnosticConfig, task.getContext().getName() + TASK_SUFFIX), new CallableTaskConfig(task.getTaskConfig().diagnosticConfig, task.getTaskConfig().timeout), task.getDependencies());
            this.context.getProfiler().addData("node_label", "TimeoutTask");
            this.task = task;
        }

        @Override
        public T call() {
            return ProfileDecorator.profileTaskCall(this.task);
        }
    }
}

