/*
 * Decompiled with CFR 0.152.
 */
package com.ebay.taskgraph.executor;

import com.ebay.taskgraph.executor.CallableTaskExecutorHelper;
import com.ebay.taskgraph.executor.CallableTaskFuture;
import com.ebay.taskgraph.executor.ICallableTask;
import com.ebay.taskgraph.executor.ICallableTaskExecutor;
import com.ebay.taskgraph.executor.ICallableTaskFuture;
import com.ebay.taskgraph.executor.SynchronousFuture;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class JavaCallableTaskExecutor
implements ICallableTaskExecutor {
    private static final ExecutorService EXECUTOR = Executors.newCachedThreadPool();
    private final Map<String, ICallableTaskFuture<?>> tasks = new HashMap();

    @Override
    public <T> ICallableTaskFuture<T> addTask(ICallableTask<T> task) {
        boolean isAsync = CallableTaskExecutorHelper.isAsync(task);
        task = CallableTaskExecutorHelper.getDecoratedTask(this, task);
        Future<T> future = isAsync ? EXECUTOR.submit(task) : new SynchronousFuture<T>(task);
        CallableTaskFuture<T> result = new CallableTaskFuture<T>(future, task);
        this.tasks.put(task.getName(), result);
        return result;
    }

    @Override
    public void collectResponseContext(ICallableTask<?> parentTask) {
        for (Map.Entry<String, ICallableTaskFuture<?>> task : this.tasks.entrySet()) {
            parentTask.getContext().add(task.getValue().getTask().getContext());
        }
    }

    public static void shutdown() {
        EXECUTOR.shutdown();
    }

    @Override
    public <T> ICallableTaskFuture<T> getTask(String name) {
        return this.tasks.get(name);
    }
}

