/*
 * Decompiled with CFR 0.152.
 */
package com.ebay.taskgraph.executor;

import com.ebay.taskgraph.context.ResponseContext;
import com.ebay.taskgraph.diagnostic.IProfilerEntry;
import com.ebay.taskgraph.executor.ApplicationException;
import com.ebay.taskgraph.executor.CallableTaskConfig;
import com.ebay.taskgraph.executor.ICallableTask;
import com.ebay.taskgraph.executor.ICallableTaskFuture;
import com.ebay.taskgraph.executor.Task;

public class ProfileDecorator<T>
implements ICallableTask<T> {
    private static final String WAIT_DEPS = "wait_deps";
    private final ICallableTask<T> task;

    public ProfileDecorator(ICallableTask<T> task) {
        this.task = task;
    }

    @Override
    public T call() {
        IProfilerEntry pe = this.getContext().getProfiler().newEntry(WAIT_DEPS);
        try {
            this.task.waitForDependencies();
        }
        finally {
            this.getContext().getProfiler().add(pe);
        }
        return ProfileDecorator.profileTaskCall(this.task);
    }

    static <T> T profileTaskCall(ICallableTask<T> task) {
        task.getContext().getProfiler().start();
        T rval = null;
        try {
            rval = (T)task.call();
        }
        catch (ApplicationException bae) {
            throw bae;
        }
        catch (Throwable t) {
            Task.logTaskException(task, t);
        }
        finally {
            task.getContext().getProfiler().stop();
        }
        return rval;
    }

    @Override
    public String getName() {
        return this.task.getName();
    }

    @Override
    public ResponseContext getContext() {
        return this.task.getContext();
    }

    @Override
    public CallableTaskConfig getTaskConfig() {
        return this.task.getTaskConfig();
    }

    @Override
    public void waitForDependencies() {
        this.task.waitForDependencies();
    }

    @Override
    public ICallableTaskFuture<?>[] getDependencies() {
        return this.task.getDependencies();
    }
}

