/*
 * Decompiled with CFR 0.152.
 */
package com.ebay.taskgraph.executor;

import com.ebay.taskgraph.context.ResponseContext;
import com.ebay.taskgraph.diagnostic.DiagnosticConfig;
import com.ebay.taskgraph.executor.ApplicationException;
import com.ebay.taskgraph.executor.CallableTaskConfig;
import com.ebay.taskgraph.executor.ICallableTask;
import com.ebay.taskgraph.executor.ICallableTaskFuture;
import com.ebay.taskgraph.executor.JavaSupplierException;
import com.ebay.taskgraph.executor.workflow.WorkflowException;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Task {
    public static final String NODE_LABEL = "node_label";
    public static final String TASK_NAME = "task_name";
    public static final String DEPENDENCIES_META_DATA_KEY = "dependencies";
    public static final String DEPENDENCIES_SEPARATOR = ":";
    public static final String EXEC_TYPE = "execType";
    public static final String PARENT_TASK = "parent_task";
    public static final String TASK_THREAD = "task_thread";
    private static final Logger LOGGER = LoggerFactory.getLogger(Task.class);
    private static final String EXCEPTION_META_DATA_KEY = "exception";
    protected final String taskName;
    protected final ResponseContext context;
    protected final ICallableTaskFuture<?>[] dependencies;
    private final CallableTaskConfig config;

    protected Task(CallableTaskConfig config, ICallableTaskFuture<?> ... dependencies) {
        this.config = config;
        this.taskName = this.getClass().getSimpleName();
        this.context = Task.createResponseContext(config, this.taskName);
        this.dependencies = dependencies;
        this.setExecutionType();
    }

    protected Task(String taskName, DiagnosticConfig diagnosticConfig, ICallableTaskFuture<?> ... dependencies) {
        this(taskName, new CallableTaskConfig(diagnosticConfig, CallableTaskConfig.ExecType.SYNC), dependencies);
    }

    protected Task(String taskName, CallableTaskConfig config, ICallableTaskFuture<?> ... dependencies) {
        this.config = config;
        this.taskName = taskName;
        this.context = Task.createResponseContext(config, this.getClass().getSimpleName());
        this.dependencies = dependencies;
        this.setExecutionType();
    }

    protected Task(ResponseContext rc, CallableTaskConfig config, ICallableTaskFuture<?> ... dependencies) {
        this(rc.getName(), rc, config, dependencies);
    }

    protected Task(String taskName, ResponseContext rc, CallableTaskConfig config, ICallableTaskFuture<?> ... dependencies) {
        this.config = config;
        this.taskName = taskName;
        this.context = rc;
        this.dependencies = dependencies;
        this.setExecutionType();
    }

    private static ResponseContext createResponseContext(CallableTaskConfig config, String taskName) {
        return new ResponseContext(config.diagnosticConfig, taskName);
    }

    private void setExecutionType() {
        if (this.context.getDiagnosticConfig().profile || this.context.getDiagnosticConfig().showDiagnostics) {
            this.context.getProfiler().addData(EXEC_TYPE, this.config.execType.toString());
        }
        if (this.dependencies != null) {
            for (int i = 0; i < this.dependencies.length; ++i) {
                if (null != this.dependencies[i]) continue;
                throw new WorkflowException("Null dependency in task: " + this.taskName);
            }
        }
        if (!this.context.getName().equals(this.taskName)) {
            this.context.getProfiler().addData(TASK_NAME, this.taskName);
        }
    }

    public final String getName() {
        return this.taskName;
    }

    public final ResponseContext getContext() {
        return this.context;
    }

    public final CallableTaskConfig getTaskConfig() {
        return this.config;
    }

    public final ICallableTaskFuture<?>[] getDependencies() {
        return this.dependencies;
    }

    public static void logTaskException(ICallableTask<?> task, Throwable t) {
        if (t instanceof JavaSupplierException) {
            t = t.getCause();
        }
        Task.addProfileException(task, t);
        if (t instanceof ApplicationException) {
            throw (ApplicationException)t;
        }
        task.getContext().getDiagnostic().addThrowableDiagnostic(task.getContext().getName(), t);
        LOGGER.debug(task.getContext().getName(), t);
    }

    private static void addProfileException(ICallableTask<?> task, Throwable t) {
        task.getContext().getProfiler().addData(EXCEPTION_META_DATA_KEY, t.getClass().getSimpleName());
    }

    public void waitForDependencies() {
        ArrayList asyncDependencies = new ArrayList();
        for (ICallableTaskFuture<?> dep : this.dependencies) {
            if (CallableTaskConfig.ExecType.ASYNC.equals((Object)dep.getTask().getTaskConfig().execType) || CallableTaskConfig.ExecType.ASYNC_TIMEOUT.equals((Object)dep.getTask().getTaskConfig().execType)) {
                asyncDependencies.add(dep);
                continue;
            }
            dep.getNoThrow((ICallableTask)((Object)this));
        }
        for (ICallableTaskFuture iCallableTaskFuture : asyncDependencies) {
            iCallableTaskFuture.getNoThrow((ICallableTask)((Object)this));
        }
    }

    public static void addDependency(ICallableTask<?> task, ICallableTask<?> caller) {
        ResponseContext rc = task.getContext();
        if (caller != null) {
            Task.addDependency(rc, caller.getName());
        } else {
            LOGGER.error("Task {} called with null caller", (Object)task.getName());
        }
    }

    private static void addDependency(ResponseContext rc, String caller) {
        if (rc.getDiagnosticConfig().profile || rc.getDiagnosticConfig().showDiagnostics) {
            String dependencies = rc.getProfiler().getData(DEPENDENCIES_META_DATA_KEY);
            if (null == dependencies) {
                rc.getProfiler().addData(DEPENDENCIES_META_DATA_KEY, caller);
            } else {
                String[] dependencyList;
                boolean found = false;
                for (String d : dependencyList = dependencies.split(DEPENDENCIES_SEPARATOR)) {
                    if (!d.equals(caller)) continue;
                    found = true;
                }
                if (!found) {
                    dependencies = dependencies + DEPENDENCIES_SEPARATOR + caller;
                    rc.getProfiler().addData(DEPENDENCIES_META_DATA_KEY, dependencies);
                }
            }
        }
    }

    static void logParentTaskAndThread(ICallableTask<?> task, String parentTask) {
        ResponseContext rc = task.getContext();
        if (rc.getDiagnosticConfig().profile || rc.getDiagnosticConfig().showDiagnostics) {
            int i;
            String taskThread = Thread.currentThread().getName();
            rc.getProfiler().addData(PARENT_TASK, parentTask);
            if (taskThread.contains("Workflow") && (i = taskThread.indexOf(45)) > 0) {
                taskThread = taskThread.substring(i + 1);
            }
            rc.getProfiler().addData(TASK_THREAD, taskThread);
        }
    }

    static void addTaskResponseDiagnostic(ICallableTask<?> task, Object result) {
        for (ICallableTaskFuture<?> dep : task.getDependencies()) {
            task.getContext().getDiagnostic().addJsonDiagnostic(task.getName(), dep.getTask().getName(), dep.getNoThrow(task));
        }
        task.getContext().getDiagnostic().addJsonDiagnostic(task.getName(), "Response", result);
    }
}

