/*
 * Decompiled with CFR 0.152.
 */
package com.ebay.taskgraph.executor;

import com.ebay.taskgraph.context.ResponseContext;
import com.ebay.taskgraph.executor.CallableTaskConfig;
import com.ebay.taskgraph.executor.ICallableTask;
import com.ebay.taskgraph.executor.ICallableTaskFuture;
import com.ebay.taskgraph.executor.Task;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class TaskThreadLoggingDecorator<T>
implements ICallableTask<T> {
    private static final Map<String, String> CURRENT_THREAD_TASK = Collections.synchronizedMap(new HashMap());
    private final ICallableTask<T> task;
    private final String parentTask;

    public TaskThreadLoggingDecorator(ICallableTask<T> task) {
        this.task = task;
        this.parentTask = TaskThreadLoggingDecorator.getCurrentTask();
    }

    @Override
    public T call() throws Exception {
        Task.logParentTaskAndThread(this.task, this.parentTask);
        String previousTask = TaskThreadLoggingDecorator.setCurrentTask(this.task.getName());
        Object result = this.task.call();
        TaskThreadLoggingDecorator.setCurrentTask(previousTask);
        return (T)result;
    }

    @Override
    public String getName() {
        return this.task.getName();
    }

    @Override
    public ResponseContext getContext() {
        return this.task.getContext();
    }

    @Override
    public CallableTaskConfig getTaskConfig() {
        return this.task.getTaskConfig();
    }

    @Override
    public void waitForDependencies() {
        this.task.waitForDependencies();
    }

    @Override
    public ICallableTaskFuture<?>[] getDependencies() {
        return this.task.getDependencies();
    }

    private static String getCurrentTask() {
        return CURRENT_THREAD_TASK.get(Thread.currentThread().getName());
    }

    private static String setCurrentTask(String taskName) {
        String rval = CURRENT_THREAD_TASK.get(Thread.currentThread().getName());
        CURRENT_THREAD_TASK.put(Thread.currentThread().getName(), taskName);
        return rval;
    }
}

