/*
 * Decompiled with CFR 0.152.
 */
package com.ebay.taskgraph.executor.workflow;

import com.ebay.taskgraph.executor.ICallableTaskFuture;
import com.ebay.taskgraph.executor.workflow.ITaskFactory;
import com.ebay.taskgraph.executor.workflow.IWorkflowBuilder;
import com.ebay.taskgraph.executor.workflow.WorkflowException;

public class TaskInstance<V, S extends IWorkflowBuilder> {
    private boolean initialized = false;
    private boolean initializing = false;
    private ICallableTaskFuture<V> instance;
    private final ITaskFactory<S, V> factory;

    public TaskInstance(ITaskFactory<S, V> factory) {
        this.factory = factory;
    }

    public ICallableTaskFuture<V> get(S builder) {
        if (!this.initialized) {
            if (this.initializing) {
                throw new WorkflowException("Cycle detected on task factory: " + this.factory.getClass().getCanonicalName());
            }
            this.initializing = true;
            this.instance = this.factory.create(builder);
            this.initialized = true;
        }
        return this.instance;
    }
}

