/*
 * Decompiled with CFR 0.152.
 */
package com.ebay.taskgraph.executor.workflow;

import com.ebay.taskgraph.context.ResponseContext;
import com.ebay.taskgraph.executor.CallableTaskConfig;
import com.ebay.taskgraph.executor.ICallableTask;
import com.ebay.taskgraph.executor.ICallableTaskFuture;
import com.ebay.taskgraph.executor.Task;
import com.ebay.taskgraph.executor.workflow.IVisiteeProvider;
import com.ebay.taskgraph.executor.workflow.IVisitor;
import com.ebay.taskgraph.executor.workflow.IWorkflow;
import com.ebay.taskgraph.executor.workflow.WorkflowException;
import java.util.List;

public abstract class VisitorTask<T>
extends Task
implements ICallableTask<Boolean>,
IVisitor<T> {
    private List<T> visitees = null;

    public VisitorTask(CallableTaskConfig config, ICallableTaskFuture<?> ... dependencies) {
        super(config, dependencies);
    }

    public VisitorTask(String name, CallableTaskConfig config, ICallableTaskFuture<?> ... dependencies) {
        super(name, config, dependencies);
    }

    public VisitorTask(String name, ResponseContext context, CallableTaskConfig config, ICallableTaskFuture<?> ... dependencies) {
        super(name, context, config, dependencies);
    }

    private void setVisitees(List<T> visitees) {
        this.visitees = visitees;
    }

    @Override
    public Boolean call() {
        if (null == this.visitees) {
            throw new WorkflowException("Need to VisitorTask.visit() method so visitees are initialized.");
        }
        for (T visitee : this.visitees) {
            try {
                this.visit(visitee);
            }
            catch (Throwable t) {
                Task.logTaskException(this, t);
            }
        }
        return Boolean.TRUE;
    }

    static <T, V> List<T> visit(IVisiteeProvider<T> provider, List<VisitorTask<T>> visitors, IWorkflow<V> workflow) {
        List<T> visitees = provider.get();
        if (visitees != null && visitees.size() > 0) {
            for (VisitorTask<T> visitor : visitors) {
                super.setVisitees(visitees);
                workflow.addTask(visitor).getNoThrow(workflow.getTask());
            }
        }
        return visitees;
    }
}

