/*
 * Decompiled with CFR 0.152.
 */
package com.ebay.taskgraph.executor.workflow;

import com.ebay.taskgraph.context.ResponseContext;
import com.ebay.taskgraph.executor.ICallableTask;
import com.ebay.taskgraph.executor.ICallableTaskExecutor;
import com.ebay.taskgraph.executor.ICallableTaskFuture;
import com.ebay.taskgraph.executor.workflow.IWorkflow;
import com.ebay.taskgraph.executor.workflow.IWorkflowFactory;

public class Workflow<V>
implements IWorkflow<V> {
    private final ICallableTask<V> task;
    private IWorkflowFactory workflowFactory;
    private final ICallableTaskExecutor executor;

    public Workflow(ICallableTask<V> task, IWorkflowFactory workflowFactory, ICallableTaskExecutor executor) {
        this.task = task;
        this.workflowFactory = workflowFactory;
        this.executor = executor;
        this.task.getContext().getProfiler().start();
    }

    @Override
    public ICallableTask<V> getTask() {
        return this.task;
    }

    @Override
    public <T> ICallableTaskFuture<T> addTask(ICallableTask<T> task) {
        return this.executor.addTask(task);
    }

    @Override
    public ResponseContext collectResponseContext() {
        this.executor.collectResponseContext(this.task);
        ResponseContext aggregateContext = this.task.getContext();
        aggregateContext.getProfiler().stop();
        return aggregateContext;
    }

    @Override
    public <T> IWorkflow<T> create(ICallableTask<T> task) {
        return this.workflowFactory.create(task);
    }
}

