/*
 * Decompiled with CFR 0.152.
 */
package com.ebay.taskgraph.executor.workflow;

import com.ebay.taskgraph.context.ResponseContext;
import com.ebay.taskgraph.executor.CallableTaskConfig;
import com.ebay.taskgraph.executor.ICallableTask;
import com.ebay.taskgraph.executor.ICallableTaskFuture;
import com.ebay.taskgraph.executor.Task;
import com.ebay.taskgraph.executor.workflow.IWorkflow;
import com.ebay.taskgraph.executor.workflow.IWorkflowExecutor;
import com.ebay.taskgraph.executor.workflow.IWorkflowFactory;

public class WorkflowTask<T>
extends Task
implements ICallableTask<T> {
    private final IWorkflowFactory workflowFactory;
    private final IWorkflowExecutor<T> executor;

    public WorkflowTask(CallableTaskConfig config, IWorkflowFactory workflowFactory, IWorkflowExecutor<T> executor, ICallableTaskFuture<?> ... dependencies) {
        this(executor.getClass().getSimpleName(), config, workflowFactory, executor, dependencies);
    }

    public WorkflowTask(String taskName, CallableTaskConfig config, IWorkflowFactory workflowFactory, IWorkflowExecutor<T> executor, ICallableTaskFuture<?> ... dependencies) {
        super(taskName, new ResponseContext(config.diagnosticConfig, executor.getClass().getSimpleName()), config, dependencies);
        this.workflowFactory = workflowFactory;
        this.executor = executor;
    }

    @Override
    public T call() {
        IWorkflow workflow = this.workflowFactory.create(this);
        try {
            T t = this.executor.execute(workflow);
            return t;
        }
        finally {
            workflow.collectResponseContext();
        }
    }
}

