/*
 * Decompiled with CFR 0.152.
 */
package com.ebay.taskgraph.executor.workflow.latch;

import com.ebay.taskgraph.executor.ICallableTask;
import com.ebay.taskgraph.executor.Task;
import com.ebay.taskgraph.executor.workflow.latch.SingleCountDownLatchTask;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class SingleCountDownLatch<T> {
    private final CountDownLatch latch = new CountDownLatch(1);
    private SingleCountDownLatchTask<T> countDownTask;

    void countDown(SingleCountDownLatchTask<T> countDownTask) {
        this.countDownTask = countDownTask;
        this.latch.countDown();
    }

    T await(long timeout, ICallableTask<?> caller) throws InterruptedException {
        if (this.latch.await(timeout, TimeUnit.MILLISECONDS)) {
            Task.addDependency(this.countDownTask, caller);
            return this.countDownTask.getTask().getNoThrow(caller);
        }
        return null;
    }
}

